/*
 *  Copyright (c) 2011-2017 Contributors to the Eclipse Foundation
 *
 *  See the NOTICE file(s) distributed with this work for additional
 *  information regarding copyright ownership.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  Contributors:
 */

package config.seimpl.converters;

import java.time.Instant;

import org.eclipse.microprofile.config.spi.Converter;

/**
 * Created by starksm on 6/3/17.
 */
public class InstantConverter implements Converter<Instant> {
    @Override
    public Instant convert(String value) {
        return value != null ? Instant.parse(value) : Instant.EPOCH;
    }
}
