/*
 * Copyright 2014 Red Hat, Inc.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  and Apache License v2.0 which accompanies this distribution.
 *
 *  The Eclipse Public License is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  The Apache License v2.0 is available at
 *  http://www.opensource.org/licenses/apache2.0.php
 *
 *  You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.ext.web.templ.jte.impl;


import gg.jte.output.Utf8ByteOutput;
import io.vertx.core.buffer.Buffer;

import java.io.IOException;
import java.io.UncheckedIOException;

/**
 * @author <a href="mailto:andy@mazebert.com">Andreas Hager</a>
 */
public class JteBufferUtil {

  public static Buffer toBuffer(Utf8ByteOutput output) {
    Buffer buffer = Buffer.buffer(output.getContentLength());

    try {
      output.writeTo(buffer::appendBytes);
    } catch (IOException e) {
      throw new UncheckedIOException(e);
    }

    return buffer;
  }
}
