/*
 * Copyright 2014, gRPC Authors All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.grpc.internal;

import static com.google.common.base.Charsets.UTF_8;

import java.nio.ByteBuffer;

/**
 * Tests for the array-backed {@link ReadableBuffer} returned by {@link
 * ReadableBuffers#wrap(ByteBuffer)}.
 */
public class ReadableBuffersByteBufferTest extends ReadableBufferTestBase {

  @Override
  protected ReadableBuffer buffer() {
    return ReadableBuffers.wrap(ByteBuffer.wrap(msg.getBytes(UTF_8)));
  }
}
