/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.net;

import com.mchange.net.MailSender;
import com.mchange.net.MimeUtils;
import com.mchange.net.ProtocolException;
import com.mchange.net.SmtpException;
import com.mchange.net.SmtpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class SmtpMailSender
implements MailSender {
    InetAddress hostAddr;
    int port;

    public SmtpMailSender(InetAddress hostAddr, int port) {
        this.hostAddr = hostAddr;
        this.port = port;
    }

    public SmtpMailSender(InetAddress hostAddr) {
        this(hostAddr, 25);
    }

    public SmtpMailSender(String host, int port) throws UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    public SmtpMailSender(String host) throws UnknownHostException {
        this(host, 25);
    }

    public void sendMail(String from, String[] to, String[] cc, String[] bcc, String subject, String body, String enc) throws IOException, ProtocolException, UnsupportedEncodingException {
        String[] rcptTo;
        if (to == null || to.length < 1) {
            throw new SmtpException("You must specify at least one recipient in the \"to\" field.");
        }
        Properties headers = new Properties();
        headers.put("From", from);
        headers.put("To", SmtpMailSender.makeRecipientString(to));
        headers.put("Subject", subject);
        headers.put("MIME-Version", "1.0");
        headers.put("Content-Type", "text/plain; charset=" + MimeUtils.normalEncoding(enc));
        headers.put("X-Generator", this.getClass().getName());
        if (cc != null || bcc != null) {
            int recipients = to.length + (cc != null ? cc.length : 0) + (bcc != null ? bcc.length : 0);
            rcptTo = new String[recipients];
            int next_r = 0;
            System.arraycopy(to, 0, rcptTo, next_r, to.length);
            next_r += to.length;
            if (cc != null) {
                System.arraycopy(cc, 0, rcptTo, next_r, cc.length);
                next_r += cc.length;
                headers.put("CC", SmtpMailSender.makeRecipientString(cc));
            }
            if (bcc != null) {
                System.arraycopy(bcc, 0, rcptTo, next_r, bcc.length);
            }
        } else {
            rcptTo = to;
        }
        SmtpUtils.sendMail(this.hostAddr, this.port, from, rcptTo, headers, body.getBytes(enc));
    }

    public void sendMail(String from, String[] to, String[] cc, String[] bcc, String subject, String body) throws IOException, ProtocolException {
        try {
            this.sendMail(from, to, cc, bcc, subject, body, System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Default encoding [" + System.getProperty("file.encoding") + "] not supported???");
        }
    }

    private static String makeRecipientString(String[] to) {
        StringBuffer sb = new StringBuffer(256);
        int len = to.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(to[i]);
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        try {
            String[] to = new String[]{"stevewaldman@uky.edu"};
            String[] cc = new String[]{};
            String[] bcc = new String[]{"stevewaldman@mac.com"};
            String from = "swaldman@mchange.com";
            String subject = "Test SmtpMailSender Again";
            String body = "Wheeeee!!!";
            SmtpMailSender sender = new SmtpMailSender("localhost");
            sender.sendMail(from, to, cc, bcc, subject, body);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

