/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v1.cachedstore.CachedStore;
import com.mchange.v1.cachedstore.CachedStoreException;
import com.mchange.v1.cachedstore.CachedStoreFactory;
import com.mchange.v1.cachedstore.CachedStoreUtils;
import com.mchange.v1.util.ArrayUtils;
import com.mchange.v2.cfg.ConfigUtils;
import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MConfig {
    private static final MLogger logger = MLog.getLogger(MConfig.class);
    private static final Map<DelayedLogItem.Level, MLevel> levelMap;
    static final CachedStore cache;

    public static MultiPropertiesConfig readVmConfig(String[] defaults, String[] preempts) {
        try {
            return (MultiPropertiesConfig)cache.find(new PathsKey(defaults, preempts));
        }
        catch (CachedStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiPropertiesConfig readVmConfig() {
        return MConfig.readVmConfig(ConfigUtils.NO_PATHS, ConfigUtils.NO_PATHS);
    }

    public static MultiPropertiesConfig readConfig(String[] resourcePaths) {
        try {
            return (MultiPropertiesConfig)cache.find(new PathsKey(resourcePaths));
        }
        catch (CachedStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiPropertiesConfig combine(MultiPropertiesConfig[] configs) {
        return ConfigUtils.combine(configs);
    }

    public static void dumpToLogger(List<DelayedLogItem> items, MLogger logger) {
        for (DelayedLogItem item : items) {
            MConfig.dumpToLogger(item, logger);
        }
    }

    public static void dumpToLogger(DelayedLogItem item, MLogger logger) {
        logger.log(levelMap.get((Object)item.getLevel()), item.getText(), item.getException());
    }

    private MConfig() {
    }

    static {
        try {
            HashMap<DelayedLogItem.Level, MLevel> lm = new HashMap<DelayedLogItem.Level, MLevel>();
            for (DelayedLogItem.Level level : DelayedLogItem.Level.values()) {
                lm.put(level, (MLevel)MLevel.class.getField(level.toString()).get(null));
            }
            levelMap = Collections.unmodifiableMap(lm);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        cache = CachedStoreUtils.synchronizedCachedStore(CachedStoreFactory.createNoCleanupCachedStore(new CSManager()));
    }

    private static class CSManager
    implements CachedStore.Manager {
        private CSManager() {
        }

        public boolean isDirty(Object key, Object cached) throws Exception {
            return false;
        }

        public Object recreateFromKey(Object key) throws Exception {
            PathsKey pk = (PathsKey)key;
            ArrayList<DelayedLogItem> items = new ArrayList<DelayedLogItem>();
            items.addAll(pk.delayedLogItems);
            MultiPropertiesConfig out = ConfigUtils.read(pk.paths, items);
            MConfig.dumpToLogger(items, logger);
            return out;
        }
    }

    private static final class PathsKey {
        String[] paths;
        List delayedLogItems;

        public boolean equals(Object o) {
            if (o instanceof PathsKey) {
                return Arrays.equals(this.paths, ((PathsKey)o).paths);
            }
            return false;
        }

        public int hashCode() {
            return ArrayUtils.hashArray(this.paths);
        }

        PathsKey(String[] defaults, String[] preempts) {
            this.delayedLogItems = new ArrayList();
            List pathList = ConfigUtils.vmCondensedPaths(defaults, preempts, this.delayedLogItems);
            this.paths = pathList.toArray(new String[pathList.size()]);
        }

        PathsKey(String[] paths) {
            this.delayedLogItems = Collections.emptyList();
            this.paths = paths;
        }
    }
}

