/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import com.mchange.lang.IntegerUtils;

public final class FloatUtils {
    static final boolean DEBUG = true;
    private static FParser fParser;

    public static byte[] byteArrayFromFloat(float f) {
        int i = Float.floatToIntBits(f);
        return IntegerUtils.byteArrayFromInt(i);
    }

    public static float floatFromByteArray(byte[] b, int offset) {
        int i = IntegerUtils.intFromByteArray(b, offset);
        return Float.intBitsToFloat(i);
    }

    public static float parseFloat(String fStr, float dflt) {
        if (fStr == null) {
            return dflt;
        }
        try {
            return fParser.parseFloat(fStr);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public static float parseFloat(String fStr) throws NumberFormatException {
        return fParser.parseFloat(fStr);
    }

    public static String floatToString(float f, int precision) {
        boolean negative = f < 0.0f;
        f = negative ? -f : f;
        long whole_rep = Math.round((double)f * Math.pow(10.0, -precision));
        String wholeRepStr = String.valueOf(whole_rep);
        if (whole_rep == 0L) {
            return wholeRepStr;
        }
        int whole_len = wholeRepStr.length();
        int pre_len = whole_len + precision;
        StringBuffer sb = new StringBuffer(32);
        if (negative) {
            sb.append('-');
        }
        if (pre_len <= 0) {
            sb.append("0.");
            for (int i = 0; i < -pre_len; ++i) {
                sb.append('0');
            }
            sb.append(wholeRepStr);
        } else {
            sb.append(wholeRepStr.substring(0, Math.min(pre_len, whole_len)));
            if (pre_len < whole_len) {
                sb.append('.');
                sb.append(wholeRepStr.substring(pre_len));
            } else if (pre_len > whole_len) {
                int len = pre_len - whole_len;
                for (int i = 0; i < len; ++i) {
                    sb.append('0');
                }
            }
        }
        return sb.toString();
    }

    static {
        try {
            fParser = new J12FParser();
            fParser.parseFloat("0.1");
        }
        catch (NoSuchMethodError e) {
            System.err.println("com.mchange.lang.FloatUtils: reconfiguring for Java 1.1 environment");
            fParser = new J11FParser();
        }
    }

    static class J11FParser
    implements FParser {
        J11FParser() {
        }

        public float parseFloat(String fStr) throws NumberFormatException {
            return new Float(fStr).floatValue();
        }
    }

    static class J12FParser
    implements FParser {
        J12FParser() {
        }

        public float parseFloat(String fStr) throws NumberFormatException {
            return Float.parseFloat(fStr);
        }
    }

    static interface FParser {
        public float parseFloat(String var1) throws NumberFormatException;
    }
}

