/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.util.StopWatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserControl {
    private static final String CAPTURE_URL = String.format("%%s/capture/%s/%%s/%s/%%s/%s/%%s/", "id", "timeout", "upload_size");
    private static final Logger logger = LoggerFactory.getLogger(BrowserControl.class);
    private final BrowserRunner runner;
    private final String serverAddress;
    private final StopWatch stopWatch;
    private final JsTestDriverClient client;

    public BrowserControl(BrowserRunner runner, String serverAddress, StopWatch stopWatch, JsTestDriverClient client) {
        this.runner = runner;
        this.serverAddress = serverAddress;
        this.stopWatch = stopWatch;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String captureBrowser(String browserId) throws InterruptedException {
        String string;
        try {
            this.stopWatch.start("browser start %s", browserId);
            String url = String.format(CAPTURE_URL, this.serverAddress, browserId, this.runner.getHeartbeatTimeout(), this.runner.getUploadSize());
            this.runner.startBrowser(url);
            long timeOut = TimeUnit.MILLISECONDS.convert(this.runner.getTimeout(), TimeUnit.SECONDS);
            long start = System.currentTimeMillis();
            try {
                this.stopWatch.start("Capturing browser", browserId);
                while (!this.isBrowserCaptured(browserId, this.client)) {
                    Thread.sleep(50L);
                    if (System.currentTimeMillis() - start <= timeOut) continue;
                    throw new RuntimeException("Could not start browser " + this.runner + " in " + this.runner.getTimeout());
                }
            }
            catch (Throwable throwable) {
                this.stopWatch.stop("Capturing browser", browserId);
                throw throwable;
            }
            this.stopWatch.stop("Capturing browser", browserId);
            logger.debug("Browser {} started with id {}", this.runner, (Object)browserId);
            string = browserId;
        }
        catch (Throwable throwable) {
            this.stopWatch.stop("browser start %s", browserId);
            throw throwable;
        }
        this.stopWatch.stop("browser start %s", browserId);
        return string;
    }

    public void stopBrowser() {
        this.stopWatch.start("browser stop %s", this.runner);
        this.runner.stopBrowser();
        this.stopWatch.stop("browser stop %s", this.runner);
    }

    public boolean isBrowserCaptured(String browserId, JsTestDriverClient client) {
        for (BrowserInfo browserInfo : client.listBrowsers()) {
            if (!browserId.equals(String.valueOf(browserInfo.getId())) || !browserInfo.serverReceivedHeartbeat() || !browserInfo.browserReady()) continue;
            logger.debug("Started {}", browserInfo);
            return true;
        }
        return false;
    }
}

