/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.ActionSequenceBuilder;
import com.google.jstestdriver.hooks.ActionListProcessor;
import com.google.jstestdriver.output.XmlPrinter;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultActionListProvider
implements ActionListProvider {
    private final List<String> tests;
    private final List<String> arguments;
    private final boolean reset;
    private final List<String> dryRunFor;
    private final int port;
    private final int sslPort;
    private final String testOutput;
    private final Set<ActionListProcessor> processors;
    private final XmlPrinter xmlPrinter;
    private final ActionSequenceBuilder builder;
    private final boolean raiseOnFailure;

    @Inject
    public DefaultActionListProvider(@Named(value="tests") List<String> tests, @Named(value="arguments") List<String> arguments, @Named(value="reset") boolean reset, @Named(value="dryRunFor") List<String> dryRunFor, @Named(value="port") int port, @Named(value="sslPort") int sslPort, @Named(value="testOutput") String testOutput, Set<ActionListProcessor> processors, XmlPrinter xmlPrinter, ActionSequenceBuilder builder, @Named(value="raiseOnFailure") boolean raiseOnFailure) {
        this.tests = tests;
        this.arguments = arguments;
        this.reset = reset;
        this.dryRunFor = dryRunFor;
        this.port = port;
        this.sslPort = sslPort;
        this.testOutput = testOutput;
        this.processors = processors;
        this.xmlPrinter = xmlPrinter;
        this.builder = builder;
        this.raiseOnFailure = raiseOnFailure;
    }

    @Override
    @Provides
    public List<Action> get() {
        this.builder.addTests(this.tests).addCommands(this.arguments).reset(this.reset).asDryRunFor(this.dryRunFor).withLocalServerPort(this.port).withLocalServerSslPort(this.sslPort);
        if (this.raiseOnFailure) {
            this.builder.raiseOnFailure();
        }
        if (this.testOutput.length() > 0) {
            this.builder.printingResultsWhenFinished(this.xmlPrinter);
        }
        List<Action> actions = this.builder.build();
        for (ActionListProcessor processor : this.processors) {
            actions = processor.process(actions);
        }
        return actions;
    }
}

