/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jvyaml.Composer;
import org.jvyaml.ComposerException;
import org.jvyaml.Parser;
import org.jvyaml.ParserImpl;
import org.jvyaml.Resolver;
import org.jvyaml.ResolverImpl;
import org.jvyaml.ScannerImpl;
import org.jvyaml.events.AliasEvent;
import org.jvyaml.events.Event;
import org.jvyaml.events.MappingEndEvent;
import org.jvyaml.events.MappingStartEvent;
import org.jvyaml.events.NodeEvent;
import org.jvyaml.events.ScalarEvent;
import org.jvyaml.events.SequenceEndEvent;
import org.jvyaml.events.SequenceStartEvent;
import org.jvyaml.events.StreamEndEvent;
import org.jvyaml.events.StreamStartEvent;
import org.jvyaml.nodes.MappingNode;
import org.jvyaml.nodes.Node;
import org.jvyaml.nodes.ScalarNode;
import org.jvyaml.nodes.SequenceNode;

public class ComposerImpl
implements Composer {
    private Parser parser;
    private Resolver resolver;
    private Map anchors;
    private static final boolean[] FALS = new boolean[]{false};
    private static final boolean[] TRU = new boolean[]{true};

    public ComposerImpl(Parser parser, Resolver resolver) {
        this.parser = parser;
        this.resolver = resolver;
        this.anchors = new HashMap();
    }

    public boolean checkNode() {
        return !(this.parser.peekEvent() instanceof StreamEndEvent);
    }

    public Node getNode() {
        return this.checkNode() ? this.composeDocument() : (Node)null;
    }

    public Iterator eachNode() {
        return new NodeIterator();
    }

    public Iterator iterator() {
        return this.eachNode();
    }

    public Node composeDocument() {
        if (this.parser.peekEvent() instanceof StreamStartEvent) {
            this.parser.getEvent();
        }
        this.parser.getEvent();
        Node node = this.composeNode(null, null);
        this.parser.getEvent();
        this.anchors.clear();
        return node;
    }

    public Node composeNode(Node parent, Object index) {
        if (this.parser.peekEvent() instanceof AliasEvent) {
            AliasEvent event = (AliasEvent)this.parser.getEvent();
            String anchor = event.getAnchor();
            if (!this.anchors.containsKey(anchor)) {
                System.err.println(" for aliasEvent: " + event);
                throw new ComposerException(null, "found undefined alias " + anchor, null);
            }
            return (Node)this.anchors.get(anchor);
        }
        Event event = this.parser.peekEvent();
        String anchor = null;
        if (event instanceof NodeEvent) {
            anchor = ((NodeEvent)event).getAnchor();
        }
        if (null != anchor && this.anchors.containsKey(anchor)) {
            throw new ComposerException("found duplicate anchor " + anchor + "; first occurence", null, null);
        }
        this.resolver.descendResolver(parent, index);
        Node node = null;
        if (event instanceof ScalarEvent) {
            ScalarEvent ev = (ScalarEvent)this.parser.getEvent();
            String tag = ev.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(ScalarNode.class, ev.getValue(), ev.getImplicit());
            }
            node = new ScalarNode(tag, ev.getValue(), ev.getStyle());
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
        } else if (event instanceof SequenceStartEvent) {
            SequenceStartEvent start = (SequenceStartEvent)this.parser.getEvent();
            String tag = start.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(SequenceNode.class, null, start.getImplicit() ? TRU : FALS);
            }
            node = new SequenceNode(tag, new ArrayList(), start.getFlowStyle());
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
            int ix = 0;
            while (!(this.parser.peekEvent() instanceof SequenceEndEvent)) {
                ((List)node.getValue()).add(this.composeNode(node, new Integer(ix++)));
            }
            this.parser.getEvent();
        } else if (event instanceof MappingStartEvent) {
            MappingStartEvent start = (MappingStartEvent)this.parser.getEvent();
            String tag = start.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(MappingNode.class, null, start.getImplicit() ? TRU : FALS);
            }
            node = new MappingNode(tag, new HashMap(), start.getFlowStyle());
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
            while (!(this.parser.peekEvent() instanceof MappingEndEvent)) {
                Event key = this.parser.peekEvent();
                Node itemKey = this.composeNode(node, null);
                if (((Map)node.getValue()).containsKey(itemKey)) {
                    this.composeNode(node, itemKey);
                    continue;
                }
                ((Map)node.getValue()).put(itemKey, this.composeNode(node, itemKey));
            }
            this.parser.getEvent();
        }
        this.resolver.ascendResolver();
        return node;
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        StringBuffer input = new StringBuffer();
        FileReader reader = new FileReader(filename);
        char[] buff = new char[1024];
        int read = 0;
        do {
            read = reader.read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((Reader)reader).close();
        String str = input.toString();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ComposerImpl cmp = new ComposerImpl(new ParserImpl(new ScannerImpl(str)), new ResolverImpl());
            Iterator iter = cmp.eachNode();
            while (iter.hasNext()) {
                System.out.println(iter.next());
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }

    private class NodeIterator
    implements Iterator {
        private NodeIterator() {
        }

        public boolean hasNext() {
            return ComposerImpl.this.checkNode();
        }

        public Object next() {
            return ComposerImpl.this.getNode();
        }

        public void remove() {
        }
    }
}

