/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.gateway;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.server.gateway.GatewayEntityMethod;
import com.google.jstestdriver.server.gateway.GatewayMethod;
import com.google.jstestdriver.server.gateway.Streams;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.mortbay.jetty.Response;

public class GatewayRequestHandler
implements RequestHandler {
    private static final String HOST = "Host";
    private static final String LOCATION = "Location";
    private static final String PRAGMA = "Pragma";
    private static final String REQUEST_URI_DOES_NOT_START_WITH_PREFIX = "Request URI '%s' does not start with prefix '%s'.";
    private static final String X_SUPPRESS_STATUS_CODE = "X-Suppress-Status-Code";
    private static final String X_SUPPRESSED_STATUS_CODE = "X-Suppressed-Status-Code";
    private static final String X_SUPPRESSED_REASON_PHRASE = "X-Suppressed-Reason-Phrase";
    private final HttpClient client;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String destination;
    private final String prefix;

    @Inject
    public GatewayRequestHandler(HttpClient client, HttpServletRequest req, HttpServletResponse res, @Assisted(value="destination") String destination, @Assisted(value="prefix") String prefix) {
        this.client = client;
        this.request = req;
        this.response = res;
        this.destination = destination;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIt() throws IOException {
        HttpMethodBase method = this.getMethod(this.request);
        this.addRequestHeaders(method, this.request);
        method.setQueryString(this.request.getQueryString());
        this.spoofHostHeader(method);
        try {
            int statusCode = this.client.executeMethod(method);
            this.response.setStatus(statusCode);
            this.addResponseHeaders(method, this.response);
            if (this.isRedirect(statusCode)) {
                this.spoofLocationHeader(this.request, (Response)this.response);
            }
            if (this.isStatusCodeSuppressed(this.request)) {
                this.response.setStatus(200);
                this.response.addIntHeader(X_SUPPRESSED_STATUS_CODE, statusCode);
                this.response.addHeader(X_SUPPRESSED_REASON_PHRASE, method.getStatusText());
            }
            Streams.copy(method.getResponseBodyAsStream(), this.response.getOutputStream());
        }
        catch (IOException e) {
            this.response.setStatus(502);
            e.printStackTrace(this.response.getWriter());
        }
        finally {
            method.releaseConnection();
        }
    }

    private boolean isStatusCodeSuppressed(HttpServletRequest request) {
        return Iterators.contains(Iterators.forEnumeration(request.getHeaders(PRAGMA)), X_SUPPRESS_STATUS_CODE);
    }

    private HttpMethodBase getMethod(HttpServletRequest request) throws IOException {
        HttpMethod method = HttpMethod.valueOf(request.getMethod());
        String uri = request.getRequestURI();
        if (this.prefix != null && !uri.startsWith(this.prefix)) {
            throw new RuntimeException(String.format(REQUEST_URI_DOES_NOT_START_WITH_PREFIX, uri, this.prefix));
        }
        String url = this.prefix == null ? this.destination + uri : this.destination + uri.substring(this.prefix.length());
        switch (method) {
            case POST: 
            case PUT: {
                return new GatewayEntityMethod(method.name(), url, request.getInputStream());
            }
        }
        return new GatewayMethod(method.name(), url);
    }

    private void addRequestHeaders(HttpMethodBase method, HttpServletRequest request) {
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                method.addRequestHeader(name, value);
            }
        }
    }

    private void spoofHostHeader(HttpMethodBase method) {
        method.setRequestHeader(HOST, this.parseUri(this.destination).getAuthority());
    }

    private URI parseUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException badUriSyntax) {
            throw new RuntimeException(badUriSyntax);
        }
    }

    private void addResponseHeaders(HttpMethodBase method, HttpServletResponse response) {
        for (Header header : method.getResponseHeaders()) {
            response.addHeader(header.getName(), header.getValue());
        }
    }

    private boolean isRedirect(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    void spoofLocationHeader(HttpServletRequest request, Response response) {
        URI location = this.parseUri(response.getHeader(LOCATION));
        String host = request.getServerName();
        int port = request.getServerPort();
        URI destination = this.parseUri(this.destination);
        if (location.getHost() == null || !location.getHost().equals(destination.getHost())) {
            return;
        }
        if (location.getPort() == destination.getPort() || location.getPort() == -1 && (destination.getPort() == 80 || destination.getPort() == 443)) {
            response.setHeader(LOCATION, this.buildLocationHeader(location, host, port));
        }
    }

    private String buildLocationHeader(URI location, String host, int port) {
        try {
            return new URI(location.getScheme(), String.format("%s:%s", host, port), location.getPath(), location.getQuery(), location.getFragment()).toString();
        }
        catch (URISyntaxException badUriSyntax) {
            throw new RuntimeException(badUriSyntax);
        }
    }

    public static interface Factory {
        public GatewayRequestHandler create(@Assisted(value="destination") String var1, @Assisted(value="prefix") String var2);
    }
}

