/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.NullRequestHandler;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.requesthandlers.RequestMatcher;
import com.google.jstestdriver.server.gateway.GatewayRequestHandler;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GatewayConfiguration.class);
    public static final String MATCHER = "matcher";
    public static final String SERVER = "server";
    private final GatewayRequestHandler.Factory gatewayFactory;
    private JsonArray gatewayConfig = new JsonArray();
    private List<RequestMatcher> matchers;
    private Map<RequestMatcher, String> destinations;

    @Inject
    public GatewayConfiguration(GatewayRequestHandler.Factory gatewayFactory) {
        this.gatewayFactory = gatewayFactory;
        this.clearConfiguration();
    }

    public synchronized List<RequestMatcher> getMatchers() {
        return this.matchers;
    }

    public synchronized RequestHandler getRequestHandler(RequestMatcher matcher) {
        String destination = this.destinations.get(matcher);
        return destination == null ? new NullRequestHandler() : this.gatewayFactory.create(destination, matcher.getPrefix());
    }

    public synchronized JsonArray getGatewayConfig() {
        return this.gatewayConfig;
    }

    public synchronized void updateConfiguration(JsonArray configuration) throws ServletException {
        this.gatewayConfig = configuration;
        ImmutableList.Builder<RequestMatcher> listBuilder = ImmutableList.builder();
        ImmutableMap.Builder<RequestMatcher, String> mapBuilder = ImmutableMap.builder();
        for (JsonElement element : configuration) {
            JsonObject entry = element.getAsJsonObject();
            RequestMatcher matcher = new RequestMatcher(HttpMethod.ANY, entry.get(MATCHER).getAsString());
            listBuilder.add(matcher);
            mapBuilder.put(matcher, entry.get(SERVER).getAsString());
        }
        this.matchers = listBuilder.build();
        this.destinations = mapBuilder.build();
    }

    public synchronized void clearConfiguration() {
        this.matchers = ImmutableList.of();
        this.destinations = ImmutableMap.of();
    }
}

