/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.plugins.testisolation;

import com.google.common.collect.Lists;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.hooks.JstdTestCaseProcessor;
import com.google.jstestdriver.model.JstdTestCase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolationTestCaseProcessor
implements JstdTestCaseProcessor {
    @Override
    public List<JstdTestCase> process(Iterator<JstdTestCase> testCasesIterator) {
        ArrayList<JstdTestCase> isolatedTestCases = Lists.newArrayList();
        ArrayList<JstdTestCase> testCases = Lists.newArrayList(testCasesIterator);
        for (JstdTestCase jstdTestCase : testCases) {
            List<FileInfo> tests = jstdTestCase.getTests();
            for (FileInfo test : tests) {
                JstdTestCase testCase = new JstdTestCase(jstdTestCase.getDependencies(), Lists.newArrayList(test), jstdTestCase.getPlugins(), test.getDisplayPath().replace("/", "_"));
                isolatedTestCases.add(testCase);
            }
        }
        return isolatedTestCases;
    }
}

