/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.HeartBeatManager;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.browser.BrowserSessionManager;
import com.google.jstestdriver.util.Sleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseBrowserSessionManager
implements BrowserSessionManager {
    private static final long WAIT_INTERVAL = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(BaseBrowserSessionManager.class);
    private final Server server;
    private final String baseUrl;
    private final HeartBeatManager heartBeatManager;
    private final Sleeper sleeper;

    @Inject
    public BaseBrowserSessionManager(Server server, @Named(value="server") String baseUrl, HeartBeatManager heartBeatManager, Sleeper sleeper) {
        this.server = server;
        this.baseUrl = baseUrl;
        this.heartBeatManager = heartBeatManager;
        this.sleeper = sleeper;
    }

    public String startSession(String browserId) {
        String sessionId = this.server.startSession(this.baseUrl, browserId);
        if ("FAILED".equals(sessionId)) {
            while ("FAILED".equals(sessionId)) {
                try {
                    logger.error("Currently waiting for browser: {}, with is currently in use. ", (Object)browserId);
                    this.sleeper.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error("Could not create session for browser: " + browserId);
                    throw new RuntimeException("Can't start a session on the server!" + browserId);
                }
                sessionId = this.server.startSession(this.baseUrl, browserId);
            }
        }
        this.heartBeatManager.startTimer();
        this.heartBeatManager.startHeartBeat(this.baseUrl, browserId, sessionId);
        return sessionId;
    }

    public void stopSession(String sessionId, String browserId) {
        this.heartBeatManager.cancelTimer();
        this.server.stopSession(this.baseUrl, browserId, sessionId);
    }
}

