/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.RunData;
import java.io.PrintStream;

public class ResetAction
implements BrowserAction {
    private final ResponseStreamFactory responseStreamFactory;

    @Inject
    public ResetAction(ResponseStreamFactory responseStreamFactory) {
        this.responseStreamFactory = responseStreamFactory;
    }

    public ResponseStream run(String id, JsTestDriverClient client, RunData runData, JstdTestCase testCase) {
        ResponseStream responseStream = this.responseStreamFactory.getResetActionResponseStream();
        client.reset(id, responseStream, testCase);
        return responseStream;
    }

    public static class ResetActionResponseStream
    implements ResponseStream {
        private final PrintStream out;

        public ResetActionResponseStream(PrintStream out) {
            this.out = out;
        }

        public void finish() {
        }

        public void stream(Response response) {
            this.out.println(String.format("%s: Reset", response.getBrowser().getName()));
        }
    }
}

