/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.FileInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesCache {
    private final Map<String, FileInfo> files;

    public FilesCache(Map<String, FileInfo> files) {
        this.files = files;
    }

    public synchronized String getFileContent(String fileName) {
        FileInfo info = this.files.get(fileName);
        if (info == null) {
            throw new MissingFileException();
        }
        return info.getData();
    }

    public synchronized void clear() {
        this.files.clear();
    }

    public synchronized void addFile(FileInfo fileInfo) {
        this.files.put(fileInfo.getDisplayPath(), fileInfo);
    }

    public int getFilesNumber() {
        return this.files.size();
    }

    public synchronized Set<String> getAllFileNames() {
        return this.files.keySet();
    }

    public synchronized Collection<FileInfo> getAllFileInfos() {
        return this.files.values();
    }

    public String toString() {
        return "FilesCache [files=" + this.files + "]";
    }

    public FileInfo getFile(String filePath) {
        return this.files.get(filePath);
    }

    public static class MissingFileException
    extends RuntimeException {
    }
}

