/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.browser.BrowserControl;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.util.StopWatch;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserStartupAction
implements Action {
    private final Set<BrowserRunner> browsers;
    private final String captureAddress;
    private final JsTestDriverClient client;
    private final StopWatch stopWatch;
    private final ExecutorService executor;

    @Inject
    public BrowserStartupAction(Set<BrowserRunner> browsers, StopWatch stopWatch, JsTestDriverClient client, @Named(value="captureAddress") String captureAddress, ExecutorService executor) {
        this.browsers = browsers;
        this.stopWatch = stopWatch;
        this.client = client;
        this.captureAddress = captureAddress;
        this.executor = executor;
    }

    @Override
    public RunData run(RunData runData) {
        ArrayList<Future<String>> browserIds = Lists.newArrayListWithCapacity(this.browsers.size());
        for (final BrowserRunner browserRunner : this.browsers) {
            browserIds.add(this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return new BrowserControl(browserRunner, BrowserStartupAction.this.captureAddress, BrowserStartupAction.this.stopWatch, BrowserStartupAction.this.client).captureBrowser(BrowserStartupAction.this.client.getNextBrowserId());
                }
            }));
        }
        for (Future future : browserIds) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return runData;
    }

    public Set<BrowserRunner> getBrowsers() {
        return this.browsers;
    }

    public String getServerAddress() {
        return this.captureAddress;
    }
}

