/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.DryRunAction;
import com.google.jstestdriver.EvalAction;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.ResetAction;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.ServerStartupAction;
import com.google.jstestdriver.hooks.TestsPreProcessor;
import com.google.jstestdriver.server.JstdTestCaseStore;
import com.google.jstestdriver.util.StopWatch;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ActionFactory {
    Map<Class<?>, List<Observer>> observers = new HashMap();
    private final Provider<JsTestDriverClient> clientProvider;
    private final Set<TestsPreProcessor> testPreProcessors;
    private final boolean preloadFiles;
    private final FileLoader fileLoader;
    private final JsTestDriverServer.Factory factory;
    private final StopWatch stopWatch;

    @Inject
    public ActionFactory(Provider<JsTestDriverClient> clientProvider, Set<TestsPreProcessor> testPreProcessors, @Named(value="preloadFiles") boolean preloadFiles, FileLoader fileLoader, JsTestDriverServer.Factory factory, StopWatch stopWatch) {
        this.clientProvider = clientProvider;
        this.testPreProcessors = testPreProcessors;
        this.preloadFiles = preloadFiles;
        this.fileLoader = fileLoader;
        this.factory = factory;
        this.stopWatch = stopWatch;
    }

    public ServerStartupAction getServerStartupAction(Integer port, Integer sslPort, CapturedBrowsers capturedBrowsers, JstdTestCaseStore testCaseStore) {
        ServerStartupAction serverStartupAction = new ServerStartupAction((int)port, (int)sslPort, testCaseStore, this.preloadFiles, this.fileLoader, this.factory);
        if (this.observers.containsKey(CapturedBrowsers.class)) {
            for (Observer o : this.observers.get(CapturedBrowsers.class)) {
                capturedBrowsers.addObserver(o);
            }
        }
        if (this.observers.containsKey(ServerStartupAction.class)) {
            serverStartupAction.addObservers(this.observers.get(ServerStartupAction.class));
        }
        return serverStartupAction;
    }

    public void registerListener(Class<?> clazz, Observer observer) {
        if (!this.observers.containsKey(clazz)) {
            this.observers.put(clazz, new LinkedList());
        }
        this.observers.get(clazz).add(observer);
    }

    public ResetAction createResetAction(ResponseStreamFactory responseStreamFactory) {
        return new ResetAction(responseStreamFactory);
    }

    public DryRunAction createDryRunAction(ResponseStreamFactory responseStreamFactory, List<String> expressions) {
        return new DryRunAction(responseStreamFactory, expressions);
    }

    public RunTestsAction createRunTestsAction(ResponseStreamFactory responseStreamFactory, List<String> tests, boolean captureConsole) {
        return new RunTestsAction(responseStreamFactory, tests, captureConsole, this.testPreProcessors, this.stopWatch);
    }

    public EvalAction createEvalAction(ResponseStreamFactory responseStreamFactory, String cmd) {
        return new EvalAction(responseStreamFactory, cmd);
    }

    public JsTestDriverClient getJsTestDriverClient(Set<FileInfo> filesList, String serverAddress) {
        return this.clientProvider.get();
    }
}

