/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.weather;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelWeatherSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_WEATHER_PATH_NAME_CONF = "camel.sink.path.name";
    public static final String CAMEL_SINK_WEATHER_PATH_NAME_DOC = "The name value is not used.";
    public static final String CAMEL_SINK_WEATHER_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_APPID_CONF = "camel.sink.endpoint.appid";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_APPID_DOC = "APPID ID used to authenticate the user connected to the API Server";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_APPID_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_HEADER_NAME_CONF = "camel.sink.endpoint.headerName";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_HEADER_NAME_DOC = "To store the weather result in this header instead of the message body. This is useable if you want to keep current message body as-is.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_HEADER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LANGUAGE_CONF = "camel.sink.endpoint.language";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LANGUAGE_DOC = "Language of the response. One of: [en] [ru] [it] [es] [sp] [uk] [ua] [de] [pt] [ro] [pl] [fi] [nl] [fr] [bg] [sv] [se] [zh_tw] [zh] [zh_cn] [tr] [hr] [ca]";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LANGUAGE_DEFAULT = "en";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_MODE_CONF = "camel.sink.endpoint.mode";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_MODE_DOC = "The output format of the weather data. One of: [HTML] [JSON] [XML]";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_MODE_DEFAULT = "JSON";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PERIOD_CONF = "camel.sink.endpoint.period";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PERIOD_DOC = "If null, the current weather will be returned, else use values of 5, 7, 14 days. Only the numeric value for the forecast period is actually parsed, so spelling, capitalisation of the time period is up to you (its ignored)";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PERIOD_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_UNITS_CONF = "camel.sink.endpoint.units";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_UNITS_DOC = "The units for temperature measurement. One of: [IMPERIAL] [METRIC]";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_UNITS_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_WEATHER_API_CONF = "camel.sink.endpoint.weatherApi";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_WEATHER_API_DOC = "The API to be use (current, forecast/3 hour, forecast daily, station) One of: [Current] [Station] [Hourly] [Daily]";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_WEATHER_API_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_WEATHER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_WEATHER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_HTTP_CONNECTION_MANAGER_CONF = "camel.sink.endpoint.httpConnectionManager";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_HTTP_CONNECTION_MANAGER_DOC = "To use a custom HttpConnectionManager to manage connections";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_HTTP_CONNECTION_MANAGER_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_WEATHER_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_CNT_CONF = "camel.sink.endpoint.cnt";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_CNT_DOC = "Number of results to be found";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_CNT_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_IDS_CONF = "camel.sink.endpoint.ids";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_IDS_DOC = "List of id's of city/stations. You can separate multiple ids by comma.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_IDS_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LAT_CONF = "camel.sink.endpoint.lat";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LAT_DOC = "Latitude of location. You can use lat and lon options instead of location. For boxed queries this is the bottom latitude.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LAT_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LOCATION_CONF = "camel.sink.endpoint.location";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LOCATION_DOC = "If null Camel will try and determine your current location using the geolocation of your ip address, else specify the city,country. For well known city names, Open Weather Map will determine the best fit, but multiple results may be returned. Hence specifying and country as well will return more accurate data. If you specify current as the location then the component will try to get the current latitude and longitude and use that to get the weather details. You can use lat and lon options instead of location.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LOCATION_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LON_CONF = "camel.sink.endpoint.lon";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LON_DOC = "Longitude of location. You can use lat and lon options instead of location. For boxed queries this is the left longtitude.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_LON_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_RIGHT_LON_CONF = "camel.sink.endpoint.rightLon";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_RIGHT_LON_DOC = "For boxed queries this is the right longtitude. Needs to be used in combination with topLat and zoom.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_RIGHT_LON_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_TOP_LAT_CONF = "camel.sink.endpoint.topLat";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_TOP_LAT_DOC = "For boxed queries this is the top latitude. Needs to be used in combination with rightLon and zoom.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_TOP_LAT_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_ZIP_CONF = "camel.sink.endpoint.zip";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_ZIP_DOC = "Zip-code, e.g. 94040,us";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_ZIP_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_ZOOM_CONF = "camel.sink.endpoint.zoom";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_ZOOM_DOC = "For boxed queries this is the zoom. Needs to be used in combination with rightLon and topLat.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_ZOOM_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_DOMAIN_CONF = "camel.sink.endpoint.proxyAuthDomain";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_DOMAIN_DOC = "Domain for proxy NTLM authentication";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_DOMAIN_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_HOST_CONF = "camel.sink.endpoint.proxyAuthHost";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_HOST_DOC = "Optional host for proxy NTLM authentication";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_METHOD_CONF = "camel.sink.endpoint.proxyAuthMethod";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_METHOD_DOC = "Authentication method for proxy, either as Basic, Digest or NTLM.";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_PASSWORD_CONF = "camel.sink.endpoint.proxyAuthPassword";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_PASSWORD_DOC = "Password for proxy authentication";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_USERNAME_CONF = "camel.sink.endpoint.proxyAuthUsername";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_USERNAME_DOC = "Username for proxy authentication";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_HOST_CONF = "camel.sink.endpoint.proxyHost";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_HOST_DOC = "The proxy host name";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_PORT_CONF = "camel.sink.endpoint.proxyPort";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_PORT_DOC = "The proxy port number";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_ACCESS_KEY_CONF = "camel.sink.endpoint.geolocationAccessKey";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_ACCESS_KEY_DOC = "The geolocation service now needs an accessKey to be used";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_REQUEST_HOST_IPCONF = "camel.sink.endpoint.geolocationRequestHostIP";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_REQUEST_HOST_IPDOC = "The geolocation service now needs to specify the IP associated to the accessKey you're using";
    public static final String CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_REQUEST_HOST_IPDEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_ACCESS_KEY_CONF = "camel.component.weather.geolocationAccessKey";
    public static final String CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_ACCESS_KEY_DOC = "The geolocation service now needs an accessKey to be used";
    public static final String CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_REQUEST_HOST_IPCONF = "camel.component.weather.geolocationRequestHostIP";
    public static final String CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_REQUEST_HOST_IPDOC = "The geolocation service now needs to specify the IP associated to the accessKey you're using";
    public static final String CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_REQUEST_HOST_IPDEFAULT = null;
    public static final String CAMEL_SINK_WEATHER_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.weather.lazyStartProducer";
    public static final String CAMEL_SINK_WEATHER_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_WEATHER_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_WEATHER_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.weather.basicPropertyBinding";
    public static final String CAMEL_SINK_WEATHER_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_WEATHER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelWeatherSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelWeatherSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_WEATHER_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_WEATHER_PATH_NAME_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_APPID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_APPID_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_WEATHER_ENDPOINT_APPID_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_HEADER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_HEADER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_HEADER_NAME_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_LANGUAGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_LANGUAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_LANGUAGE_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_MODE_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PERIOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PERIOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PERIOD_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_UNITS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_UNITS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_UNITS_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_WEATHER_API_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_WEATHER_API_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_WEATHER_API_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEATHER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEATHER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_HTTP_CONNECTION_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_HTTP_CONNECTION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_HTTP_CONNECTION_MANAGER_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEATHER_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_CNT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_CNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_CNT_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_IDS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_IDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_IDS_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_LAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_LAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_LAT_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_LOCATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_LOCATION_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_LON_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_LON_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_LON_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_RIGHT_LON_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_RIGHT_LON_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_RIGHT_LON_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_TOP_LAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_TOP_LAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_TOP_LAT_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_ZIP_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_ZIP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_ZIP_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_ZOOM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_ZOOM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_ZOOM_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_DOMAIN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_DOMAIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_DOMAIN_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_HOST_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_METHOD_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_PASSWORD_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_AUTH_USERNAME_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_HOST_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_ENDPOINT_PROXY_PORT_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_ACCESS_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_ACCESS_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_ACCESS_KEY_DOC);
        conf.define(CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_REQUEST_HOST_IPCONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_REQUEST_HOST_IPDEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_WEATHER_ENDPOINT_GEOLOCATION_REQUEST_HOST_IPDOC);
        conf.define(CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_ACCESS_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_ACCESS_KEY_DOC);
        conf.define(CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_REQUEST_HOST_IPCONF, ConfigDef.Type.STRING, CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_REQUEST_HOST_IPDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_COMPONENT_GEOLOCATION_REQUEST_HOST_IPDOC);
        conf.define(CAMEL_SINK_WEATHER_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEATHER_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_WEATHER_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEATHER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEATHER_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}