/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.dataset;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelDatasetSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_DATASET_PATH_NAME_CONF = "camel.source.path.name";
    public static final String CAMEL_SOURCE_DATASET_PATH_NAME_DOC = "Name of DataSet to lookup in the registry";
    public static final String CAMEL_SOURCE_DATASET_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_DATA_SET_INDEX_CONF = "camel.source.endpoint.dataSetIndex";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_DATA_SET_INDEX_DOC = "Controls the behaviour of the CamelDataSetIndex header. For Consumers: - off = the header will not be set - strict/lenient = the header will be set For Producers: - off = the header value will not be verified, and will not be set if it is not present = strict = the header value must be present and will be verified = lenient = the header value will be verified if it is present, and will be set if it is not present One of: [strict] [lenient] [off]";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_DATA_SET_INDEX_DEFAULT = "lenient";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DATASET_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_INITIAL_DELAY_CONF = "camel.source.endpoint.initialDelay";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_INITIAL_DELAY_DOC = "Time period in millis to wait before starting sending messages.";
    public static final Long CAMEL_SOURCE_DATASET_ENDPOINT_INITIAL_DELAY_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_MIN_RATE_CONF = "camel.source.endpoint.minRate";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_MIN_RATE_DOC = "Wait until the DataSet contains at least this number of messages";
    public static final Integer CAMEL_SOURCE_DATASET_ENDPOINT_MIN_RATE_DEFAULT = 0;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_PRELOAD_SIZE_CONF = "camel.source.endpoint.preloadSize";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_PRELOAD_SIZE_DOC = "Sets how many messages should be preloaded (sent) before the route completes its initialization";
    public static final Long CAMEL_SOURCE_DATASET_ENDPOINT_PRELOAD_SIZE_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_PRODUCE_DELAY_CONF = "camel.source.endpoint.produceDelay";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_PRODUCE_DELAY_DOC = "Allows a delay to be specified which causes a delay when a message is sent by the consumer (to simulate slow processing)";
    public static final Long CAMEL_SOURCE_DATASET_ENDPOINT_PRODUCE_DELAY_DEFAULT = 3L;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DATASET_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_DATASET_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_DATASET_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_DATASET_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.dataset.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DATASET_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DATASET_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DATASET_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.dataset.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DATASET_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DATASET_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelDatasetSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelDatasetSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_DATASET_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DATASET_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DATASET_PATH_NAME_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_DATA_SET_INDEX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DATASET_ENDPOINT_DATA_SET_INDEX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_DATA_SET_INDEX_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DATASET_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_INITIAL_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DATASET_ENDPOINT_INITIAL_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_INITIAL_DELAY_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_MIN_RATE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DATASET_ENDPOINT_MIN_RATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_MIN_RATE_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_PRELOAD_SIZE_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DATASET_ENDPOINT_PRELOAD_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_PRELOAD_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_PRODUCE_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DATASET_ENDPOINT_PRODUCE_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_PRODUCE_DELAY_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DATASET_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DATASET_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DATASET_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_DATASET_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DATASET_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_DATASET_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DATASET_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DATASET_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DATASET_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DATASET_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}