/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.bonita;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelBonitaSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_BONITA_PATH_OPERATION_CONF = "camel.sink.path.operation";
    public static final String CAMEL_SINK_BONITA_PATH_OPERATION_DOC = "Operation to use One of: [startCase]";
    public static final String CAMEL_SINK_BONITA_PATH_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_BONITA_ENDPOINT_HOSTNAME_CONF = "camel.sink.endpoint.hostname";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_HOSTNAME_DOC = "Hostname where Bonita engine runs";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_HOSTNAME_DEFAULT = "localhost";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_BONITA_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PORT_CONF = "camel.sink.endpoint.port";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PORT_DOC = "Port of the server hosting Bonita engine";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PORT_DEFAULT = "8080";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PROCESS_NAME_CONF = "camel.sink.endpoint.processName";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PROCESS_NAME_DOC = "Name of the process involved in the operation";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PROCESS_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_BONITA_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_BONITA_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_BONITA_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_BONITA_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PASSWORD_DOC = "Password to authenticate to Bonita engine.";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_BONITA_ENDPOINT_USERNAME_CONF = "camel.sink.endpoint.username";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_USERNAME_DOC = "Username to authenticate to Bonita engine.";
    public static final String CAMEL_SINK_BONITA_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_BONITA_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.bonita.lazyStartProducer";
    public static final String CAMEL_SINK_BONITA_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_BONITA_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_BONITA_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.bonita.basicPropertyBinding";
    public static final String CAMEL_SINK_BONITA_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_BONITA_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelBonitaSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelBonitaSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_BONITA_PATH_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BONITA_PATH_OPERATION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_BONITA_PATH_OPERATION_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BONITA_ENDPOINT_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_HOSTNAME_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BONITA_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BONITA_ENDPOINT_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_PORT_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_PROCESS_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BONITA_ENDPOINT_PROCESS_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_PROCESS_NAME_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BONITA_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BONITA_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BONITA_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_BONITA_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BONITA_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SINK_BONITA_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BONITA_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_BONITA_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BONITA_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BONITA_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}