/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.process.PreparedPlanCache;
import com.metamatrix.dqp.internal.process.Request;
import com.metamatrix.query.processor.BaseProcessorPlan;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.xml.XMLPlan;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.PreparedBatchUpdate;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SQLQuery;
import com.metamatrix.query.util.QueryUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class PreparedStatementRequest
extends Request {
    private PreparedPlanCache prepPlanCache;
    private PreparedPlanCache.PreparedPlan prepPlan;

    public void processRequest() throws QueryParserException, QueryResolverException, QueryValidatorException, QueryPlannerException, MetaMatrixComponentException {
        SQLQuery sqlQuery = (SQLQuery)this.requestMsg.getCommand();
        this.prepPlan = this.prepPlanCache.getPreparedPlan(this.requestMsg.getClientConnection(), sqlQuery.getQuery(), this.requestMsg.isPreparedBatchUpdate() ? this.requestMsg.getParameterValues().size() : 0);
        if (this.prepPlan == null) {
            this.prepPlan = this.prepPlanCache.createPreparedPlan(this.requestMsg.getClientConnection(), sqlQuery.getQuery(), this.requestMsg.isPreparedBatchUpdate() ? this.requestMsg.getParameterValues().size() : 0);
            LogManager.logTrace((String)"DQP", (Object[])new Object[]{"Query does not exist in cache: ", sqlQuery.getQuery()});
        }
        if (this.prepPlan.getPlan() == null) {
            this.prepareCommand();
            this.generatePlan();
        } else {
            Collection sm;
            this.processPlan = this.prepPlan.getPlan();
            this.analysisRecord = this.prepPlan.getAnalysisRecord();
            this.schemas = null;
            if (this.processPlan instanceof XMLPlan && (sm = ((XMLPlan)this.processPlan).getXMLSchemas()) != null) {
                this.schemas = new HashSet();
                this.schemas.add(sm);
            }
            this.requestMsg.setCommand(this.prepPlan.getCommand());
            this.resolveParameterValues();
            this.validateEntitlement(this.requestMsg.getCommand());
            this.requestMsg.setCachedFinder((Object)this.getCapabilitiesFinder());
            LogManager.logTrace((String)"DQP", (Object[])new Object[]{"Query exist in cache: ", sqlQuery});
            this.processPlan = (ProcessorPlan)((BaseProcessorPlan)this.processPlan).clone();
            this.initCommandContext();
        }
        this.processCommand();
    }

    protected void resolveCommand(Command command, List references) throws QueryResolverException, MetaMatrixComponentException, QueryValidatorException {
        super.resolveCommand(command, references);
        if (this.prepPlan != null) {
            this.prepPlan.setCommand((Command)command.clone());
            this.prepPlan.setReferences(references);
        }
        this.resolveParameterValues();
    }

    public void initializePreparedPlanCache(PreparedPlanCache prepPlanCache) {
        this.prepPlanCache = prepPlanCache;
    }

    protected void resolveParameterValues() throws QueryValidatorException {
        List params = this.prepPlan.getReferences();
        List values = this.requestMsg.getParameterValues();
        if (this.requestMsg.isPreparedBatchUpdate()) {
            ((PreparedBatchUpdate)this.requestMsg.getCommand()).setParameterReferences(params);
            if (values.size() > 1) {
                ((PreparedBatchUpdate)this.requestMsg.getCommand()).setUpdatingModelCount(2);
            }
            for (int i = 0; i < values.size(); ++i) {
                if (params.size() == ((List)values.get(i)).size()) continue;
                String msg = DQPPlugin.Util.getString("DQPCore.wrong_number_of_values", new Object[]{new Integer(values.size()), new Integer(params.size())});
                QueryValidatorException e = new QueryValidatorException(msg);
                throw e;
            }
            values = (List)values.get(0);
        }
        QueryUtil.resolveParameterValues((List)params, (List)values);
    }

    protected void generatePlan() throws MetaMatrixComponentException, QueryPlannerException {
        super.generatePlan();
        if (!(this.prepPlan == null || this.prepPlan.getCommand() instanceof QueryCommand && ((QueryCommand)this.prepPlan.getCommand()).getLimit() == null && this.requestMsg.getRowLimit() > 0)) {
            this.prepPlan.setPlan((ProcessorPlan)this.processPlan.clone());
            this.prepPlan.setAnalysisRecord(this.analysisRecord);
        }
    }
}

