/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.sqlserver.tds.TDSHeaderInputStream;
import com.metamatrix.jdbc.sqlserver.tds.TDSHeaderOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;

public class TDSSSLSocket
extends Socket {
    Socket socket = null;
    InputStream inStream = null;
    OutputStream outStream = null;
    boolean writeHeader = false;
    boolean stripHeader = false;
    public static boolean writeDbgMsgs = true;

    public TDSSSLSocket(Socket socket) {
        this.socket = socket;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inStream == null) {
            this.inStream = new TDSHeaderInputStream(this.socket.getInputStream());
            if (this.stripHeader) {
                ((TDSHeaderInputStream)this.inStream).setStripHeader(true);
            }
        }
        return this.inStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outStream == null) {
            this.outStream = new TDSHeaderOutputStream(this.socket.getOutputStream());
            if (this.writeHeader) {
                ((TDSHeaderOutputStream)this.outStream).setWriteHeader(true);
            }
        }
        return this.outStream;
    }

    public void setWriteHeader(boolean bl) {
        this.writeHeader = bl;
        if (this.outStream != null) {
            ((TDSHeaderOutputStream)this.outStream).setWriteHeader(bl);
        }
    }

    public void setStripHeader(boolean bl) {
        this.stripHeader = bl;
        if (this.inStream != null) {
            ((TDSHeaderInputStream)this.inStream).setStripHeader(bl);
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.socket.bind(socketAddress);
    }

    public synchronized void close() throws IOException {
        this.socket.close();
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        this.socket.connect(socketAddress, n);
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.socket.connect(socketAddress);
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void sendUrgentData(int n) throws IOException {
        this.socket.sendUrgentData(n);
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.socket.setKeepAlive(bl);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.socket.setOOBInline(bl);
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
        this.socket.setPerformancePreferences(n, n2, n3);
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        this.socket.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.socket.setReuseAddress(bl);
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
        this.socket.setSendBufferSize(n);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.socket.setSoLinger(bl, n);
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public void setTrafficClass(int n) throws SocketException {
        this.socket.setTrafficClass(n);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return this.socket.toString();
    }

    void debugOut(String string) {
        if (writeDbgMsgs) {
            System.out.println(string);
        }
    }
}

