/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyInputStream;
import com.metamatrix.jdbcspy.SpyLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

class SpyBlob
implements Blob {
    private static String footprint = "$Revision:   1.2.2.0  $";
    private Blob realBlob;
    private SpyLogger spyLogger;
    private int id;
    private static int Id = 0;

    SpyBlob(Blob blob, SpyLogger spyLogger) {
        this.realBlob = blob;
        this.spyLogger = spyLogger;
        this.id = ++Id;
    }

    public final long length() throws SQLException {
        long l;
        this.spyLogger.println("\n" + this + ".length()");
        this.spyLogger.enter();
        try {
            l = this.realBlob.length();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l + ")");
        return l;
    }

    public final byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        this.spyLogger.println("\n" + this + ".getBytes(long pos, int length)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            byArray = this.realBlob.getBytes(l, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + this.spyLogger.bytesToString(byArray) + ")");
        return byArray;
    }

    public final InputStream getBinaryStream() throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getBinaryStream()");
        this.spyLogger.enter();
        try {
            inputStream = this.realBlob.getBinaryStream();
            if (this.spyLogger.logIS && inputStream != null) {
                inputStream = new SpyInputStream(inputStream, this.spyLogger);
            }
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final long position(byte[] byArray, long l) throws SQLException {
        long l2;
        this.spyLogger.println("\n" + this + ".position(byte[] pattern, long start)");
        this.spyLogger.println("pattern = " + this.spyLogger.bytesToString(byArray));
        this.spyLogger.println("start = " + l);
        this.spyLogger.enter();
        try {
            l2 = this.realBlob.position(byArray, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l2 + ")");
        return l2;
    }

    public final long position(Blob blob, long l) throws SQLException {
        long l2;
        this.spyLogger.println("\n" + this + ".position(byte[] pattern, long start)");
        this.spyLogger.println("pattern = " + blob);
        this.spyLogger.println("start = " + l);
        this.spyLogger.enter();
        try {
            l2 = this.realBlob.position(blob, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l2 + ")");
        return l2;
    }

    public final int setBytes(long l, byte[] byArray) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".setBytes(long pos, byte[] bytes)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.println("bytes = " + this.spyLogger.bytesToString(byArray));
        this.spyLogger.enter();
        try {
            n = this.realBlob.setBytes(l, byArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        this.spyLogger.println("\n" + this + ".setBytes(long pos, byte[] bytes, int offset, int len)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.println("bytes = " + this.spyLogger.bytesToString(byArray));
        this.spyLogger.println("offset = " + n);
        this.spyLogger.println("len = " + n2);
        this.spyLogger.enter();
        try {
            n3 = this.realBlob.setBytes(l, byArray, n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n3 + ")");
        return n3;
    }

    public final OutputStream setBinaryStream(long l) throws SQLException {
        OutputStream outputStream;
        this.spyLogger.println("\n" + this + ".setBinaryStream(long pos)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.enter();
        try {
            outputStream = this.realBlob.setBinaryStream(l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + outputStream + ")");
        return outputStream;
    }

    public final void truncate(long l) throws SQLException {
        this.spyLogger.println("\n" + this + ".truncate(long len)");
        this.spyLogger.println("len = " + l);
        this.spyLogger.enter();
        try {
            this.realBlob.truncate(l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final String toString() {
        return "Blob[" + this.id + "]";
    }
}

