/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.RulePushLimit;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.RemoveGroupAliasMappingVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class RuleCollapseSource
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List accessNodes = NodeEditor.findAllNodes(plan, 3);
        for (int i = 0; i < accessNodes.size(); ++i) {
            PlanNode accessNode = (PlanNode)accessNodes.get(i);
            ProcessorPlan nonRelationalPlan = FrameUtil.getNestedPlan(accessNode);
            if (nonRelationalPlan != null) {
                accessNode.setProperty((Object)NodeConstants.Info.PROCESSOR_PLAN, (Object)nonRelationalPlan);
            } else {
                Command command = FrameUtil.getNonQueryCommand(accessNode);
                if (command == null) {
                    command = this.createQuery(metadata, capFinder, accessNode, accessNode);
                } else {
                    List columns = (List)accessNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
                    RuleCollapseSource.assignOutputElementsToCommand(accessNode, columns, metadata, capFinder, command);
                }
                accessNode.setProperty((Object)NodeConstants.Info.ATOMIC_REQUEST, (Object)command);
            }
            NodeEditor.cutLast(accessNode);
        }
        return plan;
    }

    private QueryCommand createQuery(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode accessRoot, PlanNode node) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        boolean isSetQuery = false;
        for (PlanNode child = node; child != null && child.getType() != 19; child = child.getFirstChild()) {
            if (child.getType() != 29) continue;
            isSetQuery = true;
            break;
        }
        if (isSetQuery) {
            SetQuery unionCommand = new SetQuery();
            this.buildSetQuery(accessRoot, node, unionCommand, metadata, capFinder);
            return unionCommand;
        }
        Query query = new Query();
        query.setSelect(new Select());
        query.setFrom(new From());
        this.buildQuery(accessRoot, node, query, metadata, capFinder);
        if (query.getCriteria() instanceof CompoundCriteria) {
            query.setCriteria(QueryRewriter.optimizeCriteria((CompoundCriteria)query.getCriteria()));
        }
        this.removeAliases(accessRoot, (QueryCommand)query, metadata, capFinder);
        this.simplifyFromClause(query);
        List columns = (List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
        RuleCollapseSource.assignOutputElementsToCommand(node, columns, metadata, capFinder, (Command)query);
        return query;
    }

    void buildQuery(PlanNode accessRoot, PlanNode node, Query query, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        switch (node.getType()) {
            case 7: {
                JoinType joinType = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                ArrayList<CompareCriteria> crits = (ArrayList<CompareCriteria>)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null || crits.isEmpty()) {
                    crits = new ArrayList<CompareCriteria>();
                }
                PlanNode left = node.getFirstChild();
                PlanNode right = node.getLastChild();
                Criteria savedCriteria = null;
                this.buildQuery(accessRoot, left, query, metadata, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    savedCriteria = query.getCriteria();
                    query.setCriteria(null);
                }
                this.buildQuery(accessRoot, right, query, metadata, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    this.moveWhereClauseIntoOnClause(query, crits);
                    query.setCriteria(savedCriteria);
                }
                From from = query.getFrom();
                List clauses = from.getClauses();
                int lastClause = clauses.size() - 1;
                FromClause clause1 = (FromClause)clauses.get(lastClause - 1);
                FromClause clause2 = (FromClause)clauses.get(lastClause);
                if (joinType != JoinType.JOIN_CROSS && crits.isEmpty()) {
                    crits.add(QueryRewriter.TRUE_CRITERIA);
                } else if (joinType == JoinType.JOIN_CROSS && !crits.isEmpty()) {
                    joinType = JoinType.JOIN_INNER;
                }
                JoinPredicate jp = new JoinPredicate(clause1, clause2, joinType, crits);
                clauses.remove(lastClause);
                clauses.set(lastClause - 1, jp);
                return;
            }
            case 19: {
                if (Boolean.TRUE.equals(node.getProperty((Object)NodeConstants.Info.INLINE_VIEW))) {
                    PlanNode child = NodeEditor.cutLast(node);
                    QueryCommand newQuery = this.createQuery(metadata, capFinder, accessRoot, child);
                    GroupSymbol symbol = (GroupSymbol)node.getGroups().iterator().next();
                    SubqueryFromClause sfc = new SubqueryFromClause(symbol.getName(), (Command)newQuery);
                    sfc.getGroupSymbol().setMetadataID(symbol.getMetadataID());
                    query.getFrom().addClause((FromClause)sfc);
                    return;
                }
                query.getFrom().addGroups((Collection)node.getGroups());
            }
        }
        for (PlanNode childNode : node.getChildren()) {
            this.buildQuery(accessRoot, childNode, query, metadata, capFinder);
        }
        switch (node.getType()) {
            case 13: {
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                Boolean isHaving = (Boolean)node.getProperty((Object)NodeConstants.Info.IS_HAVING);
                if (isHaving == null || isHaving.equals(Boolean.FALSE)) {
                    query.setCriteria(CompoundCriteria.combineCriteria((Criteria)query.getCriteria(), (Criteria)crit));
                    break;
                }
                query.setHaving(CompoundCriteria.combineCriteria((Criteria)query.getHaving(), (Criteria)crit));
                break;
            }
            case 17: {
                this.processOrderBy(node, (QueryCommand)query);
                break;
            }
            case 5: {
                query.getSelect().setDistinct(true);
                break;
            }
            case 23: {
                List groups = (List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                if (groups == null || groups.isEmpty()) break;
                query.setGroupBy(new GroupBy(groups));
                break;
            }
            case 41: {
                Expression offset;
                Expression limit = (Expression)node.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
                if (limit != null) {
                    if (query.getLimit() != null) {
                        Expression oldlimit = query.getLimit().getRowLimit();
                        query.getLimit().setRowLimit(RulePushLimit.getMinValue(limit, oldlimit));
                    } else {
                        query.setLimit(new Limit(null, limit));
                    }
                }
                if ((offset = (Expression)node.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT)) == null) break;
                if (query.getLimit() != null) {
                    Expression oldoffset = query.getLimit().getOffset();
                    query.getLimit().setOffset(RulePushLimit.getSum(offset, oldoffset));
                    break;
                }
                query.setLimit(new Limit(offset, null));
                break;
            }
        }
    }

    private void moveWhereClauseIntoOnClause(Query query, List joinCrits) {
        if (query.getCriteria() == null) {
            return;
        }
        LinkedHashSet combinedCrits = new LinkedHashSet();
        combinedCrits.addAll(joinCrits);
        combinedCrits.addAll(Criteria.separateCriteriaByAnd(query.getCriteria()));
        joinCrits.clear();
        joinCrits.addAll(combinedCrits);
        query.setCriteria(null);
    }

    void buildSetQuery(PlanNode accessRoot, PlanNode node, SetQuery query, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        switch (node.getType()) {
            case 29: {
                this.collapseUnion(accessRoot, node, query, metadata, capFinder);
                return;
            }
        }
        for (PlanNode childNode : node.getChildren()) {
            this.buildSetQuery(accessRoot, childNode, query, metadata, capFinder);
        }
        if (node.getType() == 17) {
            this.processOrderBy(node, (QueryCommand)query);
        }
    }

    private void processOrderBy(PlanNode node, QueryCommand query) {
        List params = (List)node.getProperty((Object)NodeConstants.Info.SORT_ORDER);
        List types = (List)node.getProperty((Object)NodeConstants.Info.ORDER_TYPES);
        OrderBy orderBy = new OrderBy(params, types);
        query.setOrderBy(orderBy);
    }

    private void simplifyFromClause(Query query) {
        From from = query.getFrom();
        List clauses = from.getClauses();
        FromClause rootClause = (FromClause)clauses.get(0);
        if (rootClause instanceof UnaryFromClause) {
            return;
        }
        if (!this.hasOuterJoins(rootClause)) {
            from.setClauses(new ArrayList());
            this.shredJoinTree(rootClause, query);
        }
    }

    private void shredJoinTree(FromClause clause, Query query) {
        if (clause instanceof UnaryFromClause || clause instanceof SubqueryFromClause) {
            query.getFrom().addClause(clause);
        } else {
            JoinPredicate jp = (JoinPredicate)clause;
            List crits = jp.getJoinCriteria();
            if (crits != null && crits.size() > 0) {
                Object joinCrit = null;
                joinCrit = crits.size() > 1 ? new CompoundCriteria(crits) : (Criteria)crits.get(0);
                query.setCriteria(CompoundCriteria.combineCriteria((Criteria)joinCrit, (Criteria)query.getCriteria()));
            }
            this.shredJoinTree(jp.getLeftClause(), query);
            this.shredJoinTree(jp.getRightClause(), query);
        }
    }

    private boolean hasOuterJoins(FromClause clause) {
        if (clause instanceof UnaryFromClause || clause instanceof SubqueryFromClause) {
            return false;
        }
        JoinPredicate jp = (JoinPredicate)clause;
        if (jp.getJoinType().isOuter()) {
            return true;
        }
        boolean childHasOuter = this.hasOuterJoins(jp.getLeftClause());
        if (childHasOuter) {
            return true;
        }
        return this.hasOuterJoins(jp.getRightClause());
    }

    private void removeAliases(PlanNode accessNode, QueryCommand query, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess((PlanNode)accessNode, (QueryMetadataInterface)metadata);
        if (modelID != null && CapabilitiesUtil.supportsGroupAliases((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
            return;
        }
        RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)query);
    }

    private void collapseUnion(PlanNode accessRoot, PlanNode unionNode, SetQuery unionCommand, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        boolean unionAll = (Boolean)unionNode.getProperty((Object)NodeConstants.Info.USE_ALL);
        boolean first = true;
        for (PlanNode projectNode : unionNode.getChildren()) {
            QueryCommand command = this.createQuery(metadata, capFinder, accessRoot, projectNode);
            if (first) {
                if (command instanceof SetQuery && ((SetQuery)command).getOrderBy() == null) {
                    Iterator queries = ((SetQuery)command).getQueries().iterator();
                    while (queries.hasNext()) {
                        unionCommand.addQuery((QueryCommand)queries.next(), unionAll);
                    }
                } else {
                    unionCommand.addQuery(command, unionAll);
                }
                this.correctPushedAliasedLiterals(command, projectNode);
                first = false;
                continue;
            }
            unionCommand.addQuery(command, unionAll);
        }
    }

    private void correctPushedAliasedLiterals(QueryCommand command, PlanNode projectNode) {
        PlanNode parent;
        if (!(command instanceof Query)) {
            return;
        }
        if ((projectNode = NodeEditor.findNodePreOrder(projectNode, 11)) == null) {
            return;
        }
        Query query = (Query)command;
        Select select = query.getSelect();
        List selectSymbols = select.getSymbols();
        for (parent = projectNode.getParent(); parent != null && parent.getType() != 19; parent = parent.getParent()) {
        }
        Map symbolMap = null;
        if (parent != null) {
            symbolMap = (Map)parent.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        }
        List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        Iterator iter = projectCols.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SingleElementSymbol projSymbol = (SingleElementSymbol)iter.next();
            if (projSymbol instanceof AliasSymbol) {
                AliasSymbol alias = (AliasSymbol)projSymbol;
                projSymbol = alias.getSymbol();
                SingleElementSymbol selectSymbol = (SingleElementSymbol)selectSymbols.get(i);
                if (!(selectSymbol instanceof AliasSymbol)) {
                    AliasSymbol newAlias = new AliasSymbol(alias.getShortName(), selectSymbol);
                    selectSymbols.set(i, newAlias);
                    if (symbolMap != null) {
                        for (Map.Entry entry : symbolMap.entrySet()) {
                            if (!selectSymbol.equals(entry.getValue())) continue;
                            AliasSymbol newSymbolMapAlias = new AliasSymbol(alias.getShortName(), (SingleElementSymbol)entry.getValue());
                            entry.setValue(newSymbolMapAlias);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public String toString() {
        return "CollapseSource";
    }

    static void removeGroupAliases(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Select select) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = accessNode.getProperty((Object)NodeConstants.Info.MODEL_ID);
        if (modelID != null && !CapabilitiesUtil.supportsGroupAliases((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
            Map symbolMap = RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)select);
            accessNode.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, (Object)symbolMap);
        } else if (modelID == null) {
            for (GroupSymbol group : accessNode.getGroups()) {
                if (!group.hasAlias() || !group.isTempGroupSymbol()) continue;
                Map symbolMap = RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)select);
                accessNode.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, (Object)symbolMap);
            }
        }
    }

    static void assignOutputElementsToCommand(PlanNode root, List outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Command command) throws QueryMetadataException, MetaMatrixComponentException {
        if (command instanceof Query) {
            Select select = ((Query)command).getSelect();
            select.clearSymbols();
            select.addSymbols((Collection)outputElements);
            RuleCollapseSource.removeGroupAliases(root, metadata, capFinder, select);
            OrderBy orderBy = ((Query)command).getOrderBy();
            if (orderBy != null) {
                for (SingleElementSymbol symbol : orderBy.getVariables()) {
                    if (select.containsSymbol((SelectSymbol)symbol)) continue;
                    select.addSymbol((SelectSymbol)symbol);
                    outputElements.add(symbol);
                }
            }
        }
    }
}

