/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.schema.ISchemaModelCopyTraversalContext;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseSchemaObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaModelCopyTraversalContext
implements ISchemaModelCopyTraversalContext {
    private Map copiedElements = new HashMap();
    private List resultElements;
    private Set resultRoots;
    private List originalElements;

    public SchemaModelCopyTraversalContext(List schemaElements, Set roots) {
        this.originalElements = schemaElements;
        this.resultElements = new ArrayList(this.originalElements.size());
        this.process();
        this.resultRoots = null != roots ? new HashSet(roots) : new HashSet();
    }

    private void process() {
        SchemaObject copy;
        SchemaObject original;
        Iterator i = this.originalElements.iterator();
        while (i.hasNext()) {
            original = (SchemaObject)i.next();
            copy = original.copy(this);
            this.copiedElements.put(original, copy);
            this.resultElements.add(copy);
        }
        for (int i2 = 0; i2 < this.originalElements.size(); ++i2) {
            original = (SchemaObject)this.originalElements.get(i2);
            copy = (SchemaObject)this.resultElements.get(i2);
            ((BaseSchemaObject)original).copy((BaseSchemaObject)copy, this);
        }
    }

    public void addElement(SchemaObject element, SchemaObject copy) {
        if (!this.copiedElements.containsKey(element)) {
            this.copiedElements.put(element, copy);
            this.resultElements.add(copy);
        }
    }

    public SchemaObject getElement(SchemaObject element) {
        if (!this.copiedElements.containsKey(element)) {
            throw new RuntimeException("SchemaModelCopyTraversalContext: Cannot find the copied Element!");
        }
        SchemaObject copy = (SchemaObject)this.copiedElements.get(element);
        return copy;
    }

    public List getCopiedElements() {
        if (this.resultElements.size() != this.originalElements.size()) {
            throw new RuntimeException("copied result Elements numer wrong!");
        }
        return this.resultElements;
    }

    public Set getCopiedRoots() {
        return this.resultRoots;
    }
}

