/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.cache.DocumentCache;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;

public class Response {
    private XMLDocument[] docs;
    private String[] cacheKeys;
    private String id;
    private DocumentProducer docProducer;
    IDocumentCache cache;
    private boolean expOnRecreate;
    private String cacheReference;

    public Response(XMLDocument[] docs, String[] cacheKeys, DocumentProducer docProducer, IDocumentCache cache, boolean expOnRecreate, String cacheReference) {
        this.docs = docs;
        this.cacheKeys = cacheKeys;
        this.id = null;
        this.docProducer = docProducer;
        this.cache = cache;
        this.expOnRecreate = expOnRecreate;
        this.cacheReference = cacheReference;
    }

    public Response(String id, DocumentProducer docProducer, IDocumentCache cache, boolean expOnRecreate, String cacheReference) {
        this.docs = null;
        this.cacheKeys = null;
        this.id = id;
        this.docProducer = docProducer;
        this.cache = cache;
        this.expOnRecreate = expOnRecreate;
        this.cacheReference = cacheReference;
    }

    public XMLDocument[] getDocuments() throws ConnectorException {
        if (this.docs == null) {
            this.getDocsFromCache();
        }
        return this.docs;
    }

    public String getResponseId() throws ConnectorException {
        if (this.id == null) {
            this.calculateResponseId();
        }
        return this.id;
    }

    private void getDocsFromCache() throws ConnectorException {
        int d;
        if (this.id == null) {
            this.calculateResponseId();
        }
        int i = this.id.indexOf(44);
        String strDocCount = this.id.substring(0, i);
        int docCount = new Integer(strDocCount);
        this.docs = new XMLDocument[docCount];
        this.cacheKeys = new String[docCount];
        Object requests = null;
        for (d = 0; d < docCount; ++d) {
            String cacheKey;
            int j = this.id.indexOf(44, i + 1);
            String strLen = this.id.substring(i + 1, j);
            int len = new Integer(strLen);
            this.cacheKeys[d] = cacheKey = this.id.substring(j + 1, j + 1 + len);
            i = j + 1 + len;
            i = this.id.indexOf(44, i + 2);
        }
        for (d = 0; d < docCount; ++d) {
            XMLDocument doc = DocumentCache.cacheLookup(this.cache, this.cacheKeys[d], this.cacheReference);
            if (doc == null) {
                throw new ConnectorException("No Document Found");
            }
            this.docs[d] = doc;
        }
    }

    private void calculateResponseId() throws ConnectorException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.docs.length);
        buf.append(',');
        Serializable[] requests = new Serializable[this.docs.length];
        for (int i = 0; i < this.docs.length; ++i) {
            String cacheKey = this.cacheKeys[i];
            buf.append(cacheKey.length());
            buf.append(',');
            buf.append(cacheKey);
            buf.append(',');
            requests[i] = this.docProducer.getRequestObject(i);
        }
        try {
            String str = this.encodeAsString((Serializable)requests);
            buf.append(str);
        }
        catch (IOException ioe) {
            ConnectorException ce = new ConnectorException(Messages.getString("Executor.unable.to.encode.response.id"));
            ce.setStackTrace(ioe.getStackTrace());
            throw ce;
        }
        this.id = buf.toString();
    }

    private String encodeAsString(Serializable ser) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(ser);
        oos.flush();
        oos.close();
        baos.flush();
        baos.close();
        byte[] bytes = baos.toByteArray();
        Base64 encoder = new Base64();
        String str = new String(encoder.encode(bytes));
        return str;
    }

    private Serializable decodeFromString(String str) throws IOException, ClassNotFoundException {
        Base64 decoder = new Base64();
        byte[] bytes = decoder.decode(str.getBytes());
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Serializable ser = (Serializable)ois.readObject();
        return ser;
    }
}

