/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce.execution.visitors;

import com.metamatrix.connector.salesforce.Messages;
import com.metamatrix.connector.salesforce.Util;
import com.metamatrix.connector.salesforce.execution.visitors.CriteriaVisitor;
import com.metamatrix.connector.salesforce.execution.visitors.IQueryProvidingVisitor;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SelectVisitor
extends CriteriaVisitor
implements IQueryProvidingVisitor {
    private Map selectSymbolIndexToElement = new HashMap();
    private Map selectSymbolNameToIndex = new HashMap();
    private int selectSymbolCount;
    private int idIndex = -1;
    private StringBuffer selectSymbols = new StringBuffer();
    private StringBuffer limitClause = new StringBuffer();

    public SelectVisitor(RuntimeMetadata metadata) {
        super(metadata);
    }

    public void visit(IQuery query) {
        super.visit(query);
        if (null != query.getLimit()) {
            this.limitClause.append("LIMIT").append(" ").append(query.getLimit().getRowLimit());
        }
    }

    public void visit(ISelect select) {
        super.visit(select);
        if (select.isDistinct()) {
            this.exceptions.add(new ConnectorException(Messages.getString((String)"SelectVisitor.distinct.not.supported")));
        }
        try {
            List symbols = select.getSelectSymbols();
            this.selectSymbolCount = symbols.size();
            Iterator symbolIter = symbols.iterator();
            boolean firstTime = true;
            int index = 0;
            while (symbolIter.hasNext()) {
                ISelectSymbol symbol = (ISelectSymbol)symbolIter.next();
                IExpression expression = symbol.getExpression();
                if (expression instanceof IElement) {
                    MetadataID elementID = ((IElement)expression).getMetadataID();
                    Element element = (Element)this.metadata.getObject(elementID);
                    this.selectSymbolIndexToElement.put(new Integer(index), element);
                    this.selectSymbolNameToIndex.put(element.getNameInSource(), new Integer(index));
                    String nameInSource = element.getNameInSource();
                    if (nameInSource.equalsIgnoreCase("id")) {
                        this.idIndex = index;
                    }
                    if (null == nameInSource || nameInSource.length() == 0) {
                        this.exceptions.add(new ConnectorException("name in source is null or empty for column " + symbol.toString()));
                    }
                    if (!firstTime) {
                        this.selectSymbols.append(", ");
                    } else {
                        firstTime = false;
                    }
                    this.selectSymbols.append(nameInSource);
                }
                ++index;
            }
        }
        catch (ConnectorException ce) {
            this.exceptions.add(ce);
        }
    }

    public void visit(IFrom from) {
        super.visit(from);
        try {
            IGroup group = (IGroup)from.getItems().get(0);
            this.loadColumnMetadata(group);
        }
        catch (ConnectorException ce) {
            this.exceptions.add(ce);
        }
    }

    public String getQuery() throws ConnectorException {
        if (!this.exceptions.isEmpty()) {
            throw (ConnectorException)((Object)this.exceptions.get(0));
        }
        StringBuffer result = new StringBuffer();
        result.append("SELECT").append(" ");
        result.append(this.selectSymbols).append(" ");
        result.append("FROM").append(" ");
        result.append(this.table.getNameInSource()).append(" ");
        if (this.hasCriteria()) {
            result.append("WHERE").append(" ");
            boolean first = true;
            Iterator iter = this.criteriaList.iterator();
            while (iter.hasNext()) {
                String criterion = (String)iter.next();
                if (first) {
                    result.append(criterion).append(" ");
                    first = false;
                    continue;
                }
                result.append("AND").append(" ").append(criterion).append(" ");
            }
        }
        result.append(this.limitClause);
        Util.validateQueryLength(result);
        return result.toString();
    }

    public int getSelectSymbolCount() {
        return this.selectSymbolCount;
    }

    public Element getSelectSymbolMetadata(int index) {
        return (Element)this.selectSymbolIndexToElement.get(new Integer(index));
    }

    public Element getSelectSymbolMetadata(String name) {
        Element result = null;
        Integer index = (Integer)this.selectSymbolNameToIndex.get(name);
        if (null != index) {
            result = (Element)this.selectSymbolIndexToElement.get(index);
        }
        return result;
    }

    public int getIdIndex() {
        return this.idIndex;
    }
}

