/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.util;

import com.metamatrix.core.util.FileUtils;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiPlugin;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ModelGeneratorWsdlUiUtil
implements FileUtils.Constants {
    public static String[] WSDL_FILE_EXTENSIONS = new String[]{"wsdl"};
    public static String[] MODEL_FILE_EXTENSIONS = new String[]{"xmi"};
    public static final String[] FILE_DIALOG_WSDL_EXTENSIONS = new String[WSDL_FILE_EXTENSIONS.length];

    private ModelGeneratorWsdlUiUtil() {
    }

    public static Image getImage(String theImageName) {
        return ModelGeneratorWsdlUiPlugin.getDefault().getImage(theImageName);
    }

    public static ImageDescriptor getImageDescriptor(String theImageName) {
        return ModelGeneratorWsdlUiPlugin.getDefault().getImageDescriptor(theImageName);
    }

    private static boolean isFileExtensionOfType(String theExtension, String[] extensionTypes) {
        boolean result = false;
        if (theExtension != null && theExtension.length() > 0) {
            for (int i = 0; i < extensionTypes.length; ++i) {
                if (!theExtension.equalsIgnoreCase(extensionTypes[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isWsdlFile(IFile theFile) {
        return ModelGeneratorWsdlUiUtil.isFileExtensionOfType(theFile.getFileExtension(), WSDL_FILE_EXTENSIONS);
    }

    public static boolean isWsdlFile(File theFile) {
        boolean result = false;
        String name = theFile.getName();
        int index = name.lastIndexOf(FileUtils.Constants.FILE_EXTENSION_SEPARATOR);
        if (index != -1 && index + 2 < name.length()) {
            result = ModelGeneratorWsdlUiUtil.isFileExtensionOfType(name.substring(index + 1), WSDL_FILE_EXTENSIONS);
        }
        return result;
    }

    public static boolean isModelFile(IFile theFile) {
        boolean result = false;
        String name = theFile.getName();
        int index = name.lastIndexOf(FileUtils.Constants.FILE_EXTENSION_SEPARATOR);
        if (index != -1 && index + 2 < name.length()) {
            result = ModelGeneratorWsdlUiUtil.isFileExtensionOfType(name.substring(index + 1), MODEL_FILE_EXTENSIONS);
        }
        return result;
    }

    public static String createFileDialogExtension(String theExtension) {
        return FileUtils.Constants.FILE_NAME_WILDCARD + '.' + theExtension;
    }

    static {
        for (int i = 0; i < WSDL_FILE_EXTENSIONS.length; ++i) {
            ModelGeneratorWsdlUiUtil.FILE_DIALOG_WSDL_EXTENSIONS[i] = ModelGeneratorWsdlUiUtil.createFileDialogExtension(WSDL_FILE_EXTENSIONS[i]);
        }
    }
}

