/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.util;

import com.metamatrix.metamodels.core.extension.XAttribute;
import com.metamatrix.metamodels.core.extension.XClass;
import com.metamatrix.metamodels.core.extension.XEnum;
import com.metamatrix.metamodels.core.extension.XEnumLiteral;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.ObjectExtension;
import com.metamatrix.modeler.schema.tools.model.jdbc.Column;
import com.metamatrix.modeler.schema.tools.model.jdbc.Table;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ExtensionPropertyManager {
    private static final String HTTP_EXTENSION_FILE = "XMLHttpConnectorExtensions.xmi";
    private static final String HTTP_EXTENSION_FILE_DIMENSION = "XMLHttpConnectorExtensions.xmi";
    private static final String XML_EXTENSION_PROJECT = "XMLExtensionsProject";
    private XPackage m_xPackage;
    private XClass m_tableNamespaceXClass;
    private XAttribute m_tableNamespaceXAttribute;
    private XClass m_tableInputXClass;
    private XAttribute m_tableInputXAttribute;
    private XClass m_columnIsInputXClass;
    private XAttribute m_columnIsInputXAttribute;
    private XClass m_allowEmptyInputElementXClass;
    private XAttribute m_allowEmptyInputElementXAttribute;
    private XClass m_requiredValueXClass;
    private XAttribute m_requiredValueXAttribute;
    private XClass m_columnInputXClass;
    private XAttribute m_columnInputXAttribute;
    private XClass m_columnRoleXClass;
    private XAttribute m_columnRoleXAttribute;
    private XClass m_soapActionXClass;
    private XAttribute m_soapActionXAttribute;
    private XClass m_multipleValueXClass;
    private XAttribute m_multipleValueXAttribute;
    protected static final String TABLES_CLASS_NAME = "RelTables";
    protected static final String NAMESPACEPREFIXES_ATTRIBUTE_NAME = "NamespacePrefixes";
    protected static final String XPATH_FOR_INPUT_ATTRIBUTE_NAME = "XPathRootForInput";
    private static final String IS_INPUT_PARAMETER_ATTRIBUTE_NAME = "IsInputParameter";
    private static final String ALLOW_EMPTY_INPUT_ELEMENT_ATTRIBUTE_NAME = "AllowEmptyInputElement";
    private static final String REQUIRED_VALUE_ATTRIBUTE_NAME = "RequiredValue";
    private static final String COLUMN_CLASS_NAME = "RelColumns";
    private static final String COLUMN_XPATH_FOR_INPUT_ATTRIBUTE_NAME = "XPathForInputParameter";
    private static final String COLUMN_ROLE_ATTRIBUTE_NAME = "Role";
    private static final Object ROLE_ENUM_NAME = "ColumnRole";
    private static final Object ROLE_NAME_DATA = "Data";
    private static final Object ROLE_NAME_RESPONSE_OUT = "Response Out";
    private static final Object ROLE_NAME_RESPONSE_IN = "Response In";
    private static final String SOAP_ACTION_ATTRIBUTE_NAME = "SOAPAction";
    private static final String MULTIPLE_VALUES_ATTRIBUTE_NAME = "MultipleValues";
    private static final String MULTIPLE_VALUES_ENUM_NAME = "MultipleValuesEnum";
    private XEnumLiteral m_role_data;
    private XEnumLiteral m_role_responseIn;
    private XEnumLiteral m_role_responseOut;
    private XEnumLiteral m_multiple_values_no;
    private XEnumLiteral m_multiple_values_commaDelimted;
    private XEnumLiteral m_multiple_values_multiElement;
    private XEnumLiteral m_multiple_values_simpleSoapArrayElement;
    private XEnumLiteral m_multiple_values_complexSoapArrayElement;

    public ExtensionPropertyManager(Container cntr, boolean isDimension) throws ModelWorkspaceException {
        IProject extensionProject;
        IWorkspace workspace = ModelerCore.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String extensionFileName = "XMLHttpConnectorExtensions.xmi";
        if (isDimension) {
            try {
                Class<?> vdbViewUtil = Class.forName("com.metamatrix.modeler.vdbview.ui.views.VdbViewUtil");
                Method getVdbViewWorker = vdbViewUtil.getMethod("getVdbViewWorker", null);
                Object worker = getVdbViewWorker.invoke(null, null);
                Method getVdbProject = worker.getClass().getMethod("getVdbProject", null);
                extensionProject = (IProject)getVdbProject.invoke(worker, null);
                extensionFileName = "XMLHttpConnectorExtensions.xmi";
            }
            catch (Exception e) {
                throw new ModelWorkspaceException((Throwable)e);
            }
        } else {
            extensionProject = workspaceRoot.getProject(XML_EXTENSION_PROJECT);
        }
        IFile extensionFile = extensionProject.getFile(extensionFileName);
        String path = extensionFile.getRawLocation().toOSString();
        URI fileURI = URI.createFileURI((String)path);
        Resource xPkg = cntr.getResource(fileURI, true);
        EList resources = xPkg.getContents();
        Iterator resIter = resources.iterator();
        while (resIter.hasNext()) {
            Object next = resIter.next();
            if (!(next instanceof XPackage)) continue;
            this.m_xPackage = (XPackage)next;
        }
        XClassAndAttribute nsXCA = this.findClassAndAttribute(TABLES_CLASS_NAME, NAMESPACEPREFIXES_ATTRIBUTE_NAME);
        this.m_tableNamespaceXClass = nsXCA.m_xclass;
        this.m_tableNamespaceXAttribute = nsXCA.m_xattribute;
        XClassAndAttribute tabXCA = this.findClassAndAttribute(TABLES_CLASS_NAME, XPATH_FOR_INPUT_ATTRIBUTE_NAME);
        this.m_tableInputXClass = tabXCA.m_xclass;
        this.m_tableInputXAttribute = tabXCA.m_xattribute;
        XClassAndAttribute colInXCA = this.findClassAndAttribute(COLUMN_CLASS_NAME, IS_INPUT_PARAMETER_ATTRIBUTE_NAME);
        this.m_columnIsInputXClass = colInXCA.m_xclass;
        this.m_columnIsInputXAttribute = colInXCA.m_xattribute;
        XClassAndAttribute colInputXCA = this.findClassAndAttribute(COLUMN_CLASS_NAME, COLUMN_XPATH_FOR_INPUT_ATTRIBUTE_NAME);
        this.m_columnInputXClass = colInputXCA.m_xclass;
        this.m_columnInputXAttribute = colInputXCA.m_xattribute;
        XClassAndAttribute colRoleXCA = this.findClassAndAttribute(COLUMN_CLASS_NAME, COLUMN_ROLE_ATTRIBUTE_NAME);
        this.m_columnRoleXClass = colRoleXCA.m_xclass;
        this.m_columnRoleXAttribute = colRoleXCA.m_xattribute;
        XClassAndAttribute colAllowEmpty = this.findClassAndAttribute(COLUMN_CLASS_NAME, ALLOW_EMPTY_INPUT_ELEMENT_ATTRIBUTE_NAME);
        this.m_allowEmptyInputElementXClass = colAllowEmpty.m_xclass;
        this.m_allowEmptyInputElementXAttribute = colAllowEmpty.m_xattribute;
        XClassAndAttribute colRequiredValue = this.findClassAndAttribute(COLUMN_CLASS_NAME, REQUIRED_VALUE_ATTRIBUTE_NAME);
        this.m_requiredValueXClass = colRequiredValue.m_xclass;
        this.m_requiredValueXAttribute = colRequiredValue.m_xattribute;
        XClassAndAttribute soapAction = this.findClassAndAttribute(TABLES_CLASS_NAME, SOAP_ACTION_ATTRIBUTE_NAME);
        this.m_soapActionXClass = soapAction.m_xclass;
        this.m_soapActionXAttribute = soapAction.m_xattribute;
        XClassAndAttribute colMultipleValues = this.findClassAndAttribute(COLUMN_CLASS_NAME, MULTIPLE_VALUES_ATTRIBUTE_NAME);
        this.m_multipleValueXClass = colMultipleValues.m_xclass;
        this.m_multipleValueXAttribute = colMultipleValues.m_xattribute;
        XEnum roleEnum = null;
        Iterator enumIter = this.m_xPackage.eContents().iterator();
        while (enumIter.hasNext()) {
            XEnum xenum;
            String enumName;
            Object oEnum = enumIter.next();
            if (!(oEnum instanceof XEnum) || !(enumName = (xenum = (XEnum)oEnum).getName()).equals(ROLE_ENUM_NAME)) continue;
            roleEnum = xenum;
            break;
        }
        Iterator litIter = roleEnum.eContents().iterator();
        while (litIter.hasNext()) {
            Object olit = litIter.next();
            if (!(olit instanceof XEnumLiteral)) continue;
            XEnumLiteral xEnumLiteral = (XEnumLiteral)olit;
            String litName = xEnumLiteral.getName();
            if (litName.equals(ROLE_NAME_DATA)) {
                this.m_role_data = xEnumLiteral;
            }
            if (litName.equals(ROLE_NAME_RESPONSE_OUT)) {
                this.m_role_responseOut = xEnumLiteral;
            }
            if (!litName.equals(ROLE_NAME_RESPONSE_IN)) continue;
            this.m_role_responseIn = xEnumLiteral;
        }
        XEnum multipValuesEnum = null;
        Iterator enumIter2 = this.m_xPackage.eContents().iterator();
        while (enumIter2.hasNext()) {
            XEnum xenum;
            String enumName;
            Object oEnum = enumIter2.next();
            if (!(oEnum instanceof XEnum) || !(enumName = (xenum = (XEnum)oEnum).getName()).equals(MULTIPLE_VALUES_ENUM_NAME)) continue;
            multipValuesEnum = xenum;
            break;
        }
        Iterator litIter2 = multipValuesEnum.eContents().iterator();
        while (litIter2.hasNext()) {
            Object olit = litIter2.next();
            if (!(olit instanceof XEnumLiteral)) continue;
            XEnumLiteral xEnumLiteral = (XEnumLiteral)olit;
            String litName = xEnumLiteral.getName();
            if (litName.equals("No")) {
                this.m_multiple_values_no = xEnumLiteral;
            }
            if (litName.equals("CommaDelimited")) {
                this.m_multiple_values_commaDelimted = xEnumLiteral;
            }
            if (litName.equals("MultiElement")) {
                this.m_multiple_values_multiElement = xEnumLiteral;
            }
            if (litName.equals("SimpleSoapArrayElement")) {
                this.m_multiple_values_simpleSoapArrayElement = xEnumLiteral;
            }
            if (!litName.equals("ComplexSoapArrayElement")) continue;
            this.m_multiple_values_complexSoapArrayElement = xEnumLiteral;
        }
    }

    private XClassAndAttribute findClassAndAttribute(String desiredClassName, String desiredAttributeName) {
        XClass xclassIn = null;
        XAttribute xattrIn = null;
        Iterator classIter = this.m_xPackage.eContents().iterator();
        while (classIter.hasNext()) {
            XClass xclass;
            String className;
            Object oClass = classIter.next();
            if (!(oClass instanceof XClass) || !(className = (xclass = (XClass)oClass).getName()).equals(desiredClassName)) continue;
            Iterator attrIter = xclass.eContents().iterator();
            while (attrIter.hasNext()) {
                XAttribute xattribute;
                String attrName;
                Object oAttr = attrIter.next();
                if (!(oAttr instanceof XAttribute) || !(attrName = (xattribute = (XAttribute)oAttr).getName()).equals(desiredAttributeName)) continue;
                xclassIn = xclass;
                xattrIn = xattribute;
                return new XClassAndAttribute(xclassIn, xattrIn);
            }
        }
        return null;
    }

    public void setSoapAction(com.metamatrix.metamodels.relational.Table relTab, String soapAction) {
        ObjectExtension objectExtension = new ObjectExtension((EObject)relTab, this.m_soapActionXClass, ModelerCore.getModelEditor());
        objectExtension.eDynamicSet((EStructuralFeature)this.m_soapActionXAttribute, (Object)soapAction);
    }

    public void setTableNamespace(com.metamatrix.metamodels.relational.Table relTab, Table tab) {
        ObjectExtension objectExtension = new ObjectExtension((EObject)relTab, this.m_tableNamespaceXClass, ModelerCore.getModelEditor());
        objectExtension.eDynamicSet((EStructuralFeature)this.m_tableNamespaceXAttribute, (Object)tab.getNamespaceDeclaration());
    }

    public void setTableXPathForInput(com.metamatrix.metamodels.relational.Table relTab, Table tab) {
        ObjectExtension objectExtension2 = new ObjectExtension((EObject)relTab, this.m_tableInputXClass, ModelerCore.getModelEditor());
        objectExtension2.eDynamicSet((EStructuralFeature)this.m_tableInputXAttribute, (Object)tab.getInputXPath());
    }

    public void setColumnIsInputParameter(com.metamatrix.metamodels.relational.Column relColumn, Column column) {
        ObjectExtension objectExtension2 = new ObjectExtension((EObject)relColumn, this.m_columnIsInputXClass, ModelerCore.getModelEditor());
        objectExtension2.eDynamicSet((EStructuralFeature)this.m_columnIsInputXAttribute, (Object)new Boolean(column.isInputParameter()));
    }

    public void setColumnXPathForInput(com.metamatrix.metamodels.relational.Column relColumn, Column column) {
        ObjectExtension objectExtension2 = new ObjectExtension((EObject)relColumn, this.m_columnInputXClass, ModelerCore.getModelEditor());
        objectExtension2.eDynamicSet((EStructuralFeature)this.m_columnInputXAttribute, (Object)column.getInputXPath());
    }

    public void setRole(com.metamatrix.metamodels.relational.Column relColumn, Column column) {
        XEnumLiteral role = this.getRoleLiteral(column);
        ObjectExtension objectExtension = new ObjectExtension((EObject)relColumn, this.m_columnRoleXClass, ModelerCore.getModelEditor());
        objectExtension.eDynamicSet((EStructuralFeature)this.m_columnRoleXAttribute, (Object)role);
    }

    public void setMultipleValue(com.metamatrix.metamodels.relational.Column relColumn, Column column) {
        XEnumLiteral multipleValues = this.getMultipleValueLiteral(column);
        if (null != multipleValues) {
            ObjectExtension objectExtension = new ObjectExtension((EObject)relColumn, this.m_multipleValueXClass, ModelerCore.getModelEditor());
            objectExtension.eDynamicSet((EStructuralFeature)this.m_multipleValueXAttribute, (Object)multipleValues);
        }
    }

    public void setAllowEmptyInputElement(com.metamatrix.metamodels.relational.Column relCol, Column column, boolean request) {
        ObjectExtension objectExtension2 = new ObjectExtension((EObject)relCol, this.m_allowEmptyInputElementXClass, ModelerCore.getModelEditor());
        objectExtension2.eDynamicSet((EStructuralFeature)this.m_allowEmptyInputElementXAttribute, (Object)Boolean.FALSE);
        if (!request) {
            ObjectExtension objExt = new ObjectExtension((EObject)relCol, this.m_requiredValueXClass, ModelerCore.getModelEditor());
            objExt.eDynamicSet((EStructuralFeature)this.m_requiredValueXAttribute, (Object)Boolean.TRUE);
        } else {
            ObjectExtension objExt = new ObjectExtension((EObject)relCol, this.m_requiredValueXClass, ModelerCore.getModelEditor());
            objExt.eDynamicSet((EStructuralFeature)this.m_requiredValueXAttribute, (Object)Boolean.FALSE);
        }
    }

    private XEnumLiteral getRoleLiteral(Column column) {
        XEnumLiteral retVal = this.m_role_data;
        Column.Role role = column.getRole();
        if (role == Column.Role.RESPONSE_IN) {
            retVal = this.m_role_responseIn;
        }
        if (role == Column.Role.RESPONSE_OUT) {
            retVal = this.m_role_responseOut;
        }
        return retVal;
    }

    private XEnumLiteral getMultipleValueLiteral(Column column) {
        XEnumLiteral retVal = null;
        Column.MultipleValues multipleValues = column.getMultipleValues();
        if (null != multipleValues) {
            if (multipleValues == Column.MultipleValues.NO) {
                retVal = this.m_multiple_values_no;
            }
            if (multipleValues == Column.MultipleValues.COMMA_DELIMITED) {
                retVal = this.m_multiple_values_commaDelimted;
            }
            if (multipleValues == Column.MultipleValues.MULTI_ELEMENT) {
                retVal = this.m_multiple_values_multiElement;
            }
            if (multipleValues == Column.MultipleValues.SIMPLE_SOAP_ARRAY_ELEMENT) {
                retVal = this.m_multiple_values_simpleSoapArrayElement;
            }
            if (multipleValues == Column.MultipleValues.COMPLEX_SOAP_ARRAY_ELEMENT) {
                retVal = this.m_multiple_values_complexSoapArrayElement;
            }
        }
        return retVal;
    }

    public XPackage getExtensionPackage() {
        return this.m_xPackage;
    }

    private class XClassAndAttribute {
        public XClass m_xclass;
        public XAttribute m_xattribute;

        XClassAndAttribute(XClass xclass, XAttribute xattr) {
            this.m_xclass = xclass;
            this.m_xattribute = xattr;
        }
    }
}

