/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIPRODataPacket
extends TTIDataPacket {
    private static String footprint = "$Revision:   3.7.3.0  $";
    private byte[] proCliVerTTC7 = new byte[]{4, 3, 2, 1, 0};
    private byte[] proCliStrTTC7 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 55, 46, 48, 46, 48, 0};
    private byte[] proCliVerTTC8 = new byte[]{5, 4, 3, 2, 1, 0};
    private byte[] proCliStrTTC8 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 56, 46, 48, 46, 48, 0};
    private byte[] proCliVerTTC9 = new byte[]{6, 5, 4, 3, 2, 1, 0};
    private byte[] proCliStrTTC9 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 56, 46, 50, 46, 48, 0};
    private int oracleVersion;
    public short originalReportedOraNCharset = 0;
    public int proSrvVer;
    public String proSrvStr;
    public int srvCharSet;
    public int srvFlags;
    public int noCharSetElems;
    public byte[] charSetElems;

    public TTIPRODataPacket(int n) {
        this.oracleVersion = n;
        this.TTCCode = 1;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
        oracleDataConsumer.writeBytes(this.proCliVerTTC9, 0, this.proCliVerTTC9.length);
        oracleDataConsumer.writeBytes(this.proCliStrTTC9, 0, this.proCliStrTTC9.length);
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        int n;
        this.proSrvVer = oracleDataProvider.readByte();
        oracleDataProvider.readByte();
        this.proSrvStr = this.readNullTerminatedString(oracleDataProvider);
        this.srvCharSet = oracleDataProvider.readInt16Little();
        this.srvFlags = oracleDataProvider.readByte();
        this.noCharSetElems = oracleDataProvider.readInt16Little();
        for (n = 0; n < this.noCharSetElems; ++n) {
            oracleDataProvider.readByte();
            oracleDataProvider.readInt32Little();
        }
        n = 256 * oracleDataProvider.readByte() + oracleDataProvider.readByte();
        byte[] byArray = new byte[100];
        oracleDataProvider.readBytes(byArray, 0, n);
        int n2 = byArray[5] + byArray[6] + 9;
        this.originalReportedOraNCharset = (short)(((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF));
        if (this.proSrvVer >= 6) {
            n = oracleDataProvider.readByte();
            oracleDataProvider.readBytes(byArray, 0, n);
            n = oracleDataProvider.readByte();
            oracleDataProvider.readBytes(byArray, 0, n);
        }
    }

    private String readNullTerminatedString(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        StringBuffer stringBuffer = new StringBuffer(40);
        short s = (short)(oracleDataProvider.readByte() & 0xFF);
        while (s != 0) {
            stringBuffer.append((char)s);
            s = (short)(oracleDataProvider.readByte() & 0xFF);
        }
        return stringBuffer.toString();
    }
}

