/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.rewriter;

import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.lang.XQuery;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.VariableCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VariableSubstitutionVisitor
extends ExpressionMappingVisitor {
    private Collection invalidInput;
    private int commandType;
    private QueryResolverException conversionException = null;

    public VariableSubstitutionVisitor(Map variableValues, int commandType) {
        super(variableValues);
        this.commandType = commandType;
    }

    public void visit(Insert obj) {
        super.visit(obj);
        obj.getVariableValues().putAll(this.getVariableValues());
    }

    public void visit(DynamicCommand obj) {
        super.visit(obj);
        obj.getVariableValues().putAll(this.getVariableValues());
    }

    public void visit(XQuery obj) {
        obj.getCompiledXQuery().setParameters(this.getVariableValues());
    }

    public void visit(Update obj) {
        if (this.commandType != 3) {
            return;
        }
        List changeList = obj.getChangeList();
        ArrayList<CompareCriteria> newChangeList = new ArrayList<CompareCriteria>(changeList.size());
        Iterator changeIter = changeList.iterator();
        while (changeIter.hasNext()) {
            CompareCriteria compCrit = (CompareCriteria)changeIter.next();
            Expression rightExpr = compCrit.getRightExpression();
            boolean retainCrit = this.checkInputVariables(rightExpr);
            if (!retainCrit) continue;
            this.visit(compCrit);
            newChangeList.add(compCrit);
        }
        obj.setChangeList(newChangeList);
        obj.getVariableValues().putAll(this.getVariableValues());
    }

    public void visit(SetQuery obj) {
        obj.getVariableValues().putAll(this.getVariableValues());
    }

    public void visit(Query obj) {
        obj.getVariableValues().putAll(this.getVariableValues());
    }

    public void visit(Delete obj) {
        obj.getVariableValues().putAll(this.getVariableValues());
    }

    private boolean checkInputVariables(Expression expr) {
        Iterator varIter = VariableCollectorVisitor.getVariables((LanguageObject)expr, (boolean)false).iterator();
        Boolean result = null;
        while (varIter.hasNext()) {
            ElementSymbol var = (ElementSymbol)varIter.next();
            String grpName = var.getGroupSymbol().getName();
            if (!grpName.equals("INPUT")) continue;
            String changingKey = "CHANGING." + var.getShortCanonicalName();
            Boolean changingValue = (Boolean)((Constant)this.getVariableValues().get(changingKey)).getValue();
            if (result == null) {
                result = changingValue;
                continue;
            }
            if (result.equals(changingValue)) continue;
            if (this.invalidInput == null) {
                this.invalidInput = new ArrayList();
            }
            this.invalidInput.add(expr);
        }
        if (result != null) {
            return result;
        }
        return true;
    }

    public Expression replaceExpression(Expression expr) {
        ElementSymbol symbol;
        if (expr == null) {
            return null;
        }
        Class type = expr.getType();
        if (expr instanceof ElementSymbol && (symbol = (ElementSymbol)expr).isExternalReference()) {
            String grpName = symbol.getGroupSymbol().getCanonicalName();
            Expression value = (Expression)this.getVariableValues().get(symbol.getCanonicalName());
            if (value != null) {
                if (!ReferenceCollectorVisitor.getReferences((LanguageObject)value).isEmpty()) {
                    return expr;
                }
                expr = value;
            } else if (grpName.equals("INPUT")) {
                expr = new Constant(null, symbol.getType());
            } else if (grpName.equals("CHANGING")) {
                Assertion.failed((String)"Changing value should not be null");
            }
        }
        try {
            expr = ResolverUtil.convertExpression(expr, DataTypeManager.getDataTypeName((Class)type));
        }
        catch (QueryResolverException err) {
            this.conversionException = err;
            this.setAbort(true);
        }
        return expr;
    }

    public static final void substituteVariables(LanguageObject obj, Map variableValues, int commandType) throws QueryValidatorException {
        VariableSubstitutionVisitor visitor = new VariableSubstitutionVisitor(variableValues, commandType);
        if (obj == null) {
            return;
        }
        DeepPreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        if (visitor.invalidInput != null) {
            throw new QueryValidatorException(QueryExecPlugin.Util.getString("VariableSubstitutionVisitor.Input_vars_should_have_same_changing_state", (Object)visitor.invalidInput));
        }
        if (visitor.conversionException != null) {
            throw new QueryValidatorException((Throwable)visitor.conversionException, visitor.conversionException.getMessage());
        }
    }
}

