/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.mapping.xml.MappingSourceNode;
import com.metamatrix.query.mapping.xml.ResultSetInfo;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.rules.JoinUtil;
import com.metamatrix.query.optimizer.xml.ContextReplacerVisitor;
import com.metamatrix.query.optimizer.xml.XMLNodeMappingVisitor;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CriteriaPlanner {
    static void placeUserCriteria(Criteria criteria, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Iterator conjunctIter = Criteria.separateCriteriaByAnd((Criteria)criteria).iterator();
        while (conjunctIter.hasNext()) {
            Criteria conjunct = (Criteria)conjunctIter.next();
            if (CriteriaPlanner.planStagingTableCriteria(conjunct, planEnv) || CriteriaPlanner.planRowLimitFunction(conjunct, criteria, planEnv)) continue;
            MappingDocument context = null;
            Collection contextFunctions = ContextReplacerVisitor.replaceContextFunctions((LanguageObject)conjunct);
            if (!contextFunctions.isEmpty()) {
                Iterator i = contextFunctions.iterator();
                while (i.hasNext()) {
                    Function contextFunction = (Function)i.next();
                    MappingNode otherContext = CriteriaPlanner.getContext(planEnv, contextFunction);
                    if (context == null) {
                        context = otherContext;
                        continue;
                    }
                    if (context == otherContext) continue;
                    throw new QueryPlannerException("ERR.015.004.0068", QueryExecPlugin.Util.getString("ERR.015.004.0068", (Object)criteria));
                }
                MappingSourceNode contextRsNode = context.getSourceNode();
                if (contextRsNode != null) {
                    context = contextRsNode;
                }
            } else {
                context = planEnv.mappingDoc;
            }
            Set sourceNodes = CriteriaPlanner.collectSourceNodesInConjunct(conjunct, (MappingNode)context, planEnv.mappingDoc);
            MappingSourceNode criteriaRs = CriteriaPlanner.findRootResultSetNode((MappingNode)context, sourceNodes, criteria);
            Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)conjunct);
            boolean userCritNullDependent = JoinUtil.isNullDependent((QueryMetadataInterface)planEnv.getGlobalMetadata(), (Collection)groups, (Criteria)conjunct);
            ResultSetInfo rs = criteriaRs.getResultSetInfo();
            if (userCritNullDependent) {
                rs.setCritNullDependent(true);
            }
            Criteria convertedCrit = XMLNodeMappingVisitor.convertCriteria((Criteria)conjunct, (MappingDocument)planEnv.mappingDoc, (QueryMetadataInterface)planEnv.getGlobalMetadata());
            rs.setCriteria(Criteria.combineCriteria((Criteria)rs.getCriteria(), (Criteria)convertedCrit));
            rs.addToCriteriaResultSets(sourceNodes);
        }
    }

    private static Set collectSourceNodesInConjunct(Criteria conjunct, MappingNode context, MappingDocument mappingDoc) throws QueryPlannerException {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)conjunct, (boolean)true);
        HashSet<MappingSourceNode> resultSets = new HashSet<MappingSourceNode>();
        String contextFullName = context.getFullyQualifiedName().toUpperCase();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ElementSymbol elementSymbol = (ElementSymbol)i.next();
            String elementFullName = elementSymbol.getFullyQualifiedName().toUpperCase();
            MappingNode node = MappingNode.findNode((MappingNode)mappingDoc, (String)elementFullName);
            MappingSourceNode elementRsNode = node.getSourceNode();
            if (elementRsNode == null) {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("CriteriaPlanner.invalid_element", (Object)elementSymbol));
            }
            String elementRsFullName = elementRsNode.getFullyQualifiedName().toUpperCase();
            if (contextFullName.equals(elementRsFullName) || elementRsFullName.startsWith(contextFullName + ".")) {
                resultSets.add(elementRsNode);
                continue;
            }
            if (contextFullName.startsWith(elementRsFullName + ".")) continue;
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("CriteriaPlanner.invalid_context", (Object)elementSymbol, (Object)context.getFullyQualifiedName()));
        }
        return resultSets;
    }

    private static MappingSourceNode findRootResultSetNode(MappingNode context, Set resultSets, Criteria criteria) throws QueryPlannerException {
        if (context instanceof MappingSourceNode) {
            return (MappingSourceNode)context;
        }
        HashSet<MappingNode> criteriaResultSets = new HashSet<MappingNode>();
        Iterator i = resultSets.iterator();
        while (i.hasNext()) {
            MappingNode node;
            MappingNode root = node = (MappingNode)i.next();
            while (node != null) {
                if (node instanceof MappingSourceNode) {
                    root = node;
                }
                node = node.getParent();
            }
            criteriaResultSets.add(root);
        }
        if (criteriaResultSets.size() != 1) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("CriteriaPlanner.no_context", (Object)criteria));
        }
        return (MappingSourceNode)criteriaResultSets.iterator().next();
    }

    static boolean planStagingTableCriteria(Criteria criteria, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String rootTempGroupName = CriteriaPlanner.getStagingTableForConjunct(criteria, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        if (rootTempGroupName == null) {
            return false;
        }
        ResultSetInfo rs = planEnv.getStagingTableResultsInfo(rootTempGroupName);
        rs.setCriteria(Criteria.combineCriteria((Criteria)rs.getCriteria(), (Criteria)criteria));
        return true;
    }

    static boolean planRowLimitFunction(Criteria conjunct, Criteria wholeCrit, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Function rowLimitFunction = null;
        Constant rowLimitConstant = null;
        boolean exceptionOnRowLimit = false;
        if (conjunct instanceof CompareCriteria) {
            Function function;
            CompareCriteria crit = (CompareCriteria)conjunct;
            if (crit.getLeftExpression() instanceof Function) {
                function = (Function)crit.getLeftExpression();
                if (function.getName().equalsIgnoreCase("rowlimit")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getRightExpression();
                } else if (function.getName().equalsIgnoreCase("rowlimitexception")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getRightExpression();
                    exceptionOnRowLimit = true;
                }
            }
            if (rowLimitFunction == null && crit.getRightExpression() instanceof Function) {
                function = (Function)crit.getRightExpression();
                if (function.getName().equalsIgnoreCase("rowlimit")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getLeftExpression();
                } else if (function.getName().equalsIgnoreCase("rowlimitexception")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getLeftExpression();
                    exceptionOnRowLimit = true;
                }
            }
        }
        if (rowLimitFunction == null) {
            return false;
        }
        int rowLimit = (Integer)rowLimitConstant.getValue();
        String fullyQualifiedNodeName = planEnv.getGlobalMetadata().getFullName(((ElementSymbol)rowLimitFunction.getArg(0)).getMetadataID());
        MappingNode node = MappingNode.findNode((MappingNode)planEnv.mappingDoc, (String)fullyQualifiedNodeName.toUpperCase());
        MappingSourceNode sourceNode = node.getSourceNode();
        if (sourceNode == null) {
            String msg = QueryExecPlugin.Util.getString("XMLPlanner.The_rowlimit_parameter_{0}_is_not_in_the_scope_of_any_mapping_class", (Object)fullyQualifiedNodeName);
            throw new QueryPlannerException(msg);
        }
        ResultSetInfo criteriaRsInfo = sourceNode.getResultSetInfo();
        int existingLimit = criteriaRsInfo.getUserRowLimit();
        if (existingLimit > 0 && existingLimit != rowLimit) {
            String msg = QueryExecPlugin.Util.getString("XMLPlanner.Criteria_{0}_contains_conflicting_row_limits", (Object)wholeCrit);
            throw new QueryPlannerException(msg);
        }
        criteriaRsInfo.setUserRowLimit(rowLimit, exceptionOnRowLimit);
        return true;
    }

    static String getStagingTableForConjunct(Criteria conjunct, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Collection functions;
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)conjunct, (boolean)true);
        boolean first = true;
        String resultSet = null;
        Iterator elemIter = elements.iterator();
        while (elemIter.hasNext()) {
            boolean hasTempElement;
            ElementSymbol element = (ElementSymbol)elemIter.next();
            GroupSymbol group = element.getGroupSymbol();
            boolean bl = hasTempElement = !metadata.isXMLGroup(group.getMetadataID());
            if (!first && hasTempElement && resultSet == null) {
                throw new QueryPlannerException("ERR.015.004.0035", QueryExecPlugin.Util.getString("ERR.015.004.0035", (Object)conjunct));
            }
            if (hasTempElement) {
                String currentResultSet = metadata.getFullName(element.getGroupSymbol().getMetadataID());
                if (resultSet != null && !resultSet.equalsIgnoreCase(currentResultSet)) {
                    throw new QueryPlannerException(QueryExecPlugin.Util.getString("CriteriaPlanner.multiple_staging", (Object)conjunct));
                }
                resultSet = currentResultSet;
            }
            first = false;
        }
        if (resultSet != null && !(functions = ContextReplacerVisitor.replaceContextFunctions((LanguageObject)conjunct)).isEmpty()) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("CriteriaPlanner.staging_context"));
        }
        return resultSet;
    }

    static MappingNode getContext(XMLPlannerEnvironment planEnv, Function contextFunction) throws QueryPlannerException {
        ElementSymbol targetContext = (ElementSymbol)contextFunction.getArg(0);
        MappingNode contextNode = MappingNode.findNode((MappingNode)planEnv.mappingDoc, (String)targetContext.getFullyQualifiedName().toUpperCase());
        if (contextNode == null) {
            throw new QueryPlannerException("ERR.015.004.0037", QueryExecPlugin.Util.getString("ERR.015.004.0037", (Object)targetContext));
        }
        return contextNode;
    }
}

