/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.common.comm.api.ServerConnectionContext;
import java.util.StringTokenizer;

public class SocketServerConnectionContext
implements ServerConnectionContext {
    private long sessionID;
    private String clusterName;
    private long pingInterval;
    private int resourceAlgorithm;

    public SocketServerConnectionContext(long sessionID, int virtualSocketID, String clusterName, long pingInterval, int resourceAlgorithm) {
        this.sessionID = sessionID;
        this.clusterName = clusterName;
    }

    public SocketServerConnectionContext(String portableString) {
        StringTokenizer tokenizer = new StringTokenizer(portableString, ":");
        tokenizer.nextToken();
        this.sessionID = Long.parseLong(tokenizer.nextToken());
        this.clusterName = tokenizer.nextToken();
        this.pingInterval = Long.parseLong(tokenizer.nextToken());
        this.resourceAlgorithm = Integer.parseInt(tokenizer.nextToken());
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public int getResourceAlgorithm() {
        return this.resourceAlgorithm;
    }

    public String getPortableString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SSCContext:");
        buffer.append(this.sessionID);
        buffer.append(":");
        buffer.append(this.clusterName);
        buffer.append(":");
        buffer.append(this.pingInterval);
        buffer.append(":");
        buffer.append(this.resourceAlgorithm);
        return buffer.toString();
    }
}

