/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.client;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.SocketConstants;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactoryImpl;
import com.metamatrix.common.comm.platform.client.ServerAdminClientInterceptor;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactoryImpl;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.core.proxy.ServiceEndpoint;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceProxyFactory;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;

public class ServerAdminFactory {
    public static final String DEFAULT_APPLICATION_NAME = "Admin";
    public static final String METAMATRIX_PRODUCT_NAME = "Platform";
    private static ServerAdminFactory instance = null;
    private SocketServerConnectionFactory connectionFactory = null;
    static /* synthetic */ Class class$com$metamatrix$admin$api$server$ServerAdmin;

    private ServerAdminFactory() {
    }

    public static synchronized ServerAdminFactory getInstance() {
        if (instance == null) {
            instance = new ServerAdminFactory();
        }
        return instance;
    }

    public ServerAdmin createAdmin(String userName, char[] password, String serverURL) throws LogonException, AdminException {
        return this.createAdmin(userName, password, serverURL, DEFAULT_APPLICATION_NAME);
    }

    public ServerAdmin createAdmin(String userName, char[] password, String serverURL, String applicationName) throws LogonException, AdminException {
        if (userName == null || userName.trim().length() == 0) {
            throw new IllegalArgumentException(CommPlatformPlugin.Util.getString("ERR.014.001.0099"));
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException(CommPlatformPlugin.Util.getString("ERR.014.001.0100"));
        }
        this.initConnectionFactory();
        ServerAdmin admin = this.createAdminProxy(userName, password, serverURL, applicationName);
        return admin;
    }

    private synchronized void initConnectionFactory() {
        if (this.connectionFactory == null) {
            ClientSideLogonFactoryImpl clientSideLogonFactory = ClientSideLogonFactoryImpl.getInstance();
            ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactory();
            ObjectSocketFactoryImpl objectSocketFactory = ObjectSocketFactoryImpl.getInstance();
            this.connectionFactory = new SocketServerConnectionFactory(SocketConstants.getMaxThreads(), SocketConstants.getTTL(), SocketConstants.getSynchronousTTL(), SocketConstants.getLog("ADMIN_API_CONNECTION"), this.getClass().getClassLoader(), SocketConstants.getInputBufferSize(), SocketConstants.getOutputBufferSize(), SocketConstants.getConserveBandwidth(), clientSideLogonFactory, serviceProxyFactory, objectSocketFactory);
        }
    }

    private ServerAdmin createAdminProxy(String userName, char[] password, String serverURL, String applicationName) throws AdminException {
        ServiceInterceptor[] interceptors = new ServiceInterceptor[]{ServiceEndpoint.getAttributeSettingInterceptor((Class)(class$com$metamatrix$admin$api$server$ServerAdmin == null ? (class$com$metamatrix$admin$api$server$ServerAdmin = ServerAdminFactory.class$("com.metamatrix.admin.api.server.ServerAdmin")) : class$com$metamatrix$admin$api$server$ServerAdmin))};
        ServerAdminClientInterceptor terminalInterceptor = new ServerAdminClientInterceptor(userName, password, serverURL, applicationName, this.connectionFactory);
        ServerAdmin admin = (ServerAdmin)new ServiceProxyFactory().create(class$com$metamatrix$admin$api$server$ServerAdmin == null ? (class$com$metamatrix$admin$api$server$ServerAdmin = ServerAdminFactory.class$("com.metamatrix.admin.api.server.ServerAdmin")) : class$com$metamatrix$admin$api$server$ServerAdmin, interceptors, (TerminalServiceInterceptor)terminalInterceptor);
        admin.getSystem();
        return admin;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

