/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metabase.internal.platform;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.metabase.repository.events.DirectoryEventTarget;
import com.metamatrix.metabase.repository.internal.events.DirectoryEvent;
import com.metamatrix.metabase.repository.internal.interceptor.RepositoryAuthorizationService;
import com.metamatrix.metabase.repository.internal.util.InvocationHelper;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.MetaBasePermissionFactory;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.api.service.ServerSessionService;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.rmi.RemoteException;

public class PlatformRepositoryAuthorizationService
implements RepositoryAuthorizationService {
    private AuthorizationServiceInterface authProxy;
    private ServerSessionService sessionProxy;
    private MembershipServiceInterface membershipService;

    public boolean isAuthorized(SecurityContext securityContext, String commandName, String path, boolean recursive) {
        try {
            String context = "com.metamatrix.metabase.repository";
            if (path == null) {
                return this.getAuthProxy().hasPolicy(this.getSessionToken(securityContext), RolePermissionFactory.getRealm(), "Admin.ProductAdmin");
            }
            AuthorizationPermission permission = this.createAuthorizationPermission(commandName, path);
            boolean result = false;
            result = recursive ? this.getAuthProxy().checkAccess(this.getSessionToken(securityContext), "com.metamatrix.metabase.repository", permission, true) : this.getAuthProxy().checkAccess(this.getSessionToken(securityContext), "com.metamatrix.metabase.repository", permission);
            return result;
        }
        catch (InvalidUserException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (AuthorizationMgmtException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (ComponentNotFoundException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (MembershipServiceException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private SessionToken getSessionToken(SecurityContext securityContext) throws InvalidSessionException, ServiceException, ComponentNotFoundException {
        try {
            String sessionId = securityContext.getConnectionId();
            MetaMatrixSessionID mmSessionId = new MetaMatrixSessionID(Long.valueOf(sessionId).longValue());
            SessionToken token = this.getSessionProxy().validateSession(mmSessionId);
            return token;
        }
        catch (SessionServiceException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private AuthorizationPermission createAuthorizationPermission(String methodName, String path) {
        MetaBasePermissionFactory factory = new MetaBasePermissionFactory();
        return factory.create(path, null, InvocationHelper.getAuthorizationAction((String)methodName));
    }

    public AuthorizationServiceInterface getAuthProxy() throws ServiceException {
        if (this.authProxy == null) {
            this.authProxy = PlatformProxyHelper.getAuthorizationServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        }
        return this.authProxy;
    }

    public ServerSessionService getSessionProxy() throws ServiceException {
        if (this.sessionProxy == null) {
            this.sessionProxy = PlatformProxyHelper.getSessionServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        }
        return this.sessionProxy;
    }

    public MembershipServiceInterface getMembershipProxy() throws ServiceException {
        if (this.membershipService == null) {
            this.membershipService = PlatformProxyHelper.getMembershipServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        }
        return this.membershipService;
    }

    public void processRepositoryChanges(DirectoryEvent event) throws AuthorizationException, ComponentNotFoundException, ServiceException {
        DirectoryEventTarget target = event.getTarget();
        String targetPath = target.getPath();
        String targetUUID = target.getUUID();
        String user = target.getUser();
        boolean isAdd = event.isAddEvent();
        try {
            this.getAuthProxy().processRepositoryChanges(targetPath, targetUUID, user, isAdd);
        }
        catch (RemoteException err) {
            throw new ServiceException((Throwable)err);
        }
    }

    public boolean isSuperUser(String userName) throws ServiceException, MetaMatrixSecurityException {
        try {
            return this.getMembershipProxy().isSuperUser(userName);
        }
        catch (RemoteException err) {
            throw new ServiceException((Throwable)err);
        }
    }
}

