/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.db2.DB2ImplBlob;
import com.metamatrix.jdbc.db2.DB2ImplClob;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAResultSetRequest;
import com.metamatrix.jdbc.db2.drda.DRDAStatementRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public class DB2ImplResultSet
extends BaseImplResultSet {
    private static String footprint = "$Revision:   3.68.1.7  $";
    DRDAResultSetRequest request;
    BaseData nullBaseData;
    boolean isClosed;
    DRDACommunication comm;
    boolean isCachedResultSet;

    public DB2ImplResultSet(DRDAResultSetRequest dRDAResultSetRequest, DRDACommunication dRDACommunication) throws SQLException {
        this.request = dRDAResultSetRequest;
        this.isClosed = false;
        this.isCachedResultSet = false;
        this.comm = dRDACommunication;
    }

    public DB2ImplResultSet(DRDAStatementRequest dRDAStatementRequest, DRDACommunication dRDACommunication) throws SQLException {
        this.request = new DRDAResultSetRequest(dRDAStatementRequest.implConn, dRDAStatementRequest.comm, dRDAStatementRequest.reader, dRDAStatementRequest.writer, dRDAStatementRequest.packageConsistencyToken);
        this.request.columnDescriptions = dRDAStatementRequest.columnDescriptions;
        this.request.parameterDescriptions = dRDAStatementRequest.parameterDescriptions;
        this.request.chainCommit = dRDAStatementRequest.chainCommit;
        this.request.lobLocParam = dRDAStatementRequest.lobLocParam;
        this.request.useOUTOVRlob = dRDAStatementRequest.useOUTOVRlob;
        this.request.isCursorOpen = dRDAStatementRequest.isCursorOpen;
        this.request.isCursorHeldOpen = dRDAStatementRequest.isCursorHeldOpen;
        this.request.isStoredProcedure = dRDAStatementRequest.isStoredProcedure;
        this.request.moreData = dRDAStatementRequest.moreData;
        this.request.hasClobColumns = dRDAStatementRequest.hasClobColumns;
        this.request.hasLobCols = dRDAStatementRequest.hasLobCols;
        this.request.processingQRYDTA = dRDAStatementRequest.processingQRYDTA;
        this.request.lastLobColumnNum = dRDAStatementRequest.lastLobColumnNum;
        this.isClosed = false;
        this.isCachedResultSet = false;
        this.comm = dRDACommunication;
    }

    public DB2ImplResultSet() throws SQLException {
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (!this.isClosed) {
                this.request.discardRemainingRows();
                if (!this.request.reader.atEndOfReply()) {
                    this.request.clearExceptions();
                    this.request.processReply(this.warnings);
                } else if (this.comm.allowsLobStreamingAtSQLAM6 && this.request.SQLAM6LOBReader != null) {
                    DRDAByteOrderedDataReader dRDAByteOrderedDataReader = this.request.reader;
                    try {
                        this.request.reader = this.request.SQLAM6LOBReader;
                        if (this.request.reader.currentPacketLength == this.request.reader.numBytesReadFromCurrentPacket && !this.request.reader.depacketizingExtendedPacket && !this.request.reader.atEndOfReply()) {
                            this.request.processMode = 2;
                            this.request.processReply(this.warnings);
                        }
                    }
                    finally {
                        this.request.reader = dRDAByteOrderedDataReader;
                    }
                }
                if (this.request.isCursorOpen) {
                    if (this.comm.serverType == 9 && this.implStatement != null) {
                        if (((DB2ImplStatement)this.implStatement).resultSetArray == null || ((DB2ImplStatement)this.implStatement).resultSetArray.length <= 1) {
                            this.request.closeQuery(this.warnings);
                            this.request.submitRequest();
                            this.request.processReply(this.warnings);
                            if (this.comm.implConn.inAutoCommit && this.comm.implConn.inLocalTransaction) {
                                this.comm.implConn.comm.packageManager.updatePackageSections();
                            }
                        }
                    } else {
                        this.request.closeQuery(this.warnings);
                        this.request.submitRequest();
                        this.request.processReply(this.warnings);
                        if (this.comm.implConn.inAutoCommit && this.comm.implConn.inLocalTransaction) {
                            this.comm.implConn.comm.packageManager.updatePackageSections();
                        }
                    }
                } else if (this.comm.implConn.autoCommitResults && this.comm.implConn.inAutoCommit && this.comm.implConn.inLocalTransaction && (((DB2ImplStatement)this.implStatement).resultSetArray == null || ((DB2ImplStatement)this.implStatement).resultSetArray.length <= 1)) {
                    this.comm.implConn.commitTransaction();
                }
                if (this.request.reader != null) {
                    this.request.reader.empty();
                }
                if (this.request.SQLAM6LOBReader != null) {
                    this.request.SQLAM6LOBReader.close();
                }
            }
            this.isClosed = true;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        this.request.hasWarnings = false;
        if (this.request.getNextRow(this.warnings)) {
            return true;
        }
        this.request.processingQRYDTA = this.request.processingQRYDTA && this.request.reader.currentPacketLength > this.request.reader.numBytesReadFromCurrentPacket;
        return false;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        if (this.implStatement != null && this.implStatement.databaseMetaDataResultSet != 0) {
            if (this.nullBaseData == null) {
                this.nullBaseData = new BaseData((BaseConnection)this.comm.implConn.db2Connection);
            }
            if (this.comm.supportsStoredProcMetadata && (this.implStatement.databaseMetaDataResultSet == 1 && n > 5 || this.implStatement.databaseMetaDataResultSet == 2 && n > 18)) {
                return this.nullBaseData;
            }
        }
        BaseData baseData = this.request.getColumnBaseDataObject(n, n2, this.warnings);
        if (this.implStatement != null && this.implStatement.databaseMetaDataResultSet != 0) {
            switch (this.implStatement.databaseMetaDataResultSet) {
                case 1: {
                    if (this.comm.supportsStoredProcMetadata && n == 1) {
                        baseData.setString(this.comm.implConn.databaseName.toUpperCase());
                    }
                    if (n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 2: {
                    String string;
                    BaseData baseData2;
                    if (this.comm.supportsStoredProcMetadata && n == 1) {
                        baseData.setString(this.comm.implConn.databaseName.toUpperCase());
                    }
                    if (!(n != 2 && n != 6 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if (n == 6) {
                        baseData2 = this.request.getColumnBaseDataObject(6, 10, this.warnings);
                        string = baseData2.getString(-1, this.exceptions);
                        if (string.indexOf("VARBIN") == 0) {
                            baseData.setString("VARBINARY");
                        }
                        if (string.indexOf("VARG") == 0) {
                            baseData.setString("VARGRAPHIC");
                        }
                        if (string.indexOf("VARGRAPH") == 0) {
                            baseData.setString("VARGRAPHIC");
                        }
                        if (string.indexOf("LONGVARG") == 0) {
                            baseData.setString("LONG VARGRAPHIC");
                        }
                    }
                    if (n == 5) {
                        baseData2 = this.request.getColumnBaseDataObject(n + 1, 10, this.warnings);
                        if (this.comm.serverOS == 8) {
                            boolean bl;
                            int n3 = this.request.getColumnBaseDataObject(23, 10, this.warnings).getIntegerNoConvert();
                            boolean bl2 = bl = n3 == 65535;
                            if (bl) {
                                String string2 = baseData2.getString(-1, this.exceptions);
                                if (string2.indexOf("LONG VARCHAR") != -1) {
                                    string2 = "LONG VARCHAR() FOR BIT DATA";
                                } else if (string2.indexOf("VARCHAR") != -1) {
                                    string2 = "VARCHAR() FOR BIT DATA";
                                } else if (string2.indexOf("CHAR") != -1) {
                                    string2 = "CHAR() FOR BIT DATA";
                                }
                                baseData2.setString(string2);
                            }
                        } else if (this.comm.serverOS == 3) {
                            string = this.request.getColumnBaseDataObject(23, 10, this.warnings).getStringNoConvert();
                            boolean bl = string.equalsIgnoreCase("B");
                            if (bl) {
                                String string3 = baseData2.getString(-1, this.exceptions);
                                if (string3.indexOf("LONG VARCHAR") != -1 || string3.indexOf("LONGVAR") != -1) {
                                    string3 = "LONG VARCHAR() FOR BIT DATA";
                                } else if (string3.indexOf("VARCHAR") != -1) {
                                    string3 = "VARCHAR() FOR BIT DATA";
                                } else if (string3.indexOf("CHAR") != -1) {
                                    string3 = "CHAR() FOR BIT DATA";
                                }
                                baseData2.setString(string3);
                            }
                        } else if (this.comm.serverType == 8) {
                            int n4 = this.request.getColumnBaseDataObject(23, 4, this.warnings).getInteger(this.exceptions);
                            boolean bl = n4 == 0;
                            String string4 = baseData2.getString(-1, this.exceptions);
                            if (bl) {
                                if (string4.indexOf("LONG VARCHAR") != -1 || string4.indexOf("LONGVAR") != -1) {
                                    string4 = "LONG VARCHAR() FOR BIT DATA";
                                } else if (string4.indexOf("VARCHAR") != -1) {
                                    string4 = "VARCHAR() FOR BIT DATA";
                                } else if (string4.indexOf("CHAR") != -1) {
                                    string4 = "CHAR() FOR BIT DATA";
                                }
                                baseData2.setString(string4);
                            }
                        }
                        baseData.setData(4, (Object)this.request.drdaUtil.DB2ToJdbcTypeName(baseData2.getString(-1, this.exceptions)));
                    }
                    if (n == 5 || n == 14) {
                        baseData2 = this.request.getColumnBaseDataObject(6, 10, this.warnings);
                        string = baseData2.getString(-1, this.exceptions);
                        if (string.indexOf("XML") == 0) {
                            baseData.setData(4, (Object)new Integer(this.comm.implConn.xmlDescribeType));
                        } else if (string.indexOf("GRAPHIC") == 0) {
                            baseData.setData(4, (Object)new Integer(1));
                        } else if (string.indexOf("VARGRAPHIC") == 0) {
                            baseData.setData(4, (Object)new Integer(12));
                        } else if (string.indexOf("VARGRAPH") == 0) {
                            baseData.setData(4, (Object)new Integer(12));
                        } else if (string.indexOf("VARG") == 0) {
                            baseData.setData(4, (Object)new Integer(12));
                        } else if (string.indexOf("LONG VARGRAPHIC") == 0) {
                            baseData.setData(4, (Object)new Integer(-1));
                        } else if (string.indexOf("LONGVARG") == 0) {
                            baseData.setData(4, (Object)new Integer(-1));
                        }
                    }
                    if (n == 7) {
                        baseData2 = this.request.getColumnBaseDataObject(6, 10, this.warnings);
                        string = baseData2.getString(-1, this.exceptions);
                        if (string.indexOf("XML") == 0) {
                            baseData.setData(4, (Object)new Integer(Integer.MAX_VALUE));
                        }
                        if (this.comm.supportsStoredProcMetadata) {
                            if (string.indexOf("GRAPHIC") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("VARGRAPHIC") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("VARGRAPH") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("VARG") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("LONG VARGRAPHIC") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("LONGVARG") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            }
                        }
                    }
                    if (n == 8 && (string = (baseData2 = this.request.getColumnBaseDataObject(6, 10, this.warnings)).getString(-1, this.exceptions)).indexOf("XML") == 0) {
                        baseData.setData(4, (Object)new Integer(Integer.MAX_VALUE));
                    }
                    if (n == 13) {
                        baseData2 = this.request.getColumnBaseDataObject(6, 10, this.warnings);
                        string = baseData2.getString(-1, this.exceptions);
                        if (this.comm.supportsStoredProcMetadata) {
                            if (string.indexOf("GRAPHIC") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("VARGRAPHIC") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("VARGRAPH") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("VARG") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("LONG VARGRAPHIC") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            } else if (string.indexOf("LONGVARG") == 0) {
                                baseData.setData(4, (Object)new Integer(baseData.getIntegerNoConvert() / 2));
                            }
                        }
                    }
                    if (n == 9) {
                        int n5 = this.request.getColumnBaseDataObject(5, 4, this.warnings).getInteger(this.exceptions);
                        switch (n5) {
                            case -1: 
                            case 1: 
                            case 12: 
                            case 2005: {
                                baseData.setNull(4);
                            }
                        }
                    }
                    if (this.comm.serverOS != 8 || n != 11) break;
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("N")) {
                        baseData.setData(4, (Object)new Integer(0));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("Y")) {
                        baseData.setData(4, (Object)new Integer(1));
                        break;
                    }
                    baseData.setData(4, (Object)new Integer(2));
                    break;
                }
                case 6: {
                    if (n == 1 && (this.comm.serverType == 8 || this.comm.serverType == 9)) {
                        return this.nullBaseData;
                    }
                    if (n == 2 && !baseData.isNull()) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if (!(n != 4 && n != 7 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if (n == 6) {
                        BaseData baseData3 = this.request.getColumnBaseDataObject(n + 1, 10, this.warnings);
                        baseData.setData(4, (Object)this.request.drdaUtil.DB2ToJdbcTypeName(baseData3.getString(-1, this.exceptions)));
                    }
                    if (this.comm.serverOS == 8 && n == 5) {
                        if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("IN")) {
                            baseData.setData(4, (Object)new Integer(1));
                        } else if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("INOUT")) {
                            baseData.setData(4, (Object)new Integer(2));
                        } else if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("OUT")) {
                            baseData.setData(4, (Object)new Integer(4));
                        } else {
                            baseData.setData(4, (Object)new Integer(0));
                        }
                    }
                    if (this.comm.serverOS != 8 || n != 12) break;
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("NO")) {
                        baseData.setData(4, (Object)new Integer(0));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("YES")) {
                        baseData.setData(4, (Object)new Integer(1));
                        break;
                    }
                    baseData.setData(4, (Object)new Integer(2));
                    break;
                }
                case 7: {
                    if (n == 3) {
                        BaseData baseData4 = this.request.getColumnBaseDataObject(n + 1, 10, this.warnings);
                        String string = baseData4.getString(-1, this.exceptions);
                        if (string != null && string.length() != 0) {
                            baseData.setData(4, (Object)this.request.drdaUtil.DB2ToJdbcTypeName(string));
                        } else {
                            baseData.setString("1");
                            baseData4.setString("CHAR");
                        }
                    }
                    if (n != 7 || !baseData.isNull) break;
                    baseData.setInteger(0);
                    break;
                }
                case 10: {
                    if (!(n != 6 && n != 4 && n != 8 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                }
                case 11: 
                case 12: {
                    if ((n == 1 || n == 5) && baseData.isNull) {
                        baseData.setString(((DB2ImplStatement)this.implStatement).implConn.databaseName.toUpperCase());
                    }
                    if (!(n != 2 && n != 6 && n != 3 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if ((n == 10 || n == 11) && baseData.isNull) {
                        baseData.setData(4, (Object)new Integer(3));
                    }
                    if (n == 14 && baseData.isNull) {
                        baseData.setData(4, (Object)new Integer(7));
                    }
                    if (n != 11 || this.comm.serverOS != 8 || this.comm.supportsStoredProcMetadata && (!this.comm.disableImportedKeysSystemProc || this.implStatement.databaseMetaDataResultSet != 12) && this.implStatement.databaseMetaDataResultSet != 10) break;
                    if (baseData.getString(-1, this.exceptions).equals("A")) {
                        baseData.setData(4, (Object)new Integer(3));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equals("C")) {
                        baseData.setData(4, (Object)new Integer(0));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equals("N")) {
                        baseData.setData(4, (Object)new Integer(2));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equals("R")) {
                        baseData.setData(4, (Object)new Integer(1));
                        break;
                    }
                    baseData.setData(4, (Object)new Integer(3));
                    break;
                }
                case 16: {
                    if (n == 7 && !baseData.isNull()) {
                        baseData.setNull(10);
                    }
                    if (n != 2 && n != 4 && n != 5 && n != 6 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 13: {
                    if (n != 2 && n != 5 && n != 13 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 5: {
                    if (n == 1 && (this.comm.serverType == 8 || this.comm.serverType == 9)) {
                        return this.nullBaseData;
                    }
                    if (n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 9: 
                case 14: {
                    if (this.comm.supportsStoredProcMetadata && n == 1) {
                        baseData.setString(this.comm.implConn.databaseName.toUpperCase());
                    }
                    if (n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 15: {
                    if (n != 1 && n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
            }
        }
        return baseData;
    }

    public void makeResultSetCached(UtilPagedTempBuffer utilPagedTempBuffer, int n, BaseParameters baseParameters, DRDAPkgNamCsn dRDAPkgNamCsn) throws SQLException {
        this.isCachedResultSet = true;
        DRDAByteOrderedDataReader dRDAByteOrderedDataReader = this.comm.createReader(utilPagedTempBuffer, n);
        this.request = new DRDAResultSetRequest(this.request.implConn, this.request.comm, dRDAByteOrderedDataReader, this.request.writer, dRDAPkgNamCsn);
        this.request.setParameters(baseParameters);
        this.request.isStoredProcedureRS = true;
        this.request.isCachedRequest = true;
        this.request.isStoredProcedure = true;
        this.request.processMode = 0;
        this.request.processReply(this.warnings);
    }

    public BaseColumns getColumnDescriptions() {
        return this.request.columnDescriptions;
    }

    protected boolean setupForNextResultSetInMultipleResult() throws SQLException {
        return true;
    }

    public BaseImplBlob readBlob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        try {
            long l = randomAccessFile.readLong();
            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
            byte[] byArray = new byte[32000];
            int n = 0;
            long l2 = 0L;
            int n2 = new Long(l).intValue();
            while (n2 > 0) {
                n = randomAccessFile.read(byArray, 0, Math.min(32000, n2));
                utilPagedTempBuffer.write(l2, byArray, 0, n);
                n2 -= n;
                l2 += (long)n;
            }
            DB2ImplBlob dB2ImplBlob = new DB2ImplBlob(l, this.comm.implConn, utilPagedTempBuffer);
            return dB2ImplBlob;
        }
        catch (UtilException utilException) {
            throw new SQLException(utilException.getMessage());
        }
    }

    public void writeBlob(RandomAccessFile randomAccessFile, BaseImplBlob baseImplBlob) throws SQLException, IOException {
        try {
            UtilPagedTempBuffer utilPagedTempBuffer = ((DB2ImplBlob)baseImplBlob).getData();
            long l = utilPagedTempBuffer.getSize();
            randomAccessFile.writeLong(l);
            InputStream inputStream = utilPagedTempBuffer.getInputStream();
            int n = new Long(l).intValue();
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[16384];
            while (n > 0) {
                n2 = inputStream.read(byArray, 0, Math.min(16384, n));
                randomAccessFile.write(byArray, 0, n2);
                n -= n2;
                n3 += n2;
            }
        }
        catch (IOException iOException) {
            throw this.comm.exceptions.getException((Exception)iOException);
        }
    }

    public BaseImplClob readClob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        try {
            boolean bl = randomAccessFile.readBoolean();
            long l = randomAccessFile.readLong();
            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
            byte[] byArray = new byte[32000];
            int n = 0;
            long l2 = 0L;
            int n2 = new Long(l).intValue();
            while (n2 > 0) {
                n = randomAccessFile.read(byArray, 0, Math.min(32000, n2));
                utilPagedTempBuffer.write(l2, byArray, 0, n);
                n2 -= n;
                l2 += (long)n;
            }
            DB2ImplClob dB2ImplClob = new DB2ImplClob(this.comm.implConn, utilPagedTempBuffer);
            dB2ImplClob.setIsEmulatedClob(bl);
            return dB2ImplClob;
        }
        catch (UtilException utilException) {
            throw new SQLException(utilException.getMessage());
        }
    }

    public void writeClob(RandomAccessFile randomAccessFile, BaseImplClob baseImplClob) throws SQLException, IOException {
        try {
            UtilPagedTempBuffer utilPagedTempBuffer = ((DB2ImplClob)baseImplClob).getData();
            long l = utilPagedTempBuffer.getSize();
            randomAccessFile.writeBoolean(((DB2ImplClob)baseImplClob).getIsEmulatedClob());
            randomAccessFile.writeLong(l);
            InputStream inputStream = utilPagedTempBuffer.getInputStream();
            int n = new Long(l).intValue();
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[16384];
            while (n > 0) {
                n2 = inputStream.read(byArray, 0, Math.min(16384, n));
                randomAccessFile.write(byArray, 0, n2);
                n -= n2;
                n3 += n2;
            }
        }
        catch (IOException iOException) {
            throw this.comm.exceptions.getException((Exception)iOException);
        }
    }

    public int getColumnAccess() {
        return 2;
    }
}

