/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.platform.socket.SocketServiceStruct;
import com.metamatrix.common.comm.service.SocketService;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.FindResourcesRequest;
import com.metamatrix.platform.security.api.FindResourcesResult;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SocketLogon
implements ILogon {
    private ILogon delegate;
    private List firewalls;
    private boolean useFirewall = false;

    public SocketLogon(ILogon delegate, List firewallAddresses) {
        this.delegate = delegate;
        this.firewalls = firewallAddresses;
        if (this.firewalls != null && this.firewalls.size() > 0) {
            this.useFirewall = true;
        }
    }

    public FindResourcesResult findResources(FindResourcesRequest request) throws ComponentNotFoundException, RemoteException {
        FindResourcesResult result = this.delegate.findResources(request);
        this.convertResources(request, result);
        return result;
    }

    private void convertResources(FindResourcesRequest request, FindResourcesResult result) throws RemoteException {
        ArrayList originalResources = new ArrayList(result.getResources());
        result.clearResources();
        Iterator i = originalResources.iterator();
        while (i.hasNext()) {
            SocketService remoteResource = (SocketService)i.next();
            if (this.useFirewall) {
                String reqAddress = null;
                if (request.getConnectedAddress() != null) {
                    reqAddress = request.getConnectedAddress().toLowerCase();
                }
                if (reqAddress != null && this.firewalls.contains(reqAddress)) {
                    result.addResource((Remote)((Object)new SocketServiceStruct(reqAddress, remoteResource.getPort())));
                    continue;
                }
                if (remoteResource.getInetAddress() != null) {
                    result.addResource((Remote)((Object)new SocketServiceStruct(remoteResource.getInetAddress(), remoteResource.getPort())));
                    continue;
                }
                result.addResource((Remote)((Object)new SocketServiceStruct(remoteResource.getHost(), remoteResource.getPort())));
                continue;
            }
            if (remoteResource.getInetAddress() != null) {
                result.addResource((Remote)((Object)new SocketServiceStruct(remoteResource.getInetAddress(), remoteResource.getPort())));
                continue;
            }
            result.addResource((Remote)((Object)new SocketServiceStruct(remoteResource.getHost(), remoteResource.getPort())));
        }
    }

    public void logoff(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException, RemoteException {
        this.delegate.logoff(sessionID);
    }

    public LogonResult logon(String userName, Credentials password, Serializable trustedToken, String applicationName, String productName, String[] productInfo, FindResourcesRequest findResourcesRequest) throws LogonException, ComponentNotFoundException, RemoteException {
        LogonResult logonResult = this.delegate.logon(userName, password, trustedToken, applicationName, productName, productInfo, findResourcesRequest);
        this.convertResources(findResourcesRequest, (FindResourcesResult)logonResult);
        return logonResult;
    }

    public void ping(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException, RemoteException {
        this.delegate.ping(sessionID);
    }
}

