/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.sqlserver.SQLServerEscapeTranslator;
import com.metamatrix.jdbc.sqlserver.SQLServerImplConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplDatabaseMetaData;
import com.metamatrix.jdbc.sqlserver.SQLServerImplResultSet;
import com.metamatrix.jdbc.sqlserver.SQLServerImplResultSetServerSideCursor;
import com.metamatrix.jdbc.sqlserver.tds.TDSDTCRequest;
import java.sql.SQLException;

public final class SQLServerConnection
extends BaseConnection {
    private static String footprint = "$Revision:   3.35.1.2  $";
    public SQLServerImplConnection implConnection = null;
    SQLServerImplDatabaseMetaData databaseMetaData = null;
    private int implResultSetCacheIndex = -1;
    private int implResultSetServerSideCursorCacheIndex = -1;
    private final int IMPL_RESULT_SET_CACHE_SIZE = 32;
    private SQLServerImplResultSet[] implResultSetCache = new SQLServerImplResultSet[32];
    private SQLServerImplResultSetServerSideCursor[] implResultSetServerSideCursorCache = new SQLServerImplResultSetServerSideCursor[32];
    public StringBuffer stringBufferForConversion = new StringBuffer(50);
    public boolean distributedTransactionCompleted = false;

    protected void getImplPropertyInfo(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        baseDriverPropertyInfos.put("user", "Login ID", "", null, false);
        baseDriverPropertyInfos.put("password", "Login Password", "", null, false);
        baseDriverPropertyInfos.put("databaseName", "Database name", "", null, false);
        baseDriverPropertyInfos.put("serverName", "Server name", "", null, true);
        baseDriverPropertyInfos.put("portNumber", "Port number", "1433", null, false);
        String[] stringArray = new String[]{"cursor", "direct"};
        baseDriverPropertyInfos.put("selectMethod", "Select Method", "direct", stringArray, false);
        String[] stringArray2 = new String[]{"false", "true"};
        baseDriverPropertyInfos.put("sendStringParametersAsUnicode", "Send UCS2 String Parameters As Unicode", "true", stringArray2, false);
        baseDriverPropertyInfos.put("useServerSideUpdatableCursors", "Use SQLServer native cursors for result set updatabality", "false", stringArray2, false);
        baseDriverPropertyInfos.put("programName", "Name of the application program", "", null, false);
        baseDriverPropertyInfos.put("hostProcess", "Workstation process ID number", "0", null, false);
        baseDriverPropertyInfos.put("netAddress", "Workstation's network interface card address", "000000000000", null, false);
        baseDriverPropertyInfos.put("WSID", "Workstation's ID", "", null, false);
        baseDriverPropertyInfos.put("codePageOverride", "Code page override", "", null, false);
        baseDriverPropertyInfos.put("alwaysReportTriggerResults", "Always Report Trigger Results", "false", stringArray2, false);
        String[] stringArray3 = new String[]{"varchar", "nvarchar", "describe"};
        baseDriverPropertyInfos.put("receiveStringParameterType", "Receive string parameter type", "nvarchar", stringArray3, false);
        String[] stringArray4 = new String[]{"auto", "Kerberos", "NTLM", "UserIdPassword", "type4", "type2", "none"};
        baseDriverPropertyInfos.put("authenticationMethod", "Authentication method used to connect", "auto", stringArray4, false);
        baseDriverPropertyInfos.put("packetSize", "Packet size", "-1", null, false);
        baseDriverPropertyInfos.put("enableCancelTimeout", "Enable Cancel Timeout", "false", null, false);
        baseDriverPropertyInfos.put("snapshotSerializable", "Determines the meaning of the TRANSACTION_SERIALIZABLE transaction isolation level", "false", null, false);
        String[] stringArray5 = new String[]{"implicit", "explicit"};
        baseDriverPropertyInfos.put("transactionMode", "Transaction mode when autocommit is off", "implicit", stringArray5, false);
        String[] stringArray6 = new String[]{"describeIfString", "noDescribe"};
        baseDriverPropertyInfos.put("describeParameters", "Determines how string parameters are sent to the server", "noDescribe", stringArray6, false);
        String[] stringArray7 = new String[]{"NoEncryption", "SSL", "RequestSSL", "LoginSSL"};
        baseDriverPropertyInfos.put("encryptionMethod", "Specifies the driver encryption method. The encryption method determines whether the driver encrypts and decrypts the data sent between the driver and the database server.", "NoEncryption", stringArray7, false);
        baseDriverPropertyInfos.put("trustStore", "An override of javax.net.ssl.trustStore", "", null, false);
        baseDriverPropertyInfos.put("trustStorePassword", "An override of javax.net.ssl.trustStorePassword", "", null, false);
        baseDriverPropertyInfos.put("validateServerCertificate", "Specifies whether the driver will validate the server certificate returned by the database server.", "true", null, false);
        baseDriverPropertyInfos.put("hostNameInCertificate", "Specifies the name the driver will use to compare with the Common Name in the certificate returned by the database server during the SSL session establishment.", "", null, false);
        String[] stringArray8 = new String[]{"LONGVARCHAR", "LONGVARBINARY"};
        baseDriverPropertyInfos.put("XMLDescribeType", "Specify whether the driver describes XML columns as LONGVARCHAR or LONGVARBINARY", "LONGVARCHAR", stringArray8, false);
        baseDriverPropertyInfos.put("longDataCacheSize", "Specifies the maximum amount of memory, in kilobytes, the driver will use to buffer long data", "2048", null, false);
        baseDriverPropertyInfos.put("defaultScale", "Specifies the default scale for decimal or numeric output parameters", "4", null, false);
    }

    protected BaseImplConnection createImplConnection(BaseConnectionProperties baseConnectionProperties) {
        this.implConnection = new SQLServerImplConnection(this);
        return this.implConnection;
    }

    public BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerImplDatabaseMetaData(baseConnectionProperties);
        }
        return this.databaseMetaData;
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return new SQLServerEscapeTranslator(this);
    }

    public TDSDTCRequest createTDSDTCRequest() {
        return new TDSDTCRequest(this.implConnection.conn, this.implConnection.reader, this.implConnection.writer);
    }

    public SQLServerImplResultSet getImplResultSet() {
        SQLServerImplResultSet sQLServerImplResultSet = null;
        if (this.implResultSetCacheIndex >= 0) {
            sQLServerImplResultSet = this.implResultSetCache[this.implResultSetCacheIndex--];
        }
        return sQLServerImplResultSet;
    }

    public void putImplResultSet(SQLServerImplResultSet sQLServerImplResultSet) {
        if (this.implResultSetCacheIndex < 31) {
            this.implResultSetCache[++this.implResultSetCacheIndex] = sQLServerImplResultSet;
        }
    }

    public SQLServerImplResultSetServerSideCursor getImplResultSetServerSideCursor() {
        SQLServerImplResultSetServerSideCursor sQLServerImplResultSetServerSideCursor = null;
        if (this.implResultSetServerSideCursorCacheIndex >= 0) {
            sQLServerImplResultSetServerSideCursor = this.implResultSetServerSideCursorCache[this.implResultSetServerSideCursorCacheIndex--];
        }
        return sQLServerImplResultSetServerSideCursor;
    }

    public void putImplResultSetServerSideCursor(SQLServerImplResultSetServerSideCursor sQLServerImplResultSetServerSideCursor) {
        if (this.implResultSetServerSideCursorCacheIndex < 31) {
            this.implResultSetServerSideCursorCache[++this.implResultSetServerSideCursorCacheIndex] = sQLServerImplResultSetServerSideCursor;
        }
    }
}

