/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.tns;

import com.metamatrix.jdbc.oracle.tns.TnsValueInfo;
import java.util.ArrayList;

public class TnsAddress {
    private static String footprint = "$Revision:   1.1.1.0  $";
    public static int TNSPROTOCOL_TCP = 0;
    public static int TNSPROTOCOL_TCPS = 1;
    public static int TNSPROTOCOL_IPC = 2;
    public static int TNSPROTOCOL_NMP = 3;
    public static int TNSPROTOCOL_NONE = 4;
    private int m_protocol = TNSPROTOCOL_NONE;
    private int m_port = 1521;
    private String m_host = "";

    TnsAddress(String string, String string2) {
        this.m_host = string == null ? "localhost" : string;
        this.m_port = string2 == null ? 1521 : Integer.parseInt(string2);
        this.m_protocol = TNSPROTOCOL_TCP;
    }

    TnsAddress(TnsValueInfo tnsValueInfo) {
        ArrayList arrayList = tnsValueInfo.getValues();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            TnsValueInfo tnsValueInfo2 = new TnsValueInfo((String)arrayList.get(i));
            if (tnsValueInfo2.Equals("PROTOCOL")) {
                if (tnsValueInfo2.ValueEquals("TCP")) {
                    this.m_protocol = TNSPROTOCOL_TCP;
                    continue;
                }
                if (tnsValueInfo2.ValueEquals("TCPS")) {
                    this.m_protocol = TNSPROTOCOL_TCPS;
                    continue;
                }
                if (tnsValueInfo2.ValueEquals("IPC")) {
                    this.m_protocol = TNSPROTOCOL_IPC;
                    continue;
                }
                if (!tnsValueInfo2.ValueEquals("NMP")) continue;
                this.m_protocol = TNSPROTOCOL_NMP;
                continue;
            }
            if (tnsValueInfo2.Equals("PORT")) {
                this.m_port = Integer.parseInt(tnsValueInfo2.getValue());
                continue;
            }
            if (!tnsValueInfo2.Equals("HOST")) continue;
            this.m_host = tnsValueInfo2.getValue();
        }
    }

    public int getPort() {
        return this.m_port;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getProtocol() {
        return this.m_protocol;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_protocol == TNSPROTOCOL_TCP || this.m_protocol == TNSPROTOCOL_TCPS) {
            stringBuffer.append("(ADDRESS=(PROTOCOL=tcp)(PORT=" + this.m_port + ")(HOST=" + this.m_host + "))");
        }
        return stringBuffer.toString();
    }
}

