/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.types.BlobImpl;
import com.metamatrix.common.types.ClobImpl;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.common.util.SqlUtil;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.core.log.Logger;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.CursorResultsImpl;
import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMParameterMetaData;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsMetadataProvider;
import com.metamatrix.jdbc.ResultsMetadataWithProvider;
import com.metamatrix.jdbc.StaticMetadataProvider;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class MMPreparedStatement
extends MMStatement
implements PreparedStatement {
    private String prepareSql;
    private Map parameterMap;
    protected List parameterMapList;
    private MMResultSet resultSet;
    private ResultSetMetaData metadata;
    private Calendar serverCalendar;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMPreparedStatement;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMConnection;
    static /* synthetic */ Class class$java$lang$String;

    static MMPreparedStatement newInstance(MMConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (AOP.useproxy()) {
            return (MMPreparedStatement)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$MMPreparedStatement == null ? (class$com$metamatrix$jdbc$MMPreparedStatement = MMPreparedStatement.class$("com.metamatrix.jdbc.MMPreparedStatement")) : class$com$metamatrix$jdbc$MMPreparedStatement), (Class[])new Class[]{class$com$metamatrix$jdbc$MMConnection == null ? (class$com$metamatrix$jdbc$MMConnection = MMPreparedStatement.class$("com.metamatrix.jdbc.MMConnection")) : class$com$metamatrix$jdbc$MMConnection, class$java$lang$String == null ? (class$java$lang$String = MMPreparedStatement.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{connection, sql, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        return new MMPreparedStatement(connection, sql, resultSetType, resultSetConcurrency);
    }

    MMPreparedStatement(MMConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency);
        ArgCheck.isNotNull((Object)sql, (String)JDBCPlugin.Util.getString("MMPreparedStatement.Err_prep_sql"));
        this.prepareSql = sql;
        this.isUpdateSql(sql);
        TimeZone timezone = connection.getServerConnection().getTimeZone();
        if (timezone != null && !timezone.equals(TimestampWithTimezone.DEFAULT_TIME_ZONE)) {
            this.serverCalendar = Calendar.getInstance(timezone);
        }
    }

    public void addBatch() throws SQLException {
        if (this.parameterMapList == null) {
            this.parameterMapList = new ArrayList();
        }
        this.parameterMapList.add(new TreeMap(this.parameterMap));
        this.parameterMap.clear();
    }

    public void clearParameters() throws SQLException {
        this.checkStatement();
        if (this.parameterMap != null) {
            this.parameterMap.clear();
        }
    }

    public void close() throws SQLException {
        this.prepareSql = null;
        super.close();
    }

    public boolean execute() throws SQLException {
        this.checkStatement();
        if (this.isUpdateSql(this.prepareSql)) {
            this.executeUpdate();
            return false;
        }
        this.executeQuery();
        return true;
    }

    private void processQueryMessage(ResultsMessage resultsMsg) {
        try {
            CursorResultsImpl resultsImpl = null;
            List resultsWarning = resultsMsg.getWarnings();
            this.setAnalysisInfo(resultsMsg);
            if (resultsMsg.getException() != null) {
                this.setException((Throwable)resultsMsg.getException());
            }
            if (resultsWarning != null) {
                this.setWarnings(resultsWarning);
            }
            resultsImpl = !resultsMsg.isPartialResults() ? CursorResultsImpl.newInstance((ResultsMessage)resultsMsg, (MMStatement)this) : CursorResultsImpl.newInstance((ResultsMessage)resultsMsg, (MMStatement)this);
            this.resultSet = resultsImpl;
        }
        catch (Throwable t) {
            this.setException(t);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkStatement();
        this.resetExecutionState();
        this.processQueryMessage(this.internalExecute(new String[]{this.prepareSql}, false));
        MMSQLException ex = this.getException();
        if (ex == null && this.resultSet == null) {
            String msg;
            if (this.commandStatus == 4) {
                msg = JDBCPlugin.Util.getString("MMStatement.Timeout_before_execute");
                this.setException((Throwable)new MMSQLException(msg));
            } else if (this.commandStatus == 3) {
                msg = JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute");
                this.setException((Throwable)new MMSQLException(msg));
            }
        }
        if ((ex = this.getException()) != null) {
            throw ex;
        }
        String logMsg = JDBCPlugin.Util.getString("MMStatement.Success_query", (Object)this.prepareSql);
        this.getLogger().log(4, logMsg);
        super.setResultSet(this.resultSet);
        return this.resultSet;
    }

    private void processUpdateMessage(ResultsMessage resultsMsg) {
        MetaMatrixException resultsExp = resultsMsg.getException();
        List resultsWarning = resultsMsg.getWarnings();
        this.setAnalysisInfo(resultsMsg);
        if (resultsExp != null) {
            this.setException((Throwable)resultsExp);
        } else {
            if (resultsWarning != null) {
                this.setWarnings(resultsWarning);
            }
            this.resultSet = CursorResultsImpl.newInstance((ResultsMessage)resultsMsg, (MMStatement)this);
        }
    }

    public int executeUpdate() throws SQLException {
        this.executeUpdate(false);
        return super.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(boolean isBatchedUpdate) throws SQLException {
        this.checkStatement();
        if (this.driverConnection.isReadOnly()) {
            String logMsg = JDBCPlugin.Util.getString("MMStatement.Operation_Not_Supported", (Object)this.prepareSql);
            this.getLogger().log(2, logMsg);
            throw new MMSQLException(logMsg);
        }
        int updateCount = 0;
        this.resetExecutionState();
        this.processUpdateMessage(this.internalExecute(new String[]{this.prepareSql}, isBatchedUpdate));
        MMSQLException ex = this.getException();
        if (ex == null) {
            if (this.commandStatus == 4) {
                String msg = JDBCPlugin.Util.getString("MMStatement.Timeout_before_execute");
                this.setException((Throwable)new MMSQLException(msg));
            } else if (this.commandStatus == 3) {
                String msg = JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute");
                this.setException((Throwable)new MMSQLException(msg));
            } else if (this.resultSet.next()) {
                try {
                    if (isBatchedUpdate) {
                        Object result = this.resultSet.getObject(1);
                        if (result instanceof int[]) {
                            this.updateCounts = (int[])this.resultSet.getObject(1);
                        } else {
                            int commandIndex = 0;
                            this.updateCounts = new int[this.parameterMapList.size()];
                            do {
                                this.updateCounts[commandIndex++] = this.resultSet.getInt(1);
                            } while (this.resultSet.next());
                        }
                    } else {
                        updateCount = this.resultSet.getInt(1);
                        super.setUpdateCount(updateCount);
                    }
                    String logMsg = JDBCPlugin.Util.getString("MMStatement.Success_update", (Object)this.prepareSql);
                    this.getLogger().log(4, logMsg);
                }
                catch (SQLException se) {
                    String msg = JDBCPlugin.Util.getString("MMStatement.Err_getting_update_row");
                    this.setException((Throwable)MMSQLException.create((Throwable)se, (String)msg));
                }
                finally {
                    this.resultSet.close();
                    this.resultSet = null;
                }
            }
        }
        if ((ex = this.getException()) != null) {
            throw ex;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStatement();
        if (SqlUtil.isUpdateSql((String)this.prepareSql)) {
            return null;
        }
        if (this.metadata == null) {
            ResultSet resultSet = this.getResultSet();
            if (resultSet != null) {
                this.metadata = resultSet.getMetaData();
            } else {
                MetaDataMessage metadataMsg = new MetaDataMessage(this.prepareSql);
                metadataMsg.setDoubleQuotedVariablesAllowed(Boolean.valueOf(this.getExecutionProperty("allowDoubleQuotedVariable")).booleanValue());
                Message results = this.executeAsynchAndWait((Message)metadataMsg);
                if (results instanceof MessageHolder) {
                    MessageHolder holder = (MessageHolder)results;
                    ExceptionHolder exHolder = (ExceptionHolder)holder.contents;
                    throw MMSQLException.create((Throwable)exHolder.exception);
                }
                MetaDataMessage returnedMetadataMsg = (MetaDataMessage)results;
                if (returnedMetadataMsg.getException() != null) {
                    throw MMSQLException.create((Throwable)returnedMetadataMsg.getException());
                }
                StaticMetadataProvider provider = StaticMetadataProvider.createWithData((Map[])returnedMetadataMsg.getMetadataMap(), (int)returnedMetadataMsg.getParameterCount(), (Logger)this.getLogger());
                this.metadata = ResultsMetadataWithProvider.newInstance((ResultsMetadataProvider)provider, this.getLogger());
            }
        }
        return this.metadata;
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setAsciiStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, new ClobImpl(in, length));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    public void setBinaryStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, new BlobImpl(in, length));
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setObject(parameterIndex, new Boolean(value));
    }

    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.setObject(parameterIndex, new Byte(value));
    }

    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.setObject(parameterIndex, new BlobImpl(bytes));
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setObject(parameterIndex, new ClobImpl(reader, length));
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.setDate(parameterIndex, value, null);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createDate((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setObject(parameterIndex, new Double(value));
    }

    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setObject(parameterIndex, new Float(value));
    }

    public void setInt(int parameterIndex, int value) throws SQLException {
        this.setObject(parameterIndex, new Integer(value));
    }

    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setObject(parameterIndex, new Long(value));
    }

    public void setNull(int parameterIndex, int jdbcType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    public void setNull(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    public void setObject(int parameterIndex, Object value, int targetJdbcType, int scale) throws SQLException {
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        if (targetJdbcType != 3 || targetJdbcType != 2) {
            this.setObject(parameterIndex, value, targetJdbcType);
        } else {
            BigDecimal bigDecimalObject = DataTypeTransformer.getBigDecimal((Object)value);
            bigDecimalObject.setScale(scale);
            this.setObject(parameterIndex, bigDecimalObject);
        }
    }

    public void setObject(int parameterIndex, Object value, int targetJdbcType) throws SQLException {
        Object targetObject = null;
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        String javaClassName = MMJDBCSQLTypeInfo.getJavaClassName((int)targetJdbcType);
        if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.STRING_CLASS)) {
            targetObject = value.toString();
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.CHAR_CLASS)) {
            targetObject = DataTypeTransformer.getCharacter((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.INTEGER_CLASS)) {
            targetObject = DataTypeTransformer.getInteger((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BYTE_CLASS)) {
            targetObject = DataTypeTransformer.getByte((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.SHORT_CLASS)) {
            targetObject = DataTypeTransformer.getShort((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.LONG_CLASS)) {
            targetObject = DataTypeTransformer.getLong((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.FLOAT_CLASS)) {
            targetObject = DataTypeTransformer.getFloat((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.DOUBLE_CLASS)) {
            targetObject = DataTypeTransformer.getDouble((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BOOLEAN_CLASS)) {
            targetObject = DataTypeTransformer.getBoolean((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BIGDECIMAL_CLASS)) {
            targetObject = DataTypeTransformer.getBigDecimal((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.TIMESTAMP_CLASS)) {
            targetObject = DataTypeTransformer.getTimestamp((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.DATE_CLASS)) {
            targetObject = DataTypeTransformer.getDate((Object)value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.TIME_CLASS)) {
            targetObject = DataTypeTransformer.getTime((Object)value);
        } else if (javaClassName.equalsIgnoreCase("java.sql.Blob")) {
            targetObject = DataTypeTransformer.getBlob((Object)value);
        } else if (javaClassName.equalsIgnoreCase("java.sql.Clob")) {
            targetObject = DataTypeTransformer.getClob((Object)value);
        } else {
            String msg = JDBCPlugin.Util.getString("MMPreparedStatement.Err_transform_obj");
            throw new MMSQLException(msg);
        }
        this.setObject(parameterIndex, targetObject);
    }

    public void setObject(int parameterIndex, Object value) throws SQLException {
        ArgCheck.isPositive((int)parameterIndex, (String)JDBCPlugin.Util.getString("MMPreparedStatement.Invalid_param_index"));
        if (this.parameterMap == null) {
            this.parameterMap = new TreeMap();
        }
        if (this.serverCalendar != null && value instanceof java.util.Date) {
            value = TimestampWithTimezone.create((java.util.Date)((java.util.Date)value), null, (Calendar)this.serverCalendar, value.getClass());
        }
        this.parameterMap.put(new Integer(parameterIndex), value);
    }

    public void setRef(int parameterIndex, Ref jdbcType) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setObject(parameterIndex, new Short(value));
    }

    public void setString(int parameterIndex, String value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.setTime(parameterIndex, value, null);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createTime((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.setTimestamp(parameterIndex, value, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createTimestamp((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    public void setUnicodeStream(int parameterIndex, InputStream fin, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    protected ResultsMessage internalExecute(String[] commands, boolean isPreparedBatchUpdate) throws SQLException {
        try {
            return this.sendRequestMessageAndWait(commands, true, false, isPreparedBatchUpdate ? this.getParameterValuesList() : this.getParameterValues(), false, isPreparedBatchUpdate);
        }
        catch (Throwable ex) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Error_executing_stmt", (Object)commands[0]);
            this.getLogger().log(2, ex, msg);
            throw MMSQLException.create((Throwable)ex, (String)msg);
        }
    }

    public List getParameterValuesList() {
        if (this.parameterMapList == null || this.parameterMapList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(this.parameterMapList.size());
        for (int i = 0; i < this.parameterMapList.size(); ++i) {
            result.add(new ArrayList(((Map)this.parameterMapList.get(i)).values()));
        }
        return result;
    }

    public List getParameterValues() {
        if (this.parameterMap == null || this.parameterMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.parameterMap.values());
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new MMParameterMetaData(this);
    }

    protected int getParameterCount() {
        return StringUtil.occurrences((String)this.prepareSql, (String)"?");
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean execute(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public int executeUpdate(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    protected void resetExecutionState() throws SQLException {
        super.resetExecutionState();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    void setServerCalendar(Calendar serverCalendar) {
        this.serverCalendar = serverCalendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        if (this.parameterMapList == null || this.parameterMapList.isEmpty()) {
            return new int[0];
        }
        try {
            this.executeUpdate(true);
        }
        finally {
            this.parameterMapList.clear();
        }
        return this.updateCounts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

