/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.slbase;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbcx.slbase.BaseConnectionWrapper;
import com.metamatrix.jdbcx.slbase.BaseDependent;
import com.metamatrix.jdbcx.slbase.BaseStatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class BaseResultSetWrapper
implements ResultSet,
BaseDependent {
    ResultSet realResultSet;
    private BaseConnectionWrapper connectionWrapper;
    private BaseStatementWrapper statementWrapper;
    private boolean isClosed;
    private BaseExceptions exceptions;

    protected void finalize() throws Throwable {
        if (this.statementWrapper == null && !this.isClosed) {
            this.connectionWrapper.notifyResultSetGarbage();
        }
        super.finalize();
    }

    public void doClose() {
    }

    public Object realObject() {
        return this.realResultSet;
    }

    BaseResultSetWrapper(ResultSet resultSet, BaseConnectionWrapper baseConnectionWrapper) throws SQLException {
        this.realResultSet = resultSet;
        this.connectionWrapper = baseConnectionWrapper;
        baseConnectionWrapper.addDependent(this);
    }

    BaseResultSetWrapper(BaseStatementWrapper baseStatementWrapper, ResultSet resultSet, BaseConnectionWrapper baseConnectionWrapper) throws SQLException {
        this.realResultSet = resultSet;
        this.connectionWrapper = baseConnectionWrapper;
        this.statementWrapper = baseStatementWrapper;
    }

    public boolean next() throws SQLException {
        try {
            return this.realResultSet.next();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        try {
            this.realResultSet.close();
            if (this.statementWrapper == null) {
                this.connectionWrapper.removeFromDependents(this);
            }
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
        finally {
            this.isClosed = true;
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            return this.realResultSet.wasNull();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getString(int n2) throws SQLException {
        try {
            return this.realResultSet.getString(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getInt(int n2) throws SQLException {
        try {
            return this.realResultSet.getInt(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public double getDouble(int n2) throws SQLException {
        try {
            return this.realResultSet.getDouble(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte[] getBytes(int n2) throws SQLException {
        try {
            return this.realResultSet.getBytes(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getBoolean(int n2) throws SQLException {
        try {
            return this.realResultSet.getBoolean(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte getByte(int n2) throws SQLException {
        try {
            return this.realResultSet.getByte(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public short getShort(int n2) throws SQLException {
        try {
            return this.realResultSet.getShort(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public long getLong(int n2) throws SQLException {
        try {
            return this.realResultSet.getLong(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public float getFloat(int n2) throws SQLException {
        try {
            return this.realResultSet.getFloat(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(int n2) throws SQLException {
        try {
            return this.realResultSet.getDate(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(int n2) throws SQLException {
        try {
            return this.realResultSet.getTime(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        try {
            return this.realResultSet.getAsciiStream(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        try {
            return this.realResultSet.getUnicodeStream(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        try {
            return this.realResultSet.getBinaryStream(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(int n2) throws SQLException {
        try {
            return this.realResultSet.getObject(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this.realResultSet.getString(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            return this.realResultSet.getBoolean(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            return this.realResultSet.getByte(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            return this.realResultSet.getShort(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            return this.realResultSet.getInt(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            return this.realResultSet.getLong(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            return this.realResultSet.getFloat(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            return this.realResultSet.getDouble(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(string, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            return this.realResultSet.getBytes(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            return this.realResultSet.getDate(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            return this.realResultSet.getTime(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            return this.realResultSet.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return this.realResultSet.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            return this.realResultSet.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.realResultSet.getWarnings();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.realResultSet.clearWarnings();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getCursorName() throws SQLException {
        try {
            return this.realResultSet.getCursorName();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.realResultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            return this.realResultSet.getObject(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int findColumn(String string) throws SQLException {
        try {
            return this.realResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        try {
            return this.realResultSet.getCharacterStream(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        try {
            return this.realResultSet.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.realResultSet.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            return this.realResultSet.isAfterLast();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            return this.realResultSet.isFirst();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isLast() throws SQLException {
        try {
            return this.realResultSet.isLast();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this.realResultSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void afterLast() throws SQLException {
        try {
            this.realResultSet.afterLast();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean first() throws SQLException {
        try {
            return this.realResultSet.first();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean last() throws SQLException {
        try {
            return this.realResultSet.last();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getRow() throws SQLException {
        try {
            return this.realResultSet.getRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean absolute(int n2) throws SQLException {
        try {
            return this.realResultSet.absolute(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean relative(int n2) throws SQLException {
        try {
            return this.realResultSet.relative(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean previous() throws SQLException {
        try {
            return this.realResultSet.previous();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFetchDirection(int n2) throws SQLException {
        try {
            this.realResultSet.setFetchDirection(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.realResultSet.getFetchDirection();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        try {
            this.realResultSet.setFetchSize(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.realResultSet.getFetchSize();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getType() throws SQLException {
        try {
            return this.realResultSet.getType();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            return this.realResultSet.getConcurrency();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            return this.realResultSet.rowUpdated();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            return this.realResultSet.rowInserted();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            return this.realResultSet.rowDeleted();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateNull(int n2) throws SQLException {
        try {
            this.realResultSet.updateNull(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        try {
            this.realResultSet.updateBoolean(n2, bl);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateByte(int n2, byte by) throws SQLException {
        try {
            this.realResultSet.updateByte(n2, by);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateShort(int n2, short s2) throws SQLException {
        try {
            this.realResultSet.updateShort(n2, s2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateInt(int n2, int n3) throws SQLException {
        try {
            this.realResultSet.updateInt(n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateLong(int n2, long l2) throws SQLException {
        try {
            this.realResultSet.updateLong(n2, l2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        try {
            this.realResultSet.updateFloat(n2, f2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        try {
            this.realResultSet.updateDouble(n2, d2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realResultSet.updateBigDecimal(n2, bigDecimal);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateString(int n2, String string) throws SQLException {
        try {
            this.realResultSet.updateString(n2, string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        try {
            this.realResultSet.updateBytes(n2, byArray);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDate(int n2, Date date) throws SQLException {
        try {
            this.realResultSet.updateDate(n2, date);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTime(int n2, Time time) throws SQLException {
        try {
            this.realResultSet.updateTime(n2, time);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            this.realResultSet.updateTimestamp(n2, timestamp);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realResultSet.updateAsciiStream(n2, inputStream, n3);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realResultSet.updateBinaryStream(n2, inputStream, n3);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            this.realResultSet.updateCharacterStream(n2, reader, n3);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        try {
            this.realResultSet.updateObject(n2, object, n3);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(int n2, Object object) throws SQLException {
        try {
            this.realResultSet.updateObject(n2, object);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateNull(String string) throws SQLException {
        try {
            this.realResultSet.updateNull(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            this.realResultSet.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        try {
            this.realResultSet.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateShort(String string, short s2) throws SQLException {
        try {
            this.realResultSet.updateShort(string, s2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateInt(String string, int n2) throws SQLException {
        try {
            this.realResultSet.updateInt(string, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateLong(String string, long l2) throws SQLException {
        try {
            this.realResultSet.updateLong(string, l2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateFloat(String string, float f2) throws SQLException {
        try {
            this.realResultSet.updateFloat(string, f2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDouble(String string, double d2) throws SQLException {
        try {
            this.realResultSet.updateDouble(string, d2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realResultSet.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        try {
            this.realResultSet.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            this.realResultSet.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        try {
            this.realResultSet.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        try {
            this.realResultSet.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            this.realResultSet.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realResultSet.updateAsciiStream(string, inputStream, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realResultSet.updateBinaryStream(string, inputStream, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        try {
            this.realResultSet.updateCharacterStream(string, reader, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        try {
            this.realResultSet.updateObject(string, object, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        try {
            this.realResultSet.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void insertRow() throws SQLException {
        try {
            this.realResultSet.insertRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateRow() throws SQLException {
        try {
            this.realResultSet.updateRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void deleteRow() throws SQLException {
        try {
            this.realResultSet.deleteRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void refreshRow() throws SQLException {
        try {
            this.realResultSet.refreshRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        try {
            this.realResultSet.cancelRowUpdates();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            this.realResultSet.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            this.realResultSet.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Statement getStatement() throws SQLException {
        try {
            this.realResultSet.getStatement();
            return this.statementWrapper;
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(int n2, Map map) throws SQLException {
        try {
            return this.realResultSet.getObject(n2, map);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Ref getRef(int n2) throws SQLException {
        try {
            return this.realResultSet.getRef(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Blob getBlob(int n2) throws SQLException {
        try {
            return this.realResultSet.getBlob(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Clob getClob(int n2) throws SQLException {
        try {
            return this.realResultSet.getClob(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Array getArray(int n2) throws SQLException {
        try {
            return this.realResultSet.getArray(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            return this.realResultSet.getObject(string, map);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return this.realResultSet.getRef(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return this.realResultSet.getBlob(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return this.realResultSet.getClob(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return this.realResultSet.getArray(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getDate(n2, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTime(n2, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(n2, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public URL getURL(int n2) throws SQLException {
        try {
            return this.realResultSet.getURL(n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this.realResultSet.getURL(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        try {
            this.realResultSet.updateRef(n2, ref);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            this.realResultSet.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        try {
            this.realResultSet.updateBlob(n2, blob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this.realResultSet.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        try {
            this.realResultSet.updateClob(n2, clob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this.realResultSet.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateArray(int n2, Array array) throws SQLException {
        try {
            this.realResultSet.updateArray(n2, array);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        try {
            this.realResultSet.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }
}

