/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIRXHDataPacket
extends TTIDataPacket {
    private static String footprint = "$Revision:   3.5.3.0  $";
    public int Flags;
    public int NumColumns;
    public int Iterations;
    public int CurrIterations;
    public int BufferLen;
    private boolean m_maskValid;
    private byte[] m_sentMask;

    public TTIRXHDataPacket() {
        this.TTCCode = 6;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
    }

    public byte[] getSentMask() {
        return this.m_maskValid ? this.m_sentMask : null;
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        short s;
        this.Flags = oracleDataProvider.readByte();
        this.NumColumns = oracleDataProvider.readB2();
        this.Iterations = oracleDataProvider.readB2();
        this.CurrIterations = oracleDataProvider.readB2();
        this.CurrIterations = this.CurrIterations >= 0 ? this.CurrIterations : this.CurrIterations + 256;
        this.BufferLen = oracleDataProvider.readB2();
        short s2 = oracleDataProvider.readB2();
        if (s2 > 0) {
            s = oracleDataProvider.readByte();
            if (this.m_sentMask == null || this.m_sentMask.length != s) {
                this.m_sentMask = new byte[s];
            }
            oracleDataProvider.readBytes(this.m_sentMask, 0, s);
            this.m_maskValid = true;
        } else {
            this.m_maskValid = false;
        }
        s = oracleDataProvider.readB2();
        if (s > 0) {
            oracleDataProvider.skipCLR();
        }
    }
}

