/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ui.wizards;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.DirectionKind;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.ProcedureResult;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.View;
import com.metamatrix.metamodels.xsd.XsdBuilderOptions;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelProjectSelectionStatusValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.ui.wizards.GenerateXsdWizard;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.ui.UiPlugin;
import com.metamatrix.modeler.ui.viewsupport.ModelingResourceFilter;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.product.ProductCustomizerMgr;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.widget.StatusLabel;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class GenerateXsdWizardOptionslPage
extends WizardPage
implements InternalUiConstants.Widgets,
UiConstants,
UiConstants.ProductInfo,
UiConstants.ProductInfo.Capabilities {
    private static final String XSD_EXT = ".xsd";
    private static final String XMI_EXT = ".xmi";
    private static final int DEFAULT_LBL_ROWS = 5;
    protected static boolean virtualRelationalLicensed = false;
    protected static boolean virtualXmlLicensed = false;
    protected static boolean licenseInfoInitialized = false;
    private final Collection unsavedResources = new HashSet();
    private final Collection invalidResources = new HashSet();
    private final Collection unvalidatedResources = new HashSet();
    private boolean validResources;
    private Button genOutputButton;
    private Button genXmlButton;
    private Button genSqlButton;
    private Button genInputButton;
    private Button genWsButton;
    private Button doFlatButton;
    private Text outputNameText;
    private Text inputNameText;
    private Text wsNameText;
    private StatusLabel statusLbl;
    private LinkedHashSet roots;
    private String rootName;
    private String parentPath;
    private Text containerText;
    private ISelection selection;

    public GenerateXsdWizardOptionslPage(ISelection selection) {
        super("optionsPage");
        this.setTitle(UiConstants.Util.getString("GenerateXsdWizard.title"));
        this.setDescription(UiConstants.Util.getString("GenerateXsdWizard.optionsDesc"));
        this.selection = selection;
        if (!licenseInfoInitialized) {
            licenseInfoInitialized = true;
            UiPlugin plugin = UiPlugin.getDefault();
            virtualRelationalLicensed = plugin.isModelerCapabilityLicensed("Views/Relational");
            virtualXmlLicensed = plugin.isModelerCapabilityLicensed("Views/XML");
        }
    }

    private void setDefaults() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (GenerateXsdWizardOptionslPage.this.rootName != null) {
                    GenerateXsdWizardOptionslPage.this.outputNameText.setText(GenerateXsdWizardOptionslPage.this.rootName + UiConstants.Util.getString("GenerateXsdWizard.outSuffix"));
                    GenerateXsdWizardOptionslPage.this.inputNameText.setText(GenerateXsdWizardOptionslPage.this.rootName + UiConstants.Util.getString("GenerateXsdWizard.inSuffix"));
                    GenerateXsdWizardOptionslPage.this.wsNameText.setText(GenerateXsdWizardOptionslPage.this.rootName + UiConstants.Util.getString("GenerateXsdWizard.wsSuffix"));
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            Composite locationComposite = new Composite(container, 0);
            GridData locationCompositeGridData = new GridData(1808);
            locationComposite.setLayoutData((Object)locationCompositeGridData);
            GridLayout locationLayout = new GridLayout();
            locationLayout.numColumns = 3;
            locationComposite.setLayout((Layout)locationLayout);
            Label locationMsg = new Label(locationComposite, 0);
            GridData locationMsgGridData = new GridData();
            locationMsgGridData.horizontalSpan = 3;
            locationMsg.setLayoutData((Object)locationMsgGridData);
            locationMsg.setText(UiConstants.Util.getString("GenerateXsdWizard.locationMessage"));
            this.containerText = new Text(locationComposite, 2052);
            GridData gd = new GridData(768);
            this.containerText.setLayoutData((Object)gd);
            this.containerText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GenerateXsdWizardOptionslPage.this.checkStatus();
                }
            });
            this.containerText.setEditable(false);
            Button browseButton = new Button(locationComposite, 8);
            GridData buttonGridData = new GridData();
            browseButton.setLayoutData((Object)buttonGridData);
            browseButton.setText(UiConstants.Util.getString("GenerateXsdWizard.browse"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GenerateXsdWizardOptionslPage.this.handleBrowse();
                }
            });
        }
        Composite topComposite = new Composite(container, 0);
        GridData topCompositeGridData = new GridData(1808);
        topComposite.setLayoutData((Object)topCompositeGridData);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topComposite.setLayout((Layout)topLayout);
        Label prompt = new Label(topComposite, 0);
        GridData promptGridData = new GridData();
        promptGridData.horizontalSpan = 2;
        prompt.setLayoutData((Object)promptGridData);
        prompt.setText(UiConstants.Util.getString("GenerateXsdWizard.prompt"));
        Label spacer = new Label(topComposite, 0);
        GridData spGridData = new GridData();
        spGridData.horizontalSpan = 2;
        spacer.setLayoutData((Object)spGridData);
        Label opLabel = new Label(topComposite, 0);
        GridData opGridData = new GridData();
        opGridData.horizontalSpan = 2;
        opLabel.setLayoutData((Object)opGridData);
        opLabel.setText(UiConstants.Util.getString("GenerateXsdWizard.outOptions"));
        this.genOutputButton = new Button(topComposite, 32);
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 2;
        this.genOutputButton.setLayoutData((Object)buttonGridData);
        this.genOutputButton.setText(UiConstants.Util.getString("GenerateXsdWizard.outModel"));
        this.genOutputButton.setSelection(true);
        this.genOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.handleGenOutputButton();
            }
        });
        this.doFlatButton = new Button(topComposite, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 2;
        this.doFlatButton.setLayoutData((Object)buttonGridData);
        this.doFlatButton.setText(UiConstants.Util.getString("GenerateXsdWizard.doFlat"));
        this.doFlatButton.setSelection(true);
        Label modelNameLabel = new Label(topComposite, 0);
        modelNameLabel.setText(UiConstants.Util.getString("GenerateXsdWizard.modelName"));
        this.outputNameText = new Text(topComposite, 2052);
        GridData gd = new GridData(768);
        this.outputNameText.setLayoutData((Object)gd);
        this.outputNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateXsdWizardOptionslPage.this.checkStatus();
            }
        });
        this.genXmlButton = new Button(topComposite, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 2;
        this.genXmlButton.setLayoutData((Object)buttonGridData);
        this.genXmlButton.setText(UiConstants.Util.getString("GenerateXsdWizard.genXml"));
        this.genXmlButton.setSelection(true);
        this.genXmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.handleGenXmlButton();
            }
        });
        this.genSqlButton = new Button(topComposite, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 2;
        this.genSqlButton.setLayoutData((Object)buttonGridData);
        this.genSqlButton.setText(UiConstants.Util.getString("GenerateXsdWizard.genSql"));
        this.genSqlButton.setSelection(true);
        spacer = new Label(topComposite, 0);
        spGridData = new GridData();
        spGridData.horizontalSpan = 2;
        spacer.setLayoutData((Object)spGridData);
        Label inLabel = new Label(topComposite, 0);
        GridData inGridData = new GridData();
        inGridData.horizontalSpan = 2;
        inLabel.setLayoutData((Object)inGridData);
        inLabel.setText(UiConstants.Util.getString("GenerateXsdWizard.inOptions"));
        this.genInputButton = new Button(topComposite, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 2;
        this.genInputButton.setLayoutData((Object)buttonGridData);
        this.genInputButton.setText(UiConstants.Util.getString("GenerateXsdWizard.genInputForProcs"));
        this.genInputButton.setSelection(true);
        this.genInputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.handleGenInputButton();
            }
        });
        Label inputNameLabel = new Label(topComposite, 0);
        inputNameLabel.setText(UiConstants.Util.getString("GenerateXsdWizard.inputName"));
        this.inputNameText = new Text(topComposite, 2052);
        gd = new GridData(768);
        gd.verticalSpan = 2;
        this.inputNameText.setLayoutData((Object)gd);
        this.inputNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateXsdWizardOptionslPage.this.checkStatus();
            }
        });
        spacer = new Label(topComposite, 0);
        spGridData = new GridData();
        spGridData.horizontalSpan = 2;
        spacer.setLayoutData((Object)spGridData);
        Label wsLabel = new Label(topComposite, 0);
        GridData wsGridData = new GridData();
        wsGridData.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)wsGridData);
        wsLabel.setText(UiConstants.Util.getString("GenerateXsdWizard.wsOptions"));
        this.genWsButton = new Button(topComposite, 32);
        buttonGridData = new GridData();
        buttonGridData.horizontalSpan = 2;
        this.genWsButton.setLayoutData((Object)buttonGridData);
        this.genWsButton.setText(UiConstants.Util.getString("GenerateXsdWizard.genWs"));
        this.genWsButton.setSelection(true);
        this.genWsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateXsdWizardOptionslPage.this.handleGenWsButton();
            }
        });
        Label wsNameLabel = new Label(topComposite, 0);
        wsNameLabel.setText(UiConstants.Util.getString("GenerateXsdWizard.wsName"));
        this.wsNameText = new Text(topComposite, 2052);
        gd = new GridData(768);
        this.wsNameText.setLayoutData((Object)gd);
        this.wsNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateXsdWizardOptionslPage.this.checkStatus();
            }
        });
        spacer = new Label(topComposite, 0);
        spGridData = new GridData();
        spGridData.horizontalSpan = 2;
        spacer.setLayoutData((Object)spGridData);
        this.statusLbl = new StatusLabel(topComposite);
        this.statusLbl.setRows(5);
        GridData statusGridData = new GridData(4, 4, false, false);
        statusGridData.horizontalSpan = 2;
        this.statusLbl.setLayoutData((Object)statusGridData);
        this.setControl((Control)container);
        this.checkStatus();
        this.outputNameText.setFocus();
        this.setDefaults();
        this.initialize();
    }

    private void handleBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)((IContainer)this.getTargetContainer()), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.containerText != null) {
            this.containerText.setText(folder.getFullPath().makeRelative().toString());
            this.setParentPath(folder);
        }
        this.checkStatus();
    }

    private void handleGenInputButton() {
        this.inputNameText.setEnabled(this.genInputButton.getSelection());
        if (!this.genInputButton.getSelection()) {
            this.genWsButton.setSelection(false);
        }
        this.genWsButton.setEnabled(this.genInputButton.getSelection() && this.genOutputButton.getSelection());
        this.wsNameText.setEnabled(this.genInputButton.getSelection() && this.genOutputButton.getSelection());
        this.checkStatus();
    }

    private void handleGenWsButton() {
        this.wsNameText.setEnabled(this.genWsButton.getSelection());
        this.checkStatus();
    }

    private void handleGenXmlButton() {
        if (!this.genXmlButton.getSelection()) {
            this.genWsButton.setSelection(false);
        }
        this.genSqlButton.setEnabled(this.genXmlButton.getSelection());
        this.checkStatus();
    }

    private void handleGenOutputButton() {
        this.outputNameText.setEnabled(this.genOutputButton.getSelection());
        this.genSqlButton.setEnabled(this.genOutputButton.getSelection());
        this.genXmlButton.setEnabled(this.genOutputButton.getSelection());
        if (!this.genOutputButton.getSelection()) {
            this.genWsButton.setSelection(false);
        }
        this.genWsButton.setEnabled(this.genInputButton.getSelection() && this.genOutputButton.getSelection());
        this.wsNameText.setEnabled(this.genInputButton.getSelection() && this.genOutputButton.getSelection());
        this.checkStatus();
    }

    private void initialize() {
        block14: {
            block13: {
                Object sel;
                block15: {
                    this.roots = new LinkedHashSet();
                    if (SelectionUtilities.isEmptySelection((ISelection)this.selection)) {
                        return;
                    }
                    if (!SelectionUtilities.isSingleSelection((ISelection)this.selection)) break block13;
                    sel = SelectionUtilities.getSelectedObject((ISelection)this.selection);
                    this.processRootObject(sel, true);
                    if (sel instanceof IFile) {
                        String name = ((IFile)sel).getName();
                        this.rootName = name.endsWith(XMI_EXT) ? name.substring(0, name.indexOf(XMI_EXT)) : name;
                    } else if (sel instanceof RelationalEntity) {
                        String name;
                        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((RelationalEntity)sel));
                        this.rootName = mr != null ? ((name = mr.getItemName()).endsWith(XMI_EXT) ? name.substring(0, name.indexOf(XMI_EXT)) : name) : ((RelationalEntity)sel).getName();
                    }
                    if (this.selection == null || this.selection.isEmpty() || !(this.selection instanceof IStructuredSelection)) break block14;
                    IStructuredSelection ssel = (IStructuredSelection)this.selection;
                    if (ssel.size() > 1) {
                        return;
                    }
                    Object obj = ssel.getFirstElement();
                    if (!(obj instanceof IResource)) break block15;
                    IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                    if (this.containerText != null) {
                        this.containerText.setText(container.getFullPath().makeRelative().toString());
                    }
                    this.setParentPath(container);
                    break block14;
                }
                if (!(sel instanceof RelationalEntity)) break block14;
                ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((RelationalEntity)sel));
                if (mr != null) {
                    IResource theResource = null;
                    try {
                        theResource = mr.getCorrespondingResource();
                    }
                    catch (ModelWorkspaceException theException) {
                        UiConstants.Util.log((Throwable)theException);
                    }
                    if (theResource != null) {
                        IContainer container = theResource.getParent();
                        if (this.containerText != null && container != null) {
                            this.containerText.setText(container.getFullPath().makeRelative().toString());
                        }
                        this.setParentPath(container);
                    }
                } else {
                    this.rootName = ((RelationalEntity)sel).getName();
                }
                break block14;
            }
            List objs = SelectionUtilities.getSelectedObjects((ISelection)this.selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext()) {
                this.processRootObject(selections.next(), true);
            }
        }
    }

    private void addRootsFromResource(Resource rsrc) {
        if (this.parentPath == null) {
            URI uri = rsrc.getURI().trimSegments(1);
            this.parentPath = uri.toString();
        }
        TreeIterator contents = rsrc.getAllContents();
        while (contents.hasNext()) {
            this.processRootObject(contents.next(), false);
        }
    }

    private void setParentPath(Object root) {
        ModelResource modelResource;
        if (root instanceof IContainer) {
            this.parentPath = ((IContainer)root).getLocation().toString();
        } else if (root instanceof EObject) {
            URI uri = ((EObject)root).eResource().getURI().trimSegments(1);
            this.parentPath = uri.toFileString();
        } else if (root instanceof Resource) {
            URI uri = ((Resource)root).getURI().trimSegments(1);
            this.parentPath = uri.toFileString();
        } else if (root instanceof IFile && (modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)root))) != null) {
            try {
                Resource rsrc = modelResource.getEmfResource();
                URI uri = rsrc.getURI().trimSegments(1);
                this.parentPath = uri.toFileString();
            }
            catch (ModelWorkspaceException err) {
                UiConstants.Util.log((Throwable)err);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processRootObject(Object root, boolean validateResource) {
        if (root instanceof BaseTable || root instanceof View) {
            if (validateResource) {
                this.validateResource(root);
            }
            this.addRoot(root);
            return;
        } else if (root instanceof Procedure) {
            ProcedureResult res;
            if (validateResource) {
                this.validateResource(root);
            }
            if ((res = ((Procedure)root).getResult()) != null) {
                this.addRoot(res);
            }
            Iterator params = ((Procedure)root).getParameters().iterator();
            while (params.hasNext()) {
                ProcedureParameter param = (ProcedureParameter)params.next();
                DirectionKind dir = param.getDirection();
                if (dir == DirectionKind.OUT_LITERAL && res == null) {
                    this.addRoot(root);
                    continue;
                }
                if (dir != DirectionKind.INOUT_LITERAL || res != null) continue;
                this.addRoot(root);
            }
            return;
        } else {
            ModelResource modelResource;
            if (!(root instanceof IFile) || (modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)root))) == null) return;
            try {
                this.validateResource(modelResource);
                Resource rsrc = modelResource.getEmfResource();
                if (!this.validResources || !this.isRelationalModel(rsrc)) return;
                this.addRootsFromResource(rsrc);
                return;
            }
            catch (ModelWorkspaceException err) {
                UiConstants.Util.log((Throwable)err);
                return;
            }
        }
    }

    private void addRoot(Object root) {
        if (!this.roots.contains(root)) {
            this.roots.add(root);
        }
    }

    private void validateResource(Object root) {
        this.validResources = true;
        if (GenerateXsdWizard.HEADLESS) {
            return;
        }
        try {
            Resource rsrc;
            ModelResource mr = null;
            if (root instanceof ModelResource) {
                mr = (ModelResource)root;
            } else if (root instanceof EObject && (rsrc = ((EObject)root).eResource()) != null) {
                mr = ModelerCore.getModelWorkspace().findModelResource(rsrc);
            }
            if (mr == null) {
                this.validResources = false;
                return;
            }
            if (this.unsavedResources.contains(mr) || this.invalidResources.contains(mr) || this.unvalidatedResources.contains(mr)) {
                return;
            }
            if (ModelUtilities.requiresValidation((ModelResource)mr)) {
                this.unvalidatedResources.add(mr);
                this.validResources = false;
                return;
            }
            if (mr.hasUnsavedChanges()) {
                this.unsavedResources.add(mr);
                this.validResources = false;
                return;
            }
            IMarker[] problems = mr.getResource().findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            if (problems.length > 0) {
                for (int i = 0; i != problems.length; ++i) {
                    Integer severity = (Integer)problems[i].getAttribute("severity");
                    if (severity == null || severity != 2) continue;
                    this.invalidResources.add(mr);
                    this.validResources = false;
                    return;
                }
            }
        }
        catch (Exception err) {
            this.validResources = false;
        }
    }

    private boolean isRelationalModel(Resource rsrc) {
        if (rsrc == null || !(rsrc instanceof EmfResource)) {
            return false;
        }
        EmfResource eResource = (EmfResource)rsrc;
        ModelAnnotation annot = eResource.getModelAnnotation();
        return annot != null && "http://www.metamatrix.com/metamodels/Relational".equals(annot.getPrimaryMetamodelUri());
    }

    private void checkStatus() {
        File file;
        String fullPath;
        String msg;
        boolean hasWarnings = false;
        if (!this.unsavedResources.isEmpty()) {
            this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.unsavedModels"), 4);
            this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
            this.setPageComplete(false);
            return;
        }
        if (!this.invalidResources.isEmpty()) {
            this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.invalidModels"), 4);
            this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
            this.setPageComplete(false);
            return;
        }
        if (!this.unvalidatedResources.isEmpty()) {
            this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.unvalidatedModels"), 4);
            this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
            this.setPageComplete(false);
            return;
        }
        if (!this.validResources) {
            this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.errValidatingModels"), 4);
            this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
            this.setPageComplete(false);
            return;
        }
        if (!this.genOutputButton.getSelection() && !this.genInputButton.getSelection()) {
            this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.noBuilds"), 4);
            this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
            this.setPageComplete(false);
            return;
        }
        if (this.genOutputButton.getSelection()) {
            String modelName = this.outputNameText.getText();
            if (modelName.trim().length() == 0) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.enterModelFileName"), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
            msg = ModelUtilities.validateModelName((String)modelName, (String)XSD_EXT);
            if (msg != null) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.invalidModelFileName", (Object)msg), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
            fullPath = this.parentPath + File.separator + modelName + XSD_EXT;
            file = new File(fullPath);
            if (file.exists()) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.fileAlreadyExistsMessage", (Object)(modelName + XSD_EXT)), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
        }
        if (this.genInputButton.getSelection()) {
            String inputName = this.inputNameText.getText();
            if (inputName.trim().length() == 0) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.enterInputFileName"), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
            msg = ModelUtilities.validateModelName((String)inputName, (String)XSD_EXT);
            if (msg != null) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.invalidInputFileName", (Object)msg), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
            fullPath = this.parentPath + File.separator + inputName + XSD_EXT;
            file = new File(fullPath);
            if (file.exists()) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.fileAlreadyExistsMessage", (Object)(inputName + XSD_EXT)), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
        }
        if (this.genWsButton.getSelection()) {
            String wsName = this.wsNameText.getText();
            if (wsName.trim().length() == 0) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.enterWsFileName"), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
            if (wsName.indexOf(XMI_EXT) > 0) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.noExtWsFileName"), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
            msg = ModelUtilities.validateModelName((String)wsName, (String)XMI_EXT);
            if (msg != null) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.invalidWsFileName", (Object)msg), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
            fullPath = this.parentPath + File.separator + wsName + XMI_EXT;
            file = new File(fullPath);
            if (file.exists()) {
                this.setMessageLabelText(UiConstants.Util.getString("GenerateXsdWizard.fileAlreadyExistsMessage", (Object)(wsName + XMI_EXT)), 4);
                this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.errs"), 3);
                this.setPageComplete(false);
                return;
            }
        }
        if (!hasWarnings) {
            this.setMessage(UiConstants.Util.getString("GenerateXsdWizard.done"), 0);
            this.setMessageLabelText(null, 0);
        }
        this.setPageComplete(true);
    }

    private void setMessageLabelText(String text, int severity) {
        if (text == null) {
            this.statusLbl.setVisible(false);
        } else {
            this.statusLbl.setText(text, severity);
            this.statusLbl.update();
            this.statusLbl.setVisible(true);
        }
    }

    public XsdBuilderOptions getOptions() {
        boolean genOutput = this.genOutputButton.getSelection();
        boolean genXml = this.genXmlButton.getSelection() && genOutput;
        String xsdName = genOutput ? this.outputNameText.getText() : new String();
        boolean genSQL = this.genXmlButton.getSelection() && genOutput && genXml;
        boolean genInput = this.genInputButton.getSelection();
        String inputName = genInput ? this.inputNameText.getText() : new String();
        boolean genWs = this.genWsButton.getSelection() && genOutput && genInput && genXml;
        String wsName = genWs ? this.wsNameText.getText() : new String();
        boolean doFlat = this.doFlatButton.getSelection();
        XsdBuilderOptions ops = new XsdBuilderOptions(genOutput, genXml, doFlat, (Collection)this.roots, xsdName, genSQL, genInput, inputName, genWs, wsName, this.rootName);
        ops.setParentPath(this.parentPath);
        return ops;
    }

    public void dispose() {
        super.dispose();
    }

    public IResource getTargetContainer() {
        IWorkspaceRoot root;
        IResource resource;
        IResource result = null;
        String containerName = this.getContainerName();
        if (!StringUtil.isEmpty((String)containerName) && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource;
        }
        return result;
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    public String getContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.containerText.getText().trim();
        return result;
    }
}

