/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JoinPredicate
extends FromClause {
    private FromClause leftClause;
    private FromClause rightClause;
    private JoinType joinType = JoinType.JOIN_INNER;
    private List joinCriteria;

    public JoinPredicate() {
    }

    public JoinPredicate(FromClause leftClause, FromClause rightClause, JoinType type) {
        this.leftClause = leftClause;
        this.rightClause = rightClause;
        this.joinType = type;
        this.joinCriteria = new ArrayList();
    }

    public JoinPredicate(FromClause leftClause, FromClause rightClause, JoinType type, List criteria) {
        this.leftClause = leftClause;
        this.rightClause = rightClause;
        this.joinType = type;
        this.joinCriteria = criteria;
    }

    public JoinPredicate(FromClause leftClause, FromClause rightClause, JoinType type, Criteria criteria) {
        this.leftClause = leftClause;
        this.rightClause = rightClause;
        this.joinType = type;
        this.joinCriteria = Criteria.separateCriteriaByAnd((Criteria)criteria);
    }

    public void setLeftClause(FromClause predicate) {
        this.leftClause = predicate;
    }

    public FromClause getLeftClause() {
        return this.leftClause;
    }

    public void setRightClause(FromClause predicate) {
        this.rightClause = predicate;
    }

    public FromClause getRightClause() {
        return this.rightClause;
    }

    public void setJoinType(JoinType type) {
        this.joinType = type;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinCriteria(List criteria) {
        this.joinCriteria = criteria;
    }

    public List getJoinCriteria() {
        return this.joinCriteria;
    }

    public void collectGroups(Collection groups) {
        if (this.leftClause != null) {
            this.leftClause.collectGroups(groups);
        }
        if (this.rightClause != null) {
            this.rightClause.collectGroups(groups);
        }
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        List otherCrit;
        if (!super.equals(obj)) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().isInstance(obj)) {
            return false;
        }
        JoinPredicate other = (JoinPredicate)((Object)obj);
        List thisCrit = this.getJoinCriteria();
        if (thisCrit != null && thisCrit.size() == 0) {
            thisCrit = null;
        }
        if ((otherCrit = this.getJoinCriteria()) != null && otherCrit.size() == 0) {
            otherCrit = null;
        }
        return EquivalenceUtil.areEqual((Object)other.getJoinType(), (Object)this.getJoinType()) && EquivalenceUtil.areEqual((Object)other.getLeftClause(), (Object)this.getLeftClause()) && EquivalenceUtil.areEqual((Object)other.getRightClause(), (Object)this.getRightClause()) && EquivalenceUtil.areEqual((Object)otherCrit, (Object)thisCrit);
    }

    public int hashCode() {
        int hash = HashCodeUtil.hashCode((int)0, (Object)this.getLeftClause());
        hash = HashCodeUtil.hashCode((int)hash, (int)this.getJoinType().getTypeCode());
        hash = HashCodeUtil.hashCode((int)hash, (Object)this.getRightClause());
        return hash;
    }

    public Object clone() {
        FromClause copyLeft = null;
        if (this.leftClause != null) {
            copyLeft = (FromClause)this.leftClause.clone();
        }
        FromClause copyRight = null;
        if (this.rightClause != null) {
            copyRight = (FromClause)this.rightClause.clone();
        }
        ArrayList<Object> copyCrits = null;
        if (this.joinCriteria != null) {
            copyCrits = new ArrayList<Object>(this.joinCriteria.size());
            Iterator iter = this.joinCriteria.iterator();
            while (iter.hasNext()) {
                Criteria crit = (Criteria)iter.next();
                copyCrits.add(crit.clone());
            }
        }
        JoinPredicate clonedJoinPredicate = new JoinPredicate(copyLeft, copyRight, this.joinType, copyCrits);
        clonedJoinPredicate.setOptional(this.isOptional());
        clonedJoinPredicate.setMakeDep(this.isMakeDep());
        clonedJoinPredicate.setMakeNotDep(this.isMakeNotDep());
        return clonedJoinPredicate;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString((LanguageObject)this);
    }
}

