/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RulePlanProcedures
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)19, (int)3);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Reference ref;
            PlanNode node = (PlanNode)i.next();
            if (!FrameUtil.isProcedure(node.getFirstChild())) continue;
            StoredProcedure proc = (StoredProcedure)((Object)node.getProperty((Object)NodeConstants.Info.NESTED_COMMAND));
            HashSet<ElementSymbol> inputSymbols = new HashSet<ElementSymbol>();
            LinkedList<Expression> inputReferences = new LinkedList<Expression>();
            PlanNode critNode = node.getParent();
            LinkedList conjuncts = new LinkedList();
            HashSet coveredParams = new HashSet();
            if (!proc.isProcedureRelational()) continue;
            Iterator params = proc.getInputParameters().iterator();
            while (params.hasNext()) {
                SPParameter param = (SPParameter)params.next();
                ElementSymbol symbol = param.getParameterSymbol();
                Expression input = param.getExpression();
                inputReferences.add(input);
                inputSymbols.add(symbol);
            }
            this.findInputNodes(inputSymbols, critNode, conjuncts, coveredParams);
            LinkedList<Expression> defaults = new LinkedList<Expression>();
            Iterator params2 = inputReferences.iterator();
            while (params2.hasNext()) {
                ref = (Reference)params2.next();
                ElementSymbol symbol = (ElementSymbol)ref.getExpression();
                Expression defaultValue = null;
                if (proc.isExecWithDefault()) {
                    try {
                        defaultValue = ResolverUtil.getDefault(symbol, metadata);
                    }
                    catch (QueryResolverException qre) {
                        // empty catch block
                    }
                }
                defaults.add(defaultValue);
                if (defaultValue != null || coveredParams.contains(symbol)) continue;
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("RulePlanProcedures.no_values", (Object)symbol));
            }
            if (conjuncts.isEmpty()) {
                for (int j = 0; j < inputReferences.size(); ++j) {
                    ref = (Reference)inputReferences.get(j);
                    ref.setValue(defaults.get(j));
                }
                continue;
            }
            PlanNode accessNode = NodeEditor.findNodePreOrder((PlanNode)node, (int)3);
            Criteria crit = Criteria.combineCriteria(conjuncts);
            accessNode.setProperty((Object)NodeConstants.Info.PROCEDURE_CRITERIA, (Object)crit);
            accessNode.setProperty((Object)NodeConstants.Info.PROCEDURE_INPUTS, inputReferences);
            accessNode.setProperty((Object)NodeConstants.Info.PROCEDURE_DEFAULTS, defaults);
            accessNode.setProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET, (Object)Boolean.TRUE);
        }
        return plan;
    }

    private void findInputNodes(final HashSet inputs, PlanNode critNode, final List conjuncts, final Set params) {
        while (critNode.getType() == 13) {
            final PlanNode currentNode = critNode;
            final Criteria crit = (Criteria)currentNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            critNode = currentNode.getParent();
            if (FrameUtil.hasSubquery(currentNode) || !currentNode.getGroups().isEmpty()) continue;
            LanguageVisitor visitor = new LanguageVisitor(){

                public void visit(CompareCriteria compCrit) {
                    if (compCrit.getOperator() != 1) {
                        return;
                    }
                    if (this.checkForInput(compCrit.getLeftExpression()) && !this.checkForAnyInput((LanguageObject)compCrit.getRightExpression())) {
                        this.addInputNode((Reference)compCrit.getLeftExpression());
                    }
                }

                public void visit(NotCriteria obj) {
                    this.setAbort(true);
                }

                public void visit(CompoundCriteria obj) {
                    this.setAbort(true);
                }

                private void addInputNode(Reference param) {
                    params.add(param.getExpression());
                    conjuncts.add(crit);
                    NodeEditor.removeChildNode((PlanNode)currentNode.getParent(), (PlanNode)currentNode);
                    currentNode.setParent(null);
                    this.setAbort(true);
                }

                public void visit(IsNullCriteria isNull) {
                    if (isNull.isNegated()) {
                        return;
                    }
                    if (this.checkForInput(isNull.getExpression())) {
                        this.addInputNode((Reference)isNull.getExpression());
                    }
                }

                public void visit(SetCriteria obj) {
                    if (this.checkForInput(obj.getExpression()) && !this.checkForAnyInput(obj.getValues())) {
                        this.addInputNode((Reference)obj.getExpression());
                    }
                }

                public void visit(DependentSetCriteria obj) {
                    if (this.checkForInput(obj.getExpression())) {
                        this.addInputNode((Reference)obj.getExpression());
                    }
                }

                boolean checkForInput(Expression expr) {
                    if (!(expr instanceof Reference)) {
                        return false;
                    }
                    Reference ref = (Reference)expr;
                    return inputs.contains(ref.getExpression());
                }

                boolean checkForAnyInput(LanguageObject expr) {
                    Iterator refs = ReferenceCollectorVisitor.getReferences((LanguageObject)expr).iterator();
                    while (refs.hasNext()) {
                        if (!this.checkForInput((Expression)refs.next())) continue;
                        return true;
                    }
                    return false;
                }

                boolean checkForAnyInput(Collection expressions) {
                    Iterator exprs = expressions.iterator();
                    while (exprs.hasNext()) {
                        if (!this.checkForAnyInput((LanguageObject)((Expression)exprs.next()))) continue;
                        return true;
                    }
                    return false;
                }
            };
            PreOrderNavigator.doVisit((LanguageObject)crit, (LanguageVisitor)visitor);
        }
    }

    public String toString() {
        return "PlanProcedures";
    }
}

