/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.optimizer.relational.rules.RuleImplementJoinStrategy;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RuleImplementJoinStrategy
implements OptimizerRule {
    private static final boolean LEFT = false;
    private static final boolean RIGHT = true;

    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List joins = NodeEditor.findAllNodes((PlanNode)plan, (int)7, (int)3);
        boolean addProjects = false;
        Iterator i = joins.iterator();
        while (i.hasNext()) {
            PlanNode joinNode = (PlanNode)i.next();
            JoinStrategyType stype = (JoinStrategyType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
            if (!JoinStrategyType.MERGE.equals((Object)stype)) continue;
            addProjects |= RuleImplementJoinStrategy.buildInputsSingleSide(joinNode, false, metadata, capabilitiesFinder);
            addProjects |= RuleImplementJoinStrategy.buildInputsSingleSide(joinNode, true, metadata, capabilitiesFinder);
        }
        if (!addProjects) {
            rules.remove(RuleConstants.ADD_PROJECTS);
        }
        return plan;
    }

    private static boolean buildInputsSingleSide(PlanNode mergeJoinNode, boolean side, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        List expressions = null;
        PlanNode accessNode = null;
        if (!side) {
            expressions = (List)mergeJoinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS);
            accessNode = mergeJoinNode.getFirstChild();
        } else {
            expressions = (List)mergeJoinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS);
            accessNode = mergeJoinNode.getLastChild();
        }
        return RuleImplementJoinStrategy.insertSort(accessNode, expressions, mergeJoinNode, metadata, capFinder);
    }

    private static boolean insertSort(PlanNode childNode, List expressions, PlanNode jnode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList<Object> orderSymbols = new ArrayList<Object>(expressions.size());
        int exprID = 0;
        boolean hasExpression = false;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = (Expression)expressions.get(i);
            if (expr instanceof SingleElementSymbol) {
                orderSymbols.add(expr);
                continue;
            }
            hasExpression = true;
            ExpressionSymbol exprSymbol = new ExpressionSymbol("expr_" + exprID++, expr);
            orderSymbols.add(exprSymbol);
            expressions.set(i, exprSymbol);
        }
        PlanNode sortNode = NodeFactory.getNewNode((int)17);
        sortNode.setProperty((Object)NodeConstants.Info.SORT_ORDER, orderSymbols);
        ArrayList<Boolean> directions = new ArrayList<Boolean>(orderSymbols.size());
        for (int i = 0; i < orderSymbols.size(); ++i) {
            directions.add(OrderBy.ASC);
        }
        sortNode.setProperty((Object)NodeConstants.Info.ORDER_TYPES, directions);
        PlanNode sourceNode = FrameUtil.findJoinSourceNode(childNode);
        boolean isDependentSort = false;
        if (sourceNode.getType() == 3 && !hasExpression && RuleRaiseAccess.canRaiseOverSort((PlanNode)sourceNode, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (PlanNode)sortNode)) {
            NodeEditor.insertNode((PlanNode)sourceNode, (PlanNode)sourceNode.getFirstChild(), (PlanNode)sortNode);
            if (!sourceNode.hasBooleanProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET)) {
                return false;
            }
            sortNode = NodeFactory.getNewNode((int)17);
            sortNode.setProperty((Object)NodeConstants.Info.SORT_ORDER, orderSymbols);
            sortNode.setProperty((Object)NodeConstants.Info.ORDER_TYPES, directions);
            isDependentSort = true;
        }
        sortNode.setProperty((Object)NodeConstants.Info.NEEDS_PROJECT, (Object)Boolean.TRUE);
        if (isDependentSort) {
            DependentSortController controller = new DependentSortController();
            sortNode.setProperty((Object)NodeConstants.Info.SORT_CONTROLLER, (Object)controller);
            sourceNode.setProperty((Object)NodeConstants.Info.SORT_CONTROLLER, (Object)controller);
        }
        NodeEditor.insertNode((PlanNode)childNode.getParent(), (PlanNode)childNode, (PlanNode)sortNode);
        return true;
    }

    public String toString() {
        return "ImplementJoinStrategy";
    }
}

