/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ObjectID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.spec.AlgorithmParameterSpec;

public class ESDHKEKParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private ObjectID d;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CEK wrap algorithm: " + this.d.toString() + "\n");
        stringBuffer.append("counter: " + Util.toString(this.c) + "\n");
        if (this.b != null) {
            stringBuffer.append("partyAInfo: " + Util.toString(this.b, 0, 10) + "...\n");
        }
        stringBuffer.append("suppPubInfo: " + Util.toString(this.a) + "\n");
        return stringBuffer.toString();
    }

    private void a(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create ESDHKEKParameterSpec. Missing SuppPubInfo!");
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("SuppPubInfo must be 4 bytes long!");
        }
        this.a = byArray;
    }

    private void a(int n2) {
        byte[] byArray = new byte[4];
        CryptoUtils.spreadIntsToBytes(new int[]{n2}, 0, byArray, 0, 1);
        this.a(byArray);
    }

    public void setPartyAInfo(byte[] byArray) {
        if (byArray != null && byArray.length != 64) {
            throw new IllegalArgumentException("PartyAInfo must be 512 bits long!");
        }
        this.b = byArray;
    }

    public void setCounter(byte[] byArray) {
        if (byArray != null && byArray.length != 4) {
            throw new IllegalArgumentException("Counter must be 4 bytes long!");
        }
        this.c = byArray;
    }

    public void setCounter(int n2) {
        this.c = new byte[4];
        CryptoUtils.spreadIntsToBytes(new int[]{n2}, 0, this.c, 0, 1);
    }

    void a(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create ESDHKEKParameterSpec. Missing Cek wrap algorithm!");
        }
        this.d = objectID;
    }

    public void resetCounter() {
        if (this.c == null) {
            this.c = new byte[4];
        }
        this.c[0] = 0;
        this.c[1] = 0;
        this.c[2] = 0;
        this.c[3] = 1;
    }

    public void incrementCounter() {
        int n2 = this.c.length;
        while (n2 > 0) {
            int n3 = --n2;
            this.c[n3] = (byte)(this.c[n3] + 1);
            byte by = this.c[n3];
            if (by == 0) continue;
            return;
        }
    }

    public int getSuppPubInfoAsInt() {
        int[] nArray = new int[1];
        CryptoUtils.squashBytesToInts(this.a, 0, nArray, 0, 1);
        return nArray[0];
    }

    public byte[] getSuppPubInfo() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    public byte[] getPartyAInfo() {
        if (this.b == null) {
            return null;
        }
        return (byte[])this.b.clone();
    }

    public int getCounterAsInt() {
        int[] nArray = new int[1];
        CryptoUtils.squashBytesToInts(this.c, 0, nArray, 0, 1);
        return nArray[0];
    }

    public byte[] getCounter() {
        if (this.c == null) {
            return null;
        }
        return (byte[])this.c.clone();
    }

    public ObjectID getCekWrapAlgorithm() {
        return this.d;
    }

    public Object clone() {
        ESDHKEKParameterSpec eSDHKEKParameterSpec = new ESDHKEKParameterSpec();
        eSDHKEKParameterSpec.d = new ObjectID((String)this.d.getValue());
        eSDHKEKParameterSpec.c = this.getCounter();
        eSDHKEKParameterSpec.b = this.getPartyAInfo();
        eSDHKEKParameterSpec.a = this.getSuppPubInfo();
        return eSDHKEKParameterSpec;
    }

    public ESDHKEKParameterSpec(ObjectID objectID, byte[] byArray) {
        this.a(objectID);
        this.a(byArray);
        this.resetCounter();
    }

    public ESDHKEKParameterSpec(ObjectID objectID, int n2) {
        this.a(objectID);
        this.a(n2);
        this.resetCounter();
    }

    ESDHKEKParameterSpec() {
    }
}

