/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase.tds;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sybase.SybaseColumn;
import com.metamatrix.jdbc.sybase.SybaseMetaData;
import com.metamatrix.jdbc.sybase.tds.SybaseTDS;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCancelRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSParameter;
import com.metamatrix.util.UtilByteArray;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;

public abstract class SybaseTDSRequest
extends SybaseTDS {
    private static String footprint = "$Revision:   3.60.1.4  $";
    int messageType;
    public SybaseTDSCommunication comm;
    SQLException exception;
    BaseColumns columnDescriptions;
    UtilVectorUnsynced nativeColumns;
    private SybaseTDSParameter[] params;
    private int numActualParams;
    int numOutParams;
    boolean processParamFlag = false;
    private boolean lastRowReturned;
    int resultType;
    int numRowsAffected;
    int numRowsFetched;
    int lastColumnProcessedForCurrentRow;
    String database;
    int returnStatus;
    public static final short PROCESS_UNTIL_ROW_OR_UPDATECOUNT = 0;
    public static final short PROCESS_UNTIL_ROW = 1;
    public static final short PROCESS_UNTIL_END = 2;
    int processMode;
    UtilByteOrderedDataReader reader;
    UtilByteOrderedDataWriter writer;
    boolean inProcessPendingCancels;
    int[] returnValueType = new int[1];
    SybaseTDSParameter[] hiddenOutputParams;
    private boolean isStoredProcCall;
    private int longColumnsCount = -1;
    int readSocketTimeout = 0;
    public boolean autoGeneratedKeysRequestedForPreparedStmt = false;

    public SybaseTDSRequest(SybaseTDSCommunication sybaseTDSCommunication, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, int n) {
        this.messageType = n;
        this.comm = sybaseTDSCommunication;
        this.numRowsAffected = -1;
        this.numRowsFetched = 0;
        this.lastColumnProcessedForCurrentRow = 0;
        this.resultType = 0;
        this.params = null;
        this.processMode = 0;
        this.exception = null;
        this.reader = utilByteOrderedDataReader;
        this.writer = utilByteOrderedDataWriter;
        this.inProcessPendingCancels = false;
        this.columnDescriptions = null;
        this.lastRowReturned = false;
        this.numOutParams = 0;
        this.isStoredProcCall = false;
        this.readSocketTimeout = 0;
    }

    public boolean hasLongColumns() {
        if (this.longColumnsCount == -1) {
            this.longColumnsCount = 0;
            for (int i = 0; i < this.nativeColumns.size(); ++i) {
                SybaseColumn sybaseColumn = (SybaseColumn)this.nativeColumns.elementAt(i);
                if (!sybaseColumn.isLongColumn()) continue;
                ++this.longColumnsCount;
            }
        }
        return this.longColumnsCount > 0;
    }

    public void setIsStoredProcCall(boolean bl) {
        this.isStoredProcCall = bl;
    }

    public void setParams(SybaseTDSParameter[] sybaseTDSParameterArray, int n) {
        this.params = sybaseTDSParameterArray;
        this.numActualParams = n;
    }

    public void setProcessMode(int n) {
        this.processMode = n;
    }

    public int getNumRowsAffected() {
        return this.numRowsAffected;
    }

    public int getResultType() {
        return this.resultType;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public BaseColumns getColumnDescriptions() {
        return this.columnDescriptions;
    }

    public final SybaseColumn getNativeColumn(int n) {
        return (SybaseColumn)this.nativeColumns.elementAt(n - 1);
    }

    public Object getColumnData(int n, int n2) throws SQLException {
        this.getColumnDataForRow(n, n2);
        SybaseColumn sybaseColumn = (SybaseColumn)this.nativeColumns.get(n - 1);
        return sybaseColumn.data;
    }

    public boolean hasParameters() {
        return this.numActualParams != 0;
    }

    public void writeParamFormats() throws UtilException, SQLException {
        int n;
        if (this.numActualParams == 0) {
            return;
        }
        int n2 = 2;
        for (n = 0; n < this.numActualParams; ++n) {
            n2 += this.params[n].fmtLength;
        }
        if (this.comm.supportsWideTables) {
            this.writer.writeInt8(32);
            this.writer.writeInt32(n2);
        } else {
            this.writer.writeInt8(-20);
            this.writer.writeInt16(n2);
        }
        this.writer.writeInt16(this.numActualParams);
        for (n = 0; n < this.numActualParams; ++n) {
            this.params[n].writeFormat(this.writer, this.comm.supportsWideTables);
        }
    }

    public void writeParamData() throws UtilException, SQLException {
        if (this.numActualParams == 0) {
            return;
        }
        this.writer.writeInt8(-41);
        for (int i = 0; i < this.numActualParams; ++i) {
            this.params[i].writeData(this.writer);
        }
    }

    public SybaseTDSParameter getOutputParam(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numActualParams; ++i) {
            SybaseTDSParameter sybaseTDSParameter = this.params[i];
            if (!sybaseTDSParameter.isOutput || ++n2 != n) continue;
            return sybaseTDSParameter;
        }
        SybaseTDSParameter sybaseTDSParameter = this.hiddenOutputParams[n];
        if (sybaseTDSParameter == null) {
            this.hiddenOutputParams[n] = sybaseTDSParameter = new SybaseTDSParameter(this.comm.exceptions);
        }
        return sybaseTDSParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearReplyChannel() throws SQLException {
        try {
            block25: {
                if (this.comm.currentlyRegisteredReader != null && this.comm.currentlyRegisteredReader != this.reader) {
                    boolean bl = false;
                    this.readSocketTimeout = this.comm.connection.implConnection.getCancelPendingTimeout();
                    if (this.comm.enableCancelTimeout && this.readSocketTimeout > 0 && (this.comm.cancelInfo.getCancelCount() > 0 || this.comm.cancelInfo.cancelTimeoutExpired)) {
                        int n = 0;
                        Socket socket = null;
                        try {
                            socket = this.comm.getSocket();
                            n = socket.getSoTimeout();
                            socket.setSoTimeout(this.readSocketTimeout * 1000);
                            bl = this.comm.currentlyRegisteredReader.bufferAllData();
                            if (!bl) {
                                throw this.comm.exceptions.getException(6091);
                            }
                            break block25;
                        }
                        catch (Exception exception) {
                            if (exception instanceof UtilException) {
                                UtilException utilException = (UtilException)exception;
                                if (utilException.getReason() == 1029) {
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    throw this.comm.exceptions.getException(6106, "08S01");
                                }
                                throw utilException;
                            }
                            if (exception instanceof SQLException) {
                                throw (SQLException)exception;
                            }
                            break block25;
                        }
                        finally {
                            try {
                                if (socket != null) {
                                    socket.setSoTimeout(n);
                                }
                            }
                            catch (SocketException socketException) {}
                        }
                    }
                    try {
                        bl = this.comm.currentlyRegisteredReader.bufferAllData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) {
                        throw this.comm.exceptions.getException(6091);
                    }
                }
            }
            this.reader.empty();
            this.processPendingCancels(null);
            this.comm.currentlyRegisteredReader = this.reader;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public void submitRequest() throws SQLException {
        if (!(this instanceof SybaseTDSCancelRequest)) {
            this.comm.cancelInfo.setCancelCount(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReply(BaseWarnings baseWarnings) throws SQLException {
        block9: {
            boolean bl = true;
            try {
                while (bl) {
                    byte by = this.reader.readInt8();
                    bl = this.processReplyToken(by, baseWarnings);
                }
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1001) {
                    if (this.messageType == 2) {
                        throw this.comm.exceptions.getException(7016, "08001");
                    }
                    throw this.comm.exceptions.getException(utilException);
                }
                this.processPendingCancels(baseWarnings);
                this.resultType = 1;
                if (this.comm.currentlyRegisteredReader == this.reader) {
                    this.comm.currentlyRegisteredReader = null;
                }
            }
            finally {
                if (this.exception == null) break block9;
                throw this.exception;
            }
        }
    }

    public void processReply(short s, BaseWarnings baseWarnings) throws SQLException {
        this.processMode = s;
        this.processReply(baseWarnings);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processReplyToken(byte var1_1, BaseWarnings var2_2) throws SQLException {
        try {
            switch (var1_1) {
                case -25: {
                    var3_3 = this.reader.readUnsignedInt16();
                    var4_5 = this.reader.readUnsignedInt8();
                    if (var4_5 != 32) {
                        var5_7 = new String[]{this.getNameForTokenType(var1_1)};
                        throw this.comm.exceptions.getException(7009, var5_7);
                    }
                    var5_6 = 0;
                    while (true) {
                        if (var5_6 >= var3_3 - 1) {
                            return true;
                        }
                        this.reader.readUnsignedInt8();
                        ++var5_6;
                    }
                }
                case -3: 
                case -2: 
                case -1: {
                    var5_8 = this.reader.readUnsignedInt16();
                    var6_10 = this.reader.readUnsignedInt16();
                    var7_11 = this.reader.readInt32();
                    if ((var5_8 & 32) != 0) {
                        if (this.comm.cancelInfo.getCancelCount() > 0) {
                            this.exception = this.comm.exceptions.getException(this.exception, 1, 6078, "HY008");
                            this.comm.cancelInfo.decrementCancelCount();
                            return true;
                        }
                        this.reader.receive();
                        return true;
                    }
                    if (this.processMode == 1 || this.processMode == 2) {
                        return true;
                    }
                    if ((var5_8 & 16) == 0) ** GOTO lbl46
                    if (var1_1 == -3 || var6_10 == 2) {
                        this.numRowsAffected = var7_11;
                        this.resultType = 3;
                        return false;
                    }
                    try {
                        var8_12 = this.reader.readInt8();
                        this.reader.pushByte(var8_12);
                        if (var8_12 == -2 || var8_12 == 121 || var8_12 == 97 && this.autoGeneratedKeysRequestedForPreparedStmt) {
                            this.numRowsAffected = var7_11;
                            this.resultType = 3;
                            return false;
                        }
                        return true;
                    }
                    catch (UtilException var8_13) {
                        if (var8_13.getReason() == 1001) ** GOTO lbl46
                        throw this.comm.exceptions.getException(var8_13);
                    }
lbl46:
                    // 2 sources

                    if (var5_8 == 0 && this.numRowsAffected == -1) {
                        this.numRowsAffected = var7_11;
                        this.resultType = 3;
                        return false;
                    }
                    return true;
                }
                case -18: 
                case 97: {
                    this.processRowFormat(var1_1);
                    return this.processMode == 2;
                }
                case -29: {
                    this.processEnvChange(var2_2);
                    return true;
                }
                case -86: 
                case -85: 
                case -27: {
                    this.processErrorToken(var1_1, var2_2);
                    return true;
                }
                case 121: {
                    this.returnStatus = this.reader.readInt32();
                    return true;
                }
                case -20: 
                case 32: {
                    this.processParamFormat(var1_1);
                    return true;
                }
                case -84: {
                    this.processReturnValue();
                    return true;
                }
                case -41: {
                    this.processParams();
                    return true;
                }
                case -92: {
                    this.processTabName();
                    return true;
                }
                case -91: {
                    this.processColInfo();
                    return true;
                }
                case -82: {
                    this.processControl();
                    return true;
                }
                case -87: 
                case 34: {
                    this.processOrderBy(var1_1);
                    return true;
                }
                case -125: {
                    this.reader.readInt16();
                    if (this.reader.readInt32() == 0) {
                        this.reader.readString(this.reader.readInt8());
                    }
                    this.reader.readInt8();
                    if ((this.reader.readInt16() & 32) != 0) {
                        this.reader.readInt32();
                    }
                    return true;
                }
            }
            var5_9 = new String[]{this.getNameForTokenType(var1_1)};
            throw this.comm.exceptions.getException(7009, var5_9);
        }
        catch (UtilException var3_4) {
            throw this.comm.exceptions.getException(var3_4);
        }
    }

    public void discardNextToken() throws SQLException {
        try {
            byte by = this.reader.readInt8();
            int n = by == -3 || by == -2 || by == -1 ? 8 : (int)this.reader.readInt16();
            this.reader.readAndDiscardBytes(n);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    void processErrorToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            int n = this.reader.readUnsignedInt16();
            int n2 = this.reader.readInt32();
            short s = this.reader.readUnsignedInt8();
            short s2 = this.reader.readUnsignedInt8();
            String string = this.reader.readString(this.reader.readUnsignedInt8());
            short s3 = this.reader.readUnsignedInt8();
            int n3 = this.reader.readUnsignedInt16();
            String string2 = this.reader.readString(this.reader.readInt16());
            String string3 = this.reader.readString(this.reader.readUnsignedInt8());
            String string4 = this.reader.readString(this.reader.readUnsignedInt8());
            int n4 = this.reader.readUnsignedInt16();
            boolean bl = s2 <= 10;
            boolean bl2 = false;
            switch (n2) {
                case 5701: 
                case 5703: 
                case 5704: {
                    bl2 = true;
                    break;
                }
                case 1805: 
                case 2403: 
                case 2409: 
                case 2411: 
                case 4023: {
                    string = "01000";
                    bl = true;
                    break;
                }
                case 102: 
                case 156: {
                    string = "42000";
                    break;
                }
                case 207: {
                    string = "42S22";
                    break;
                }
                case 208: {
                    string = "42S02";
                    break;
                }
                case 213: {
                    string = "21S01";
                    break;
                }
                case 233: {
                    string = "23000";
                    break;
                }
                case 247: {
                    string = "22003";
                    break;
                }
                case 257: {
                    string = "22018";
                    break;
                }
                case 546: {
                    string = "23000";
                    break;
                }
                case 1205: {
                    string = "40001";
                    break;
                }
                case 1906: {
                    string = "42S02";
                    break;
                }
                case 1913: {
                    string = "42S11";
                    break;
                }
                case 2601: {
                    string = "23000";
                    break;
                }
                case 2705: 
                case 11049: {
                    string = "42S21";
                    break;
                }
                case 2714: {
                    string = "42S01";
                    break;
                }
                case 2760: {
                    string = "42S22";
                    break;
                }
                case 2812: {
                    string = "42000";
                    break;
                }
                case 3606: {
                    string = "22003";
                    bl = false;
                    break;
                }
                case 3607: {
                    string = "22012";
                    bl = false;
                    break;
                }
                case 3621: {
                    string = "HY000";
                    bl = false;
                    break;
                }
                case 3624: {
                    string = "01004";
                    bl = false;
                    break;
                }
                case 3701: 
                case 4902: {
                    string = "42S02";
                    break;
                }
                case 4002: {
                    string = "08001";
                    break;
                }
                case 4501: 
                case 4502: {
                    string = "21S02";
                    break;
                }
                case 4604: {
                    string = "42000";
                    break;
                }
                case 4901: {
                    string = "42S21";
                }
            }
            if (n2 == 557) {
                throw this.comm.exceptions.getException(7023);
            }
            if (!bl2) {
                String[] stringArray = new String[]{string2};
                if (!bl && this.isStoredProcCall && n2 != 1105) {
                    String string5 = this.comm.connection.getConnectProperties().get("errorBehavior");
                    try {
                        byte by2 = this.reader.readInt8();
                        if (by2 == -1) {
                            this.reader.readUnsignedInt16();
                            this.reader.readUnsignedInt16();
                            this.reader.readInt32();
                            if (string5.equalsIgnoreCase("Warning")) {
                                bl = true;
                                string = "01000";
                            }
                            if (string5.equalsIgnoreCase("Exception")) {
                                bl = false;
                                string = "HY000";
                            }
                            if (string5.equalsIgnoreCase("RaiseErrorWarning")) {
                                if (n2 >= 17000) {
                                    bl = true;
                                    string = "01000";
                                } else {
                                    bl = false;
                                    string = "HY000";
                                }
                            }
                        }
                    }
                    catch (UtilException utilException) {
                        // empty catch block
                    }
                }
                if (bl && baseWarnings != null) {
                    if (string.equals("ZZZZZ")) {
                        string = "01000";
                    }
                    baseWarnings.add(6001, stringArray, string, n2);
                } else {
                    if (string.equals("ZZZZZ")) {
                        string = "HY000";
                    }
                    this.exception = this.comm.exceptions.getException(null, 1, 6001, stringArray, string, n2);
                    this.discardReplyBytes();
                    throw this.exception;
                }
            }
            if ((s3 & 1) != 0) {
                this.discardNextToken();
                this.discardNextToken();
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    void processEnvChange(BaseWarnings baseWarnings) throws UtilException {
        int n = this.reader.readUnsignedInt16() - 1;
        byte by = this.reader.readInt8();
        String string = new String();
        switch (by) {
            case 1: {
                string = string + "Database changed";
                break;
            }
            case 2: {
                string = string + "Language changed";
                break;
            }
            case 3: {
                string = string + "Character set changed";
                break;
            }
            case 4: {
                string = string + "Packet size changed";
                break;
            }
            default: {
                UtilDebug.assert("Unexpected ENVCHANGE type", false);
            }
        }
        byte by2 = this.reader.readInt8();
        String string2 = this.reader.readString(by2);
        string = string + " to " + string2;
        by2 = this.reader.readInt8();
        String string3 = this.reader.readString(by2);
        if (by == 1) {
            String[] stringArray = new String[]{string};
            baseWarnings.add(6001, stringArray);
            this.database = string2;
        } else if (by == 2) {
            String[] stringArray = new String[]{string};
            baseWarnings.add(6001, stringArray);
        } else if (by == 4) {
            this.comm.packetizer.setPacketSize(Integer.valueOf(string2), this.comm.bufferPackets);
        }
    }

    protected SybaseMetaData readMetaData(byte by) throws UtilException, SQLException {
        short s;
        SybaseMetaData sybaseMetaData = new SybaseMetaData();
        switch (by) {
            case -84: 
            case -20: {
                this.reader.readString(this.reader.readInt8());
                sybaseMetaData.statusFlags = this.reader.readUnsignedInt8();
                break;
            }
            case -18: {
                sybaseMetaData.statusFlags = this.reader.readUnsignedInt8();
                break;
            }
            case 32: {
                this.reader.readString(this.reader.readInt8());
                sybaseMetaData.statusFlags = this.reader.readUnsignedInt32();
                break;
            }
            case 97: {
                sybaseMetaData.statusFlags = this.reader.readUnsignedInt32();
                break;
            }
            default: {
                String[] stringArray = new String[]{this.getNameForTokenType(by)};
                throw this.comm.exceptions.getException(7002, stringArray);
            }
        }
        sybaseMetaData.userType = this.reader.readInt32();
        sybaseMetaData.nativeType = this.reader.readInt8();
        switch (sybaseMetaData.nativeType) {
            case 50: {
                sybaseMetaData.displaySize = 1;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = -7;
                sybaseMetaData.typeName = "bit";
                break;
            }
            case 47: {
                short s2 = this.reader.readUnsignedInt8();
                sybaseMetaData.displaySize = s2;
                sybaseMetaData.precision = s2;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.isCaseSensitive = true;
                sybaseMetaData.sqlType = 1;
                sybaseMetaData.typeName = "char";
                break;
            }
            case 39: {
                short s3 = this.reader.readUnsignedInt8();
                sybaseMetaData.displaySize = s3;
                sybaseMetaData.precision = s3;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.isCaseSensitive = true;
                if (sybaseMetaData.userType == 1) {
                    sybaseMetaData.nativeType = (byte)47;
                    sybaseMetaData.sqlType = 1;
                    sybaseMetaData.typeName = "char";
                    break;
                }
                sybaseMetaData.sqlType = 12;
                sybaseMetaData.typeName = "varchar";
                break;
            }
            case -81: {
                sybaseMetaData.precision = sybaseMetaData.displaySize = this.reader.readInt32();
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.isCaseSensitive = true;
                if (sybaseMetaData.userType == 1) {
                    sybaseMetaData.sqlType = 1;
                    sybaseMetaData.typeName = "char";
                    break;
                }
                if (sybaseMetaData.userType == 25) {
                    sybaseMetaData.sqlType = 12;
                    sybaseMetaData.typeName = "nvarchar";
                    break;
                }
                sybaseMetaData.sqlType = -1;
                sybaseMetaData.typeName = "text";
                break;
            }
            case 45: {
                sybaseMetaData.precision = this.reader.readUnsignedInt8();
                sybaseMetaData.displaySize = sybaseMetaData.precision * 2;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = -2;
                sybaseMetaData.typeName = "binary";
                break;
            }
            case 37: {
                sybaseMetaData.precision = this.reader.readUnsignedInt8();
                sybaseMetaData.displaySize = sybaseMetaData.precision * 2;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                if (sybaseMetaData.userType == 3) {
                    sybaseMetaData.nativeType = (byte)45;
                    sybaseMetaData.sqlType = -2;
                    sybaseMetaData.typeName = "binary";
                    break;
                }
                sybaseMetaData.sqlType = -3;
                sybaseMetaData.typeName = "varbinary";
                break;
            }
            case -31: {
                sybaseMetaData.precision = this.reader.readInt32();
                sybaseMetaData.displaySize = sybaseMetaData.precision * 2;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                if (sybaseMetaData.userType == 34) {
                    sybaseMetaData.precision /= 2;
                    sybaseMetaData.displaySize /= 2;
                    sybaseMetaData.nativeType = (byte)-81;
                    sybaseMetaData.sqlType = 1;
                    sybaseMetaData.typeName = "unichar";
                    break;
                }
                if (sybaseMetaData.userType == 35) {
                    sybaseMetaData.precision /= 2;
                    sybaseMetaData.displaySize /= 2;
                    sybaseMetaData.nativeType = (byte)-81;
                    sybaseMetaData.sqlType = 12;
                    sybaseMetaData.typeName = "univarchar";
                    break;
                }
                if (sybaseMetaData.userType == 4) {
                    sybaseMetaData.sqlType = -3;
                    sybaseMetaData.typeName = "varbinary";
                    break;
                }
                if (sybaseMetaData.userType == 3) {
                    sybaseMetaData.sqlType = -2;
                    sybaseMetaData.typeName = "binary";
                    break;
                }
                sybaseMetaData.sqlType = -4;
                sybaseMetaData.typeName = "image";
                break;
            }
            case 106: {
                short s4 = this.reader.readUnsignedInt8();
                sybaseMetaData.precision = this.reader.readUnsignedInt8();
                sybaseMetaData.scale = this.reader.readUnsignedInt8();
                sybaseMetaData.displaySize = sybaseMetaData.precision;
                ++sybaseMetaData.displaySize;
                if (sybaseMetaData.scale > 0) {
                    ++sybaseMetaData.displaySize;
                }
                if (sybaseMetaData.precision == sybaseMetaData.scale) {
                    ++sybaseMetaData.displaySize;
                }
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 3;
                sybaseMetaData.typeName = "decimal";
                break;
            }
            case -73: 
            case 65: {
                sybaseMetaData.precision = 10;
                sybaseMetaData.scale = 0;
                sybaseMetaData.displaySize = 10;
                sybaseMetaData.sqlType = 4;
                sybaseMetaData.typeName = "unsigned smallint";
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                break;
            }
            case -69: 
            case 66: {
                sybaseMetaData.precision = 19;
                sybaseMetaData.scale = 0;
                sybaseMetaData.displaySize = 19;
                sybaseMetaData.sqlType = -5;
                sybaseMetaData.typeName = "unsigned int";
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                break;
            }
            case -66: 
            case 67: {
                sybaseMetaData.precision = 20;
                sybaseMetaData.scale = 0;
                sybaseMetaData.displaySize = 20;
                sybaseMetaData.sqlType = 3;
                sybaseMetaData.typeName = "unsigned bigint";
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                break;
            }
            case 43: 
            case 68: {
                short s5 = this.reader.readUnsignedInt8();
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.scale = 0;
                if (s5 == 2) {
                    sybaseMetaData.precision = 10;
                    sybaseMetaData.displaySize = 10;
                    sybaseMetaData.typeName = "unsigned smallint";
                    sybaseMetaData.sqlType = 4;
                    break;
                }
                if (s5 == 4) {
                    sybaseMetaData.precision = 19;
                    sybaseMetaData.displaySize = 19;
                    sybaseMetaData.sqlType = -5;
                    sybaseMetaData.typeName = "unsigned int";
                    break;
                }
                if (s5 == 8) {
                    sybaseMetaData.precision = 20;
                    sybaseMetaData.displaySize = 20;
                    sybaseMetaData.sqlType = 3;
                    sybaseMetaData.typeName = "unsigned bigint";
                    break;
                }
                UtilDebug.assert("Unexpected integer length returned", false);
                break;
            }
            case 108: {
                short s6 = this.reader.readUnsignedInt8();
                sybaseMetaData.precision = this.reader.readUnsignedInt8();
                sybaseMetaData.scale = this.reader.readUnsignedInt8();
                if (sybaseMetaData.userType == 45) {
                    sybaseMetaData.sqlType = -5;
                    sybaseMetaData.typeName = "unsigned int";
                    sybaseMetaData.isSigned = false;
                } else if (sybaseMetaData.userType == 46) {
                    sybaseMetaData.sqlType = 3;
                    sybaseMetaData.typeName = "unsigned bigint";
                    sybaseMetaData.isSigned = false;
                } else if (sybaseMetaData.userType == 43) {
                    sybaseMetaData.sqlType = -5;
                    sybaseMetaData.typeName = "bigint";
                    sybaseMetaData.isSigned = true;
                } else {
                    sybaseMetaData.sqlType = 2;
                    sybaseMetaData.typeName = "numeric";
                    sybaseMetaData.isSigned = true;
                }
                sybaseMetaData.displaySize = 1 + sybaseMetaData.precision + (sybaseMetaData.scale > 0 ? 1 : 0);
                sybaseMetaData.isSearchable = 4;
                break;
            }
            case 38: {
                short s7 = this.reader.readUnsignedInt8();
                sybaseMetaData.isSearchable = 4;
                if (s7 == 1) {
                    sybaseMetaData.isSigned = false;
                    sybaseMetaData.typeName = "tinyint";
                    sybaseMetaData.sqlType = -6;
                    break;
                }
                if (s7 == 2) {
                    sybaseMetaData.isSigned = true;
                    sybaseMetaData.typeName = "smallint";
                    sybaseMetaData.sqlType = 5;
                    break;
                }
                if (s7 == 4) {
                    sybaseMetaData.sqlType = 4;
                    if (sybaseMetaData.userType == 44) {
                        sybaseMetaData.typeName = "unsigned smallint";
                        sybaseMetaData.isSigned = false;
                        break;
                    }
                    sybaseMetaData.typeName = "int";
                    sybaseMetaData.isSigned = true;
                    break;
                }
                if (s7 == 8) {
                    if (sybaseMetaData.userType == 46) {
                        sybaseMetaData.precision = 20;
                        sybaseMetaData.scale = 0;
                        sybaseMetaData.displaySize = 20;
                        sybaseMetaData.sqlType = 3;
                        sybaseMetaData.typeName = "unsigned bigint";
                        sybaseMetaData.isSigned = false;
                        break;
                    }
                    sybaseMetaData.precision = 19;
                    sybaseMetaData.scale = 0;
                    sybaseMetaData.displaySize = 20;
                    sybaseMetaData.sqlType = -5;
                    sybaseMetaData.typeName = "bigint";
                    sybaseMetaData.isSigned = true;
                    break;
                }
                UtilDebug.assert("Unexpected integer length returned", false);
                break;
            }
            case 48: {
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = -6;
                sybaseMetaData.typeName = "tinyint";
                break;
            }
            case 52: {
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 5;
                sybaseMetaData.typeName = "smallint";
                break;
            }
            case 56: {
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 4;
                sybaseMetaData.typeName = "int";
                break;
            }
            case -65: 
            case 57: {
                sybaseMetaData.precision = 19;
                sybaseMetaData.scale = 0;
                sybaseMetaData.displaySize = 20;
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = -5;
                sybaseMetaData.typeName = "bigint";
                break;
            }
            case 109: {
                short s8 = this.reader.readUnsignedInt8();
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                if (s8 == 4) {
                    sybaseMetaData.sqlType = 7;
                    sybaseMetaData.typeName = "real";
                    break;
                }
                if (s8 != 8) break;
                sybaseMetaData.sqlType = 6;
                sybaseMetaData.typeName = "float";
                break;
            }
            case 59: {
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 7;
                sybaseMetaData.typeName = "real";
                break;
            }
            case 62: {
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 6;
                sybaseMetaData.typeName = "float";
                break;
            }
            case 111: {
                short s9 = this.reader.readUnsignedInt8();
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 93;
                if (s9 == 4) {
                    sybaseMetaData.precision = 19;
                    sybaseMetaData.scale = 0;
                    sybaseMetaData.displaySize = 19;
                    sybaseMetaData.typeName = "smalldatetime";
                    break;
                }
                if (s9 != 8) break;
                sybaseMetaData.precision = 23;
                sybaseMetaData.scale = 3;
                sybaseMetaData.displaySize = 23;
                sybaseMetaData.typeName = "datetime";
                break;
            }
            case 61: {
                sybaseMetaData.displaySize = 23;
                sybaseMetaData.precision = 23;
                sybaseMetaData.scale = 3;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 93;
                sybaseMetaData.typeName = "datetime";
                break;
            }
            case -109: {
                short s10 = this.reader.readUnsignedInt8();
            }
            case 51: {
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 92;
                sybaseMetaData.precision = 12;
                sybaseMetaData.scale = 3;
                sybaseMetaData.displaySize = 12;
                sybaseMetaData.typeName = "time";
                break;
            }
            case 123: {
                short s11 = this.reader.readUnsignedInt8();
            }
            case 49: {
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 91;
                sybaseMetaData.precision = 10;
                sybaseMetaData.scale = 0;
                sybaseMetaData.displaySize = 10;
                sybaseMetaData.typeName = "date";
                break;
            }
            case 58: {
                sybaseMetaData.displaySize = 19;
                sybaseMetaData.precision = 19;
                sybaseMetaData.scale = 0;
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 93;
                sybaseMetaData.typeName = "smalldatetime";
                break;
            }
            case 60: {
                sybaseMetaData.displaySize = 21;
                sybaseMetaData.precision = 19;
                sybaseMetaData.scale = 4;
                sybaseMetaData.isCurrency = true;
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 3;
                sybaseMetaData.typeName = "money";
                break;
            }
            case 122: {
                sybaseMetaData.displaySize = 12;
                sybaseMetaData.precision = 10;
                sybaseMetaData.scale = 4;
                sybaseMetaData.isCurrency = true;
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 3;
                sybaseMetaData.typeName = "smallmoney";
                break;
            }
            case 110: {
                short s12 = this.reader.readUnsignedInt8();
                sybaseMetaData.scale = 4;
                sybaseMetaData.isCurrency = true;
                sybaseMetaData.isSigned = true;
                sybaseMetaData.isSearchable = 4;
                sybaseMetaData.sqlType = 3;
                if (s12 == 4) {
                    sybaseMetaData.displaySize = 12;
                    sybaseMetaData.precision = 10;
                    sybaseMetaData.typeName = "smallmoney";
                    break;
                }
                sybaseMetaData.displaySize = 21;
                sybaseMetaData.precision = 19;
                sybaseMetaData.typeName = "money";
                break;
            }
            case -82: 
            case 34: 
            case 35: {
                this.reader.readUnsignedInt32();
                sybaseMetaData.precision = Integer.MAX_VALUE;
                sybaseMetaData.displaySize = Integer.MAX_VALUE;
                sybaseMetaData.tableNameForLongType = this.reader.readString(this.reader.readUnsignedInt16());
                sybaseMetaData.isSigned = false;
                sybaseMetaData.isSearchable = 2;
                if (sybaseMetaData.nativeType == 34) {
                    sybaseMetaData.sqlType = -4;
                    sybaseMetaData.isCaseSensitive = false;
                    sybaseMetaData.typeName = "image";
                    break;
                }
                if (sybaseMetaData.nativeType == -82) {
                    sybaseMetaData.sqlType = -1;
                    sybaseMetaData.isCaseSensitive = true;
                    sybaseMetaData.typeName = "unitext";
                    break;
                }
                sybaseMetaData.sqlType = -1;
                sybaseMetaData.isCaseSensitive = true;
                sybaseMetaData.typeName = "text";
                break;
            }
            default: {
                String[] stringArray = new String[]{"0x" + UtilDataConversions.byteToHex(sybaseMetaData.nativeType)};
                throw this.comm.exceptions.getException(7013, stringArray);
            }
        }
        if (by != -84 && (s = this.reader.readUnsignedInt8()) > 0) {
            String string = this.reader.readString(s);
            this.exception = this.comm.exceptions.getException(7012, string);
        }
        return sybaseMetaData;
    }

    void processRowFormat(byte by) throws UtilException, SQLException {
        int n;
        if (by == -18) {
            this.reader.readUnsignedInt16();
        } else {
            this.reader.readUnsignedInt32();
        }
        int n2 = this.reader.readUnsignedInt16();
        if (n2 == 0) {
            return;
        }
        this.columnDescriptions = new BaseColumns();
        this.nativeColumns = new UtilVectorUnsynced();
        int n3 = -1;
        for (n = 1; n <= n2; ++n) {
            BaseColumn baseColumn = new BaseColumn();
            SybaseColumn sybaseColumn = new SybaseColumn(this.comm.connection);
            if (by == -18) {
                this.reader.setTransliterator(this.comm.transliteratorForCharData);
                baseColumn.label = baseColumn.name = this.reader.readString(this.reader.readUnsignedInt8());
                this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
            } else {
                this.reader.setTransliterator(this.comm.transliteratorForCharData);
                baseColumn.label = this.reader.readString(this.reader.readUnsignedInt8());
                baseColumn.catalogName = this.reader.readString(this.reader.readUnsignedInt8());
                baseColumn.schemaName = this.reader.readString(this.reader.readUnsignedInt8());
                baseColumn.tableName = this.reader.readString(this.reader.readUnsignedInt8());
                baseColumn.name = this.reader.readString(this.reader.readUnsignedInt8());
                this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
            }
            SybaseMetaData sybaseMetaData = this.readMetaData(by);
            baseColumn.isCaseSensitive = sybaseMetaData.isCaseSensitive;
            baseColumn.isCurrency = sybaseMetaData.isCurrency;
            baseColumn.isSigned = sybaseMetaData.isSigned;
            baseColumn.isSearchable = sybaseMetaData.isSearchable;
            baseColumn.isCaseSensitive = sybaseMetaData.isCaseSensitive;
            baseColumn.isCurrency = sybaseMetaData.isCurrency;
            baseColumn.typeName = sybaseMetaData.typeName;
            baseColumn.setType(sybaseMetaData.sqlType);
            if (BaseData.isVariableLengthType(sybaseMetaData.sqlType) || sybaseMetaData.sqlType == 93 || sybaseMetaData.sqlType == 92) {
                baseColumn.displaySize = sybaseMetaData.displaySize;
                baseColumn.precision = sybaseMetaData.precision;
                baseColumn.scale = sybaseMetaData.scale;
            }
            if (sybaseMetaData.tableNameForLongType != null && sybaseMetaData.tableNameForLongType.length() > 0) {
                baseColumn.tableName = sybaseMetaData.tableNameForLongType;
            }
            sybaseColumn.metaData = sybaseMetaData;
            baseColumn.isNullable = (sybaseMetaData.statusFlags & 0x20L) == 0L ? 0 : 1;
            if ((sybaseMetaData.statusFlags & 0x40L) == 64L) {
                baseColumn.isAutoIncrement = true;
                baseColumn.isKey = true;
                n3 = n;
                int n4 = baseColumn.name.indexOf(0);
                if (n4 != -1) {
                    baseColumn.name = baseColumn.name.substring(0, n4);
                }
            } else if ((sybaseMetaData.statusFlags & 2L) == 2L) {
                baseColumn.isAutoIncrement = false;
                baseColumn.isKey = true;
            } else {
                baseColumn.isAutoIncrement = false;
                baseColumn.isKey = false;
            }
            baseColumn.isHidden = (sybaseMetaData.statusFlags & 1L) != 0L;
            if (baseColumn.label == null || baseColumn.label.length() == 0) {
                baseColumn.label = baseColumn.name;
            }
            baseColumn.isReadOnly = false;
            baseColumn.isWritable = true;
            baseColumn.isDefinitelyWritable = false;
            this.columnDescriptions.add(baseColumn);
            this.nativeColumns.addElement(sybaseColumn);
        }
        this.resultType = 2;
        this.numRowsFetched = 0;
        if (n3 > 0) {
            for (n = 1; n <= n2; ++n) {
                if (n == n3) continue;
                this.columnDescriptions.get((int)n).isKey = false;
            }
        }
    }

    void processTabName() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        this.reader.readAndDiscardBytes(n);
    }

    void processColInfo() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        this.reader.readAndDiscardBytes(n);
    }

    void processControl() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        this.reader.readAndDiscardBytes(n);
    }

    void processOrderBy(byte by) throws UtilException, SQLException {
        int n = by == -87 ? this.reader.readInt16() : this.reader.readInt32();
        this.reader.readAndDiscardBytes(n);
    }

    public boolean getRow(BaseWarnings baseWarnings) throws SQLException {
        try {
            if (this.numRowsFetched > 0) {
                this.getColumnDataForRow(0, 0);
            }
            byte by = this.reader.readInt8();
            boolean bl = true;
            block14: while (bl) {
                switch (by) {
                    case -92: {
                        this.processTabName();
                        by = this.reader.readInt8();
                        continue block14;
                    }
                    case -91: {
                        this.processColInfo();
                        by = this.reader.readInt8();
                        continue block14;
                    }
                    case -82: {
                        this.processControl();
                        by = this.reader.readInt8();
                        continue block14;
                    }
                    case -87: 
                    case 34: {
                        this.processOrderBy(by);
                        by = this.reader.readInt8();
                        continue block14;
                    }
                    case -3: 
                    case -1: {
                        int n = this.reader.readUnsignedInt16();
                        this.reader.readUnsignedInt16();
                        this.numRowsAffected = this.reader.readInt32();
                        if ((n & 0x20) != 0 && this.comm.cancelInfo.getCancelCount() > 0) {
                            this.exception = this.comm.exceptions.getException(this.exception, 1, 6078, "HY008");
                            this.comm.cancelInfo.decrementCancelCount();
                            throw this.exception;
                        }
                        try {
                            byte by2 = this.reader.readInt8();
                            this.reader.pushByte(by2);
                        }
                        catch (UtilException utilException) {
                            this.processReply(baseWarnings);
                        }
                        bl = false;
                        continue block14;
                    }
                    case -89: {
                        throw this.comm.exceptions.getException(7017);
                    }
                    case -27: {
                        this.processErrorToken(by, baseWarnings);
                        bl = false;
                        continue block14;
                    }
                    case -47: {
                        this.lastColumnProcessedForCurrentRow = 0;
                        ++this.numRowsFetched;
                        this.lastRowReturned = false;
                        return true;
                    }
                }
                String[] stringArray = new String[]{this.getNameForTokenType(by)};
                throw this.comm.exceptions.getException(7002, stringArray);
            }
            this.lastRowReturned = true;
            return false;
        }
        catch (UtilException utilException) {
            this.lastRowReturned = true;
            return false;
        }
    }

    public void getColumnDataForRow(int n, int n2) throws SQLException {
        if (0 < n && n <= this.lastColumnProcessedForCurrentRow) {
            return;
        }
        int n3 = this.nativeColumns.size();
        int n4 = n == 0 ? n3 : n;
        for (int i = this.lastColumnProcessedForCurrentRow + 1; i <= n4; ++i) {
            SybaseColumn sybaseColumn = (SybaseColumn)this.nativeColumns.elementAt(i - 1);
            BaseColumn baseColumn = this.columnDescriptions.get(i);
            SybaseMetaData sybaseMetaData = sybaseColumn.metaData;
            if (sybaseColumn.isLongColumn()) {
                if (sybaseColumn.resetLongDataAtNextFetch) {
                    sybaseColumn.longData = null;
                }
                sybaseColumn.resetLongDataAtNextFetch = false;
                try {
                    short s = this.reader.readUnsignedInt8();
                    if (s == 0) {
                        sybaseColumn.data = null;
                    }
                    this.reader.readAndDiscardBytes(s + 8);
                    int n5 = this.reader.readInt32();
                    if (n5 == -1 || n5 == 0) {
                        sybaseColumn.data = null;
                    }
                    int n6 = n == 0 ? -1 : (this.comm.maxMemoryPerLongDataCache > 0 ? this.comm.maxMemoryPerLongDataCache : (i != n ? -1 : (n2 == 19 || n2 == 20 ? 2048 : 0)));
                    if (n6 == -1) {
                        sybaseColumn.data = null;
                        this.reader.readAndDiscardBytes(n5);
                    }
                    if (n6 > 0) {
                        UtilPagedTempBuffer utilPagedTempBuffer = sybaseColumn.getLongDataContainer(n6);
                        utilPagedTempBuffer.truncate();
                        if (sybaseColumn.metaData.nativeType == 35 || sybaseColumn.metaData.nativeType == -82) {
                            boolean bl = false;
                            Object var14_16 = null;
                            long l = 0L;
                            int n7 = 0;
                            byte[] byArray = new byte[8192];
                            UtilTransliterator utilTransliterator = sybaseColumn.metaData.nativeType == 35 ? this.comm.transliteratorForCharData : this.comm.ucs2Transliterator;
                            InputStream inputStream = utilTransliterator.decodeAsUCS2ByteStream(this.reader.getInputStream(n5), n5);
                            while (n7 != -1) {
                                try {
                                    n7 = inputStream.read(byArray, 0, 8192);
                                    if (n7 == -1 || bl) continue;
                                    l += (long)utilPagedTempBuffer.write(l, byArray, 0, n7);
                                }
                                catch (Exception exception) {
                                    bl = true;
                                    try {
                                        inputStream.skip(n5);
                                    }
                                    catch (Exception exception2) {
                                        // empty catch block
                                    }
                                    throw this.comm.exceptions.getException(exception);
                                }
                            }
                            if (var14_16 != null) {
                                throw var14_16;
                            }
                        } else {
                            utilPagedTempBuffer.write(0L, this.reader.getDataProvider(), n5);
                        }
                        sybaseColumn.data = utilPagedTempBuffer;
                        sybaseColumn.baseDataType = -1;
                    }
                    switch (sybaseColumn.metaData.nativeType) {
                        case -82: 
                        case 35: {
                            if (sybaseColumn.metaData.nativeType == 35) {
                                this.reader.setTransliterator(this.comm.transliteratorForCharData);
                            } else {
                                this.reader.setTransliterator(this.comm.ucs2Transliterator);
                            }
                            if (n2 == 15) {
                                sybaseColumn.data = this.reader.getAsciiStream(n5);
                                sybaseColumn.baseDataType = 15;
                            } else {
                                sybaseColumn.data = this.reader.getReader(n5);
                                sybaseColumn.baseDataType = 18;
                            }
                            this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
                            break;
                        }
                        case 34: {
                            sybaseColumn.data = this.reader.getInputStream(n5);
                            sybaseColumn.baseDataType = 14;
                        }
                    }
                }
                catch (UtilException utilException) {
                    throw this.comm.exceptions.getException(utilException);
                }
            } else {
                this.returnValueType[0] = -1;
                Object object = this.getReturnedValue(this.returnValueType, sybaseMetaData.nativeType, sybaseMetaData.userType, baseColumn.precision, baseColumn.scale);
                sybaseColumn.setData(object, this.returnValueType[0]);
            }
            ++this.lastColumnProcessedForCurrentRow;
        }
    }

    String addBlanks(String string, int n) {
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            while (n > 0) {
                stringBuffer.append(' ');
                --n;
            }
            return string.concat(stringBuffer.toString());
        }
        return string;
    }

    Object getReturnedValue(int[] nArray, short s, int n, int n2, int n3) throws SQLException {
        try {
            Object object = null;
            block1 : switch (s) {
                case 39: 
                case 47: {
                    short s2 = this.reader.readUnsignedInt8();
                    if (s2 != 0) {
                        this.reader.setTransliterator(this.comm.transliteratorForCharData);
                        object = this.reader.readString(s2);
                        this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
                        if (s == 47) {
                            object = this.addBlanks((String)object, n2 - s2);
                        }
                    }
                    nArray[0] = 10;
                    break;
                }
                case 37: 
                case 45: {
                    int n4 = this.reader.readUnsignedInt8();
                    if (n4 != 0) {
                        byte[] byArray;
                        if (s == 45) {
                            byArray = new byte[n2];
                            this.reader.readBytes(byArray, 0, n4);
                            for (int i = n4; i < n2; ++i) {
                                byArray[i] = 0;
                            }
                        } else {
                            byArray = new byte[n4];
                            this.reader.readBytes(byArray, 0, n4);
                        }
                        object = byArray;
                    }
                    nArray[0] = 2;
                    break;
                }
                case 48: {
                    object = new Short(this.reader.readUnsignedInt8());
                    nArray[0] = 3;
                    break;
                }
                case 52: {
                    object = new Short(this.reader.readInt16());
                    nArray[0] = 3;
                    break;
                }
                case 56: {
                    object = new Integer(this.reader.readInt32());
                    nArray[0] = 4;
                    break;
                }
                case -65: 
                case 57: {
                    object = new Long(this.reader.readInt64());
                    nArray[0] = 5;
                    break;
                }
                case 38: {
                    short s3 = this.reader.readUnsignedInt8();
                    switch (s3) {
                        case 1: {
                            object = new Short(this.reader.readUnsignedInt8());
                            nArray[0] = 3;
                            break block1;
                        }
                        case 2: {
                            object = new Short(this.reader.readInt16());
                            nArray[0] = 3;
                            break block1;
                        }
                        case 4: {
                            object = new Integer(this.reader.readInt32());
                            nArray[0] = 4;
                            break block1;
                        }
                        case 8: {
                            object = new Long(this.reader.readInt64());
                            nArray[0] = 5;
                            break block1;
                        }
                    }
                    nArray[0] = 3;
                    break;
                }
                case -73: 
                case 65: {
                    object = new Integer(this.reader.readUnsignedInt16());
                    nArray[0] = 4;
                    break;
                }
                case -69: 
                case 66: {
                    object = new Long(this.reader.readUnsignedInt32());
                    nArray[0] = 5;
                    break;
                }
                case -66: 
                case 67: {
                    byte[] byArray = new byte[8];
                    this.reader.readBytes(byArray, 0, 8);
                    BigInteger bigInteger = new BigInteger(1, byArray);
                    object = new BigDecimal(bigInteger, 0);
                    nArray[0] = 8;
                    break;
                }
                case 43: 
                case 68: {
                    short s4 = this.reader.readUnsignedInt8();
                    switch (s4) {
                        case 1: {
                            object = new Short(this.reader.readUnsignedInt8());
                            nArray[0] = 3;
                            break block1;
                        }
                        case 2: {
                            object = new Integer(this.reader.readUnsignedInt16());
                            nArray[0] = 4;
                            break block1;
                        }
                        case 4: {
                            object = new Long(this.reader.readUnsignedInt32());
                            nArray[0] = 5;
                            break block1;
                        }
                        case 8: {
                            byte[] byArray = new byte[8];
                            this.reader.readBytes(byArray, 0, 8);
                            BigInteger bigInteger = new BigInteger(1, byArray);
                            object = new BigDecimal(bigInteger, 0);
                            nArray[0] = 8;
                            break block1;
                        }
                    }
                    nArray[0] = 3;
                    break;
                }
                case 59: {
                    float f = this.reader.readIEEE32BitFloat();
                    object = new Float(f);
                    nArray[0] = 6;
                    break;
                }
                case 62: {
                    double d = this.reader.readIEEE64BitDouble();
                    object = new Double(d);
                    nArray[0] = 7;
                    break;
                }
                case 109: {
                    short s5 = this.reader.readUnsignedInt8();
                    if (s5 == 4) {
                        float f = this.reader.readIEEE32BitFloat();
                        object = new Float(f);
                        nArray[0] = 6;
                        break;
                    }
                    if (s5 == 8) {
                        double d = this.reader.readIEEE64BitDouble();
                        object = new Double(d);
                        nArray[0] = 7;
                        break;
                    }
                    nArray[0] = 6;
                    break;
                }
                case 106: 
                case 108: {
                    int n5 = this.reader.readUnsignedInt8();
                    if (n5 != 0) {
                        short s6 = this.reader.readUnsignedInt8();
                        if (--n5 == 32) {
                            if (this.processParamFlag) {
                                byte[] byArray = new byte[16];
                                this.reader.readBytes(byArray, 0, 16);
                                BigInteger bigInteger = new BigInteger(s6 == 1 ? -1 : 1, byArray);
                                object = new BigDecimal(bigInteger, n3);
                                this.reader.readAndDiscardBytes(16);
                                this.processParamFlag = false;
                            } else if (n2 <= 38) {
                                byte[] byArray = new byte[16];
                                this.reader.readBytes(byArray, 0, 16);
                                boolean bl = false;
                                for (int i = 15; i >= 0; --i) {
                                    if (byArray[i] == 0) continue;
                                    bl = true;
                                    break;
                                }
                                if (bl) {
                                    this.reader.readAndDiscardBytes(16);
                                } else {
                                    this.reader.readBytes(byArray, 0, 16);
                                }
                                BigInteger bigInteger = new BigInteger(s6 == 1 ? -1 : 1, byArray);
                                object = new BigDecimal(bigInteger, n3);
                            } else {
                                byte[] byArray = new byte[n5];
                                this.reader.readBytes(byArray, 0, n5);
                                BigInteger bigInteger = new BigInteger(s6 == 1 ? -1 : 1, byArray);
                                object = new BigDecimal(bigInteger, n3);
                            }
                        } else {
                            byte[] byArray = new byte[n5];
                            this.reader.readBytes(byArray, 0, n5);
                            BigInteger bigInteger = new BigInteger(s6 == 1 ? -1 : 1, byArray);
                            object = new BigDecimal(bigInteger, n3);
                        }
                    }
                    nArray[0] = 8;
                    break;
                }
                case 122: {
                    byte[] byArray = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    BigInteger bigInteger = new BigInteger(byArray);
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 8;
                    break;
                }
                case 60: {
                    byte[] byArray = new byte[4];
                    byte[] byArray2 = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    this.reader.readBytes(byArray2, 0, 4);
                    BigInteger bigInteger = new BigInteger(UtilByteArray.concatenate(byArray, byArray2));
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 8;
                    break;
                }
                case 110: {
                    short s7 = this.reader.readUnsignedInt8();
                    if (s7 != 0) {
                        BigInteger bigInteger;
                        if (s7 == 8) {
                            byte[] byArray = new byte[4];
                            byte[] byArray3 = new byte[4];
                            this.reader.readBytes(byArray, 0, 4);
                            this.reader.readBytes(byArray3, 0, 4);
                            bigInteger = new BigInteger(UtilByteArray.concatenate(byArray, byArray3));
                        } else {
                            byte[] byArray = new byte[4];
                            this.reader.readBytes(byArray, 0, 4);
                            bigInteger = new BigInteger(byArray);
                        }
                        object = new BigDecimal(bigInteger, n3);
                    }
                    nArray[0] = 8;
                    break;
                }
                case 50: {
                    object = new Boolean(this.reader.readInt8() != 0);
                    nArray[0] = 9;
                    break;
                }
                case 58: 
                case 61: 
                case 111: {
                    int n6 = s == 111 ? this.reader.readUnsignedInt8() : (s == 61 ? 8 : 4);
                    if (n6 != 0) {
                        byte[] byArray = new byte[n6];
                        this.reader.readBytes(byArray, 0, n6);
                        object = byArray;
                    }
                    if (n6 == 8) {
                        nArray[0] = 104;
                        break;
                    }
                    nArray[0] = 105;
                    break;
                }
                case -109: {
                    short s8 = this.reader.readUnsignedInt8();
                    if (s8 != 0) {
                        byte[] byArray = new byte[s8];
                        this.reader.readBytes(byArray, 0, s8);
                        object = byArray;
                    }
                    nArray[0] = 107;
                    break;
                }
                case 51: {
                    byte[] byArray = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    object = byArray;
                    nArray[0] = 107;
                    break;
                }
                case 123: {
                    short s9 = this.reader.readUnsignedInt8();
                    if (s9 != 0) {
                        byte[] byArray = new byte[s9];
                        this.reader.readBytes(byArray, 0, s9);
                        object = byArray;
                    }
                    nArray[0] = 106;
                    break;
                }
                case 49: {
                    byte[] byArray = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    object = byArray;
                    nArray[0] = 106;
                    break;
                }
                case -81: 
                case -31: {
                    nArray[0] = s == -81 ? 10 : 2;
                    int n7 = this.reader.readInt32();
                    if (n7 == -1 || n7 == 0) break;
                    if (s == -81) {
                        if (n == 34 || n == 35) {
                            this.reader.setTransliterator(this.comm.ucs2Transliterator);
                            object = this.reader.readString(n7);
                            this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
                            if (n != 34) break;
                            object = this.addBlanks((String)object, n2 - n7 / 2);
                            break;
                        }
                        this.reader.setTransliterator(this.comm.transliteratorForCharData);
                        object = this.reader.readString(n7);
                        this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
                        break;
                    }
                    byte[] byArray = new byte[n7];
                    this.reader.readBytes(byArray, 0, n7);
                    object = byArray;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"0x" + UtilDataConversions.byteToHex((byte)s)};
                    throw this.comm.exceptions.getException(7013, stringArray);
                }
            }
            return object;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    void processParamFormat(byte by) throws SQLException {
        try {
            switch (by) {
                case -20: {
                    this.reader.readInt16();
                    break;
                }
                case 32: {
                    this.reader.readInt32();
                    this.processParamFlag = true;
                }
            }
            this.numOutParams = this.reader.readInt16();
            this.hiddenOutputParams = new SybaseTDSParameter[this.numOutParams + 1];
            for (int i = 1; i <= this.numOutParams; ++i) {
                SybaseTDSParameter sybaseTDSParameter = this.getOutputParam(i);
                sybaseTDSParameter.metaDataForOutputValue = this.readMetaData(by);
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    void processReturnValue() throws SQLException {
        try {
            Object object;
            SybaseMetaData sybaseMetaData;
            this.reader.readInt16();
            SybaseTDSParameter sybaseTDSParameter = this.getOutputParam(++this.numOutParams);
            sybaseTDSParameter.metaDataForOutputValue = sybaseMetaData = this.readMetaData((byte)-84);
            this.returnValueType[0] = -1;
            sybaseTDSParameter.data = object = this.getReturnedValue(this.returnValueType, sybaseMetaData.nativeType, sybaseMetaData.userType, sybaseMetaData.precision, sybaseMetaData.scale);
            sybaseTDSParameter.baseDataType = this.returnValueType[0];
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public void completeRowProcessing(BaseWarnings baseWarnings) throws SQLException {
        if (this.resultType == 2 && !this.lastRowReturned) {
            boolean bl = true;
            while (bl) {
                try {
                    bl = this.getRow(baseWarnings);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            this.lastRowReturned = false;
        }
    }

    void processParams() throws SQLException {
        for (int i = 1; i <= this.numOutParams; ++i) {
            Object object;
            SybaseTDSParameter sybaseTDSParameter = this.getOutputParam(i);
            SybaseMetaData sybaseMetaData = sybaseTDSParameter.metaDataForOutputValue;
            this.returnValueType[0] = -1;
            sybaseTDSParameter.data = object = this.getReturnedValue(this.returnValueType, sybaseMetaData.nativeType, sybaseMetaData.userType, sybaseMetaData.precision, sybaseMetaData.scale);
            sybaseTDSParameter.baseDataType = this.returnValueType[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void discardReplyBytes() throws SQLException {
        try {
            this.readSocketTimeout = this.comm.connection.implConnection.getCancelPendingTimeout();
            if (this.comm.enableCancelTimeout && this.readSocketTimeout > 0 && (this.comm.cancelInfo.getCancelCount() > 0 || this.comm.cancelInfo.cancelTimeoutExpired)) {
                var1_1 = 0;
                var2_3 = null;
                try {
                    var2_3 = this.comm.getSocket();
                    var1_1 = var2_3.getSoTimeout();
                    var2_3.setSoTimeout(this.readSocketTimeout * 1000);
                    this.reader.empty();
                }
                catch (Exception var3_5) {
                    if (!(var3_5 instanceof UtilException)) ** GOTO lbl31
                    var4_7 = (UtilException)var3_5;
                    if (var4_7.getReason() == 1029) {
                        try {
                            var2_3.close();
                        }
                        catch (IOException var5_8) {
                            // empty catch block
                        }
                        throw this.comm.exceptions.getException(6106, "08S01");
                    }
                    throw var4_7;
                }
                finally {
                    try {
                        if (var2_3 != null) {
                            var2_3.setSoTimeout(var1_1);
                        }
                    }
                    catch (SocketException var3_6) {}
                }
            } else {
                this.reader.empty();
            }
lbl31:
            // 3 sources

            this.processPendingCancels(null);
            if (this.comm.currentlyRegisteredReader == this.reader) {
                this.comm.currentlyRegisteredReader = null;
            }
        }
        catch (UtilException var1_2) {
            // empty catch block
        }
    }

    public String getNameForTokenType(byte by) {
        switch (by) {
            case -89: {
                return "TDS_ALTNAME";
            }
            case -45: {
                return "TDS_ALTROW";
            }
            case -91: {
                return "TDS_COLINFO";
            }
            case -3: {
                return "TDS_DONE";
            }
            case -2: {
                return "TDS_DONEPROC";
            }
            case -1: {
                return "TDS_DONEINPROC";
            }
            case -29: {
                return "TDS_ENVCHANGE";
            }
            case -86: {
                return "TDS_ERROR";
            }
            case -85: {
                return "TDS_INFO";
            }
            case -83: {
                return "TDS_LOGINACK";
            }
            case 101: {
                return "TDS_MSG";
            }
            case 120: {
                return "TDS_OFFSET";
            }
            case -20: {
                return "TDS_PARAMFMT";
            }
            case 32: {
                return "TDS_PARAMFMT2";
            }
            case -41: {
                return "TDS_PARAMS";
            }
            case -84: {
                return "TDS_RETURNVALUE";
            }
            case 121: {
                return "TDS_RETURNSTATUS";
            }
            case -47: {
                return "TDS_ROW";
            }
            case -92: {
                return "TDS_TABNAME";
            }
        }
        return "0x" + UtilDataConversions.byteToHex(by);
    }

    public void processPendingCancels(BaseWarnings baseWarnings) {
        if (!this.inProcessPendingCancels) {
            this.inProcessPendingCancels = true;
            int n = 0;
            while (this.comm.cancelInfo.getCancelCount() > 0) {
                byte by;
                try {
                    n = this.comm.getSocket().getSoTimeout();
                    this.comm.getSocket().setSoTimeout(2000);
                    this.reader.receive();
                    by = this.reader.readInt8();
                    this.comm.getSocket().setSoTimeout(n);
                }
                catch (UtilException utilException) {
                    this.comm.cancelInfo.cancelTimeoutExpired = true;
                    this.comm.cancelInfo.setCancelCount(0);
                    try {
                        this.comm.getSocket().setSoTimeout(n);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    this.inProcessPendingCancels = false;
                    return;
                }
                catch (SocketException socketException) {
                    return;
                }
                try {
                    if (!this.processReplyToken(by, baseWarnings)) continue;
                    this.processReply(baseWarnings);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("HY008")) continue;
                    this.comm.cancelInfo.setCancelCount(0);
                    this.comm.cancelInfo.cancelTimeoutExpired = true;
                }
            }
            this.inProcessPendingCancels = false;
        }
    }
}

