/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.controller;

import com.metamatrix.common.comm.ServerListenerRegistry;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.registry.MetaMatrixVMRegistry;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceBusInterface;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceNotLicensedException;
import com.metamatrix.platform.service.controller.ServiceController;
import com.metamatrix.platform.service.controller.StartServiceWorkItem;
import java.util.Date;
import java.util.Properties;

public class StartServiceWorker
extends QueueWorker {
    public void initialize() throws QueueWorkerException {
    }

    public void process(Object o) throws QueueWorkerException {
        this.process(o, true);
    }

    public void process(Object o, boolean asynchronous) throws QueueWorkerException {
        StartServiceWorkItem item = (StartServiceWorkItem)o;
        this.startService(item.serverListenerRegistry, item.serviceController, item.serviceID, item.deployedComponent, item.serviceClass, item.pscID, item.serviceProps, asynchronous);
    }

    public void cleanup() throws QueueWorkerException {
    }

    private void startService(ServerListenerRegistry serverListenerRegistry, ServiceController serviceController, ServiceID serviceID, DeployedComponent deployedComponent, String serviceClass, ProductServiceConfigID pscID, Properties serviceProps, boolean asynchronous) throws QueueWorkerException {
        block5: {
            String serviceInstanceName = null;
            try {
                serviceInstanceName = serviceProps.getProperty("InstanceName");
                String componentType = serviceProps.getProperty("ComponentTypeName");
                String serviceType = serviceProps.getProperty("ServiceName");
                String routingID = serviceProps.getProperty("ServiceRoutingID");
                String essentialStr = serviceProps.getProperty("metamatrix.service.essentialservice");
                boolean essential = false;
                if (essentialStr != null && essentialStr.trim().length() != 0) {
                    essential = Boolean.valueOf(essentialStr);
                }
                ServiceInterface service = (ServiceInterface)Class.forName(serviceClass).newInstance();
                this.logMessage(PlatformPlugin.Util.getString("ServiceController.0", (Object)serviceInstanceName));
                ServiceRegistryBinding binding = new ServiceRegistryBinding(serviceID, service, routingID, serviceInstanceName, componentType, serviceInstanceName, serviceController.getHostName(), deployedComponent, pscID, service.getCurrentState(), service.getStateChangeTime(), essential);
                MetaMatrixVMRegistry.registerService((ServiceRegistryBinding)binding);
                try {
                    Object[] param1 = new Object[]{serviceID};
                    DeployedComponentID deployedComponentID = (DeployedComponentID)deployedComponent.getID();
                    this.logMessage(PlatformPlugin.Util.getString("ServiceController.1", param1));
                    service.init(serviceID, deployedComponentID, serviceProps, (ServiceBusInterface)serviceController, serverListenerRegistry);
                    this.logMessage(PlatformPlugin.Util.getString("ServiceController.2", param1));
                    this.logMessage(PlatformPlugin.Util.getString("ServiceController.3", param1));
                }
                catch (ServiceNotLicensedException e) {
                    this.logCritical(e.getMessage());
                    MetaMatrixVMRegistry.unregisterService((ServiceID)serviceID);
                }
                this.logMessage(PlatformPlugin.Util.getString("MSG.014.008.0009", (Object)serviceType, (Object)serviceInstanceName));
            }
            catch (Exception e) {
                serviceController.updateServiceState(serviceID, 4, new Date());
                String message = PlatformPlugin.Util.getString("ERR.014.008.0028", (Object)serviceInstanceName);
                this.logException(e, message);
                if (asynchronous) break block5;
                throw new QueueWorkerException(e, message);
            }
        }
    }

    private void logMessage(String s) {
        LogManager.logInfo((String)"SERVICE_CONTROLLER", (String)s);
    }

    private void logCritical(String s) {
        LogManager.logCritical((String)"SERVICE_CONTROLLER", (String)s);
    }

    private void logException(Throwable e, String msg) {
        LogManager.logError((String)"SERVICE_CONTROLLER", (Throwable)e, (String)msg);
    }
}

