/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.merant.SlExtensionInterface;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.extensions.ExtConnection;
import com.metamatrix.jdbc.extensions.ExtLogControl;
import com.metamatrix.jdbc.extensions.ExtStatementPoolMonitor;
import com.metamatrix.jdbcspy.SpyCallableStatement;
import com.metamatrix.jdbcspy.SpyConfigInterface;
import com.metamatrix.jdbcspy.SpyDatabaseMetaData;
import com.metamatrix.jdbcspy.SpyLogger;
import com.metamatrix.jdbcspy.SpyPreparedStatement;
import com.metamatrix.jdbcspy.SpyStatement;
import com.metamatrix.jdbcx.base.BaseConnectionWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class SpyConnection
implements Connection,
ExtConnection,
ExtEmbeddedConnection,
ExtLogControl,
com.ddtek.jdbc.extensions.SlExtensionInterface,
com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection,
SlExtensionInterface {
    private static String footprint = "$Revision:   1.22.1.1  $";
    private Connection realConnection;
    private SpyLogger spyLogger;
    private int id;
    private static int Id;

    public SpyConnection(Connection connection, SpyLogger spyLogger) {
        this.realConnection = connection;
        this.spyLogger = this.getSpyLogger();
        this.id = ++Id;
        try {
            CallableStatement callableStatement = connection.prepareCall("--!ddtc!\n{call ddtc(?)}");
            long l = new Random().nextLong();
            callableStatement.setLong(1, l);
            callableStatement.execute();
            long l2 = callableStatement.getLong(1);
            callableStatement.close();
            if (l2 == (l ^ 0x1B69B4BE052FAB1L) / 3L) {
                this.spyLogger = spyLogger;
                SpyDatabaseMetaData spyDatabaseMetaData = (SpyDatabaseMetaData)this.getMetaData();
                String string = spyDatabaseMetaData.getURL();
                String string2 = spyDatabaseMetaData.getDriverName();
                String string3 = spyDatabaseMetaData.getDriverVersion();
                String string4 = spyDatabaseMetaData.getDatabaseProductName();
                String string5 = spyDatabaseMetaData.getDatabaseProductVersion();
                spyLogger.println("\nConnection Options : ");
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    spyLogger.println("\t\t" + stringTokenizer.nextToken().toString());
                }
                spyLogger.println("Driver Name = " + string2);
                spyLogger.println("Driver Version = " + string3);
                spyLogger.println("Database Name = " + string4);
                spyLogger.println("Database Version = " + string5);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setEnableLogging(boolean bl) {
        this.spyLogger.enabled = bl;
    }

    public boolean getEnableLogging() {
        return this.spyLogger.enabled;
    }

    private SpyLogger getSpyLogger() {
        return new SpyLogger(){

            void enter() {
            }

            void leave() {
            }

            protected void readConfig(SpyConfigInterface spyConfigInterface) {
            }

            protected PrintWriter getLog() {
                Writer writer = new Writer(){

                    public void write(char[] cArray, int n, int n2) throws IOException {
                    }

                    public void flush() throws IOException {
                    }

                    public void close() throws IOException {
                    }
                };
                return new PrintWriter(writer);
            }
        };
    }

    public void abortConnection() throws SQLException {
        this.spyLogger.println("\n" + this + ".abortConnection()");
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).abortConnection();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final Statement createStatement() throws SQLException {
        Statement statement;
        this.spyLogger.println("\n" + this + ".createStatement()");
        this.spyLogger.enter();
        try {
            statement = this.realConnection.createStatement();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyStatement spyStatement = new SpyStatement(statement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyStatement + ")");
        return spyStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        this.spyLogger.println("\n" + this + ".prepareStatement(String sql)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.enter();
        try {
            preparedStatement = this.realConnection.prepareStatement(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyPreparedStatement spyPreparedStatement = new SpyPreparedStatement(preparedStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyPreparedStatement + ")");
        return spyPreparedStatement;
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement;
        SpyLogger spyLogger = "--!ddtc!\n{call ddtc(?)}".equals(string) ? this.getSpyLogger() : this.spyLogger;
        spyLogger.println("\n" + this + ".prepareCall(String sql)");
        spyLogger.println("sql = " + string);
        spyLogger.enter();
        try {
            callableStatement = this.realConnection.prepareCall(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        spyLogger.leave();
        SpyCallableStatement spyCallableStatement = new SpyCallableStatement(callableStatement, spyLogger, this);
        spyLogger.println("OK (" + spyCallableStatement + ")");
        return spyCallableStatement;
    }

    public final String nativeSQL(String string) throws SQLException {
        String string2;
        this.spyLogger.println("\n" + this + ".nativeSQL(String sql)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.enter();
        try {
            string2 = this.realConnection.nativeSQL(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string2 + ")");
        return string2;
    }

    public final void setAutoCommit(boolean bl) throws SQLException {
        this.spyLogger.println("\n" + this + ".setAutoCommit(boolean autoCommit)");
        this.spyLogger.println("autoCommit = " + bl);
        this.spyLogger.enter();
        try {
            this.realConnection.setAutoCommit(bl);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean getAutoCommit() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".getAutoCommit()");
        this.spyLogger.enter();
        try {
            bl = this.realConnection.getAutoCommit();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void commit() throws SQLException {
        this.spyLogger.println("\n" + this + ".commit()");
        this.spyLogger.enter();
        try {
            this.realConnection.commit();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void rollback() throws SQLException {
        this.spyLogger.println("\n" + this + ".rollback()");
        this.spyLogger.enter();
        try {
            this.realConnection.rollback();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void close() throws SQLException {
        this.spyLogger.println("\n" + this + ".close()");
        this.spyLogger.enter();
        try {
            this.realConnection.close();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean isClosed() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isClosed()");
        this.spyLogger.enter();
        try {
            bl = this.realConnection.isClosed();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData;
        this.spyLogger.println("\n" + this + ".getMetaData()");
        this.spyLogger.enter();
        try {
            databaseMetaData = this.realConnection.getMetaData();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyDatabaseMetaData spyDatabaseMetaData = new SpyDatabaseMetaData(databaseMetaData, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyDatabaseMetaData + ")");
        return spyDatabaseMetaData;
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        this.spyLogger.println("\n" + this + ".setReadOnly(boolean readOnly)");
        this.spyLogger.println("readOnly = " + bl);
        this.spyLogger.enter();
        try {
            this.realConnection.setReadOnly(bl);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean isReadOnly() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isReadOnly()");
        this.spyLogger.enter();
        try {
            bl = this.realConnection.isReadOnly();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void setCatalog(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setCatalog(String catalog)");
        this.spyLogger.println("catalog = " + string);
        this.spyLogger.enter();
        try {
            this.realConnection.setCatalog(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final String getCatalog() throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getCatalog()");
        this.spyLogger.enter();
        try {
            string = this.realConnection.getCatalog();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTransactionIsolation(int level)");
        this.spyLogger.println("level = " + n);
        this.spyLogger.enter();
        try {
            this.realConnection.setTransactionIsolation(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getTransactionIsolation() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getTransactionIsolation()");
        this.spyLogger.enter();
        try {
            n = this.realConnection.getTransactionIsolation();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        this.spyLogger.println("\n" + this + ".getWarnings()");
        this.spyLogger.enter();
        try {
            sQLWarning = this.realConnection.getWarnings();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.printSqlWarning(sQLWarning);
        this.spyLogger.println("OK");
        return sQLWarning;
    }

    public final void clearWarnings() throws SQLException {
        this.spyLogger.println("\n" + this + ".clearWarnings()");
        this.spyLogger.enter();
        try {
            this.realConnection.clearWarnings();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        Statement statement;
        this.spyLogger.println("\n" + this + ".createStatement(int resultSetType, int resultSetConcurrency)");
        this.spyLogger.println("\n" + this + "resultSetType = " + n);
        this.spyLogger.println("\n" + this + "resultSetConcurrency = " + n2);
        this.spyLogger.enter();
        try {
            statement = this.realConnection.createStatement(n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyStatement spyStatement = new SpyStatement(statement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyStatement + ")");
        return spyStatement;
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement;
        this.spyLogger.println("\n" + this + ".prepareStatement(String sql, int resultSetType, int resultSetConcurrency)");
        this.spyLogger.println("\n" + this + "sql = " + string);
        this.spyLogger.println("\n" + this + "resultSetType = " + n);
        this.spyLogger.println("\n" + this + "resultSetConcurrency = " + n2);
        this.spyLogger.enter();
        try {
            preparedStatement = this.realConnection.prepareStatement(string, n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyPreparedStatement spyPreparedStatement = new SpyPreparedStatement(preparedStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyPreparedStatement + ")");
        return spyPreparedStatement;
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        this.spyLogger.println("\n" + this + ".prepareCall(String sql, int resultSetType, int resultSetConcurrency)");
        this.spyLogger.println("\n" + this + "sql = " + string);
        this.spyLogger.println("\n" + this + "resultSetType = " + n);
        this.spyLogger.println("\n" + this + "resultSetConcurrency = " + n2);
        this.spyLogger.enter();
        try {
            callableStatement = this.realConnection.prepareCall(string, n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyCallableStatement spyCallableStatement = new SpyCallableStatement(callableStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyCallableStatement + ")");
        return spyCallableStatement;
    }

    public final Map getTypeMap() throws SQLException {
        Map<String, Class<?>> map;
        this.spyLogger.println("\n" + this + ".getTypeMap()");
        this.spyLogger.enter();
        try {
            map = this.realConnection.getTypeMap();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + map + ")");
        return map;
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.spyLogger.println("\n" + this + ".setTypeMap(java.util.Map map)");
        this.spyLogger.println("map = " + map);
        this.spyLogger.enter();
        try {
            this.realConnection.setTypeMap(map);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setHoldability(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setHoldability(int holdability)");
        this.spyLogger.println("holdability = " + n);
        this.spyLogger.enter();
        try {
            this.realConnection.setHoldability(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getHoldability() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getHoldability()");
        this.spyLogger.enter();
        try {
            n = this.realConnection.getHoldability();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final Savepoint setSavepoint() throws SQLException {
        Savepoint savepoint;
        this.spyLogger.println("\n" + this + ".setSavepoint()");
        this.spyLogger.enter();
        try {
            savepoint = this.realConnection.setSavepoint();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + savepoint + ")");
        return savepoint;
    }

    public final Savepoint setSavepoint(String string) throws SQLException {
        Savepoint savepoint;
        this.spyLogger.println("\n" + this + ".setSavepoint(String name)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.enter();
        try {
            savepoint = this.realConnection.setSavepoint(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + savepoint + ")");
        return savepoint;
    }

    public final void rollback(Savepoint savepoint) throws SQLException {
        this.spyLogger.println("\n" + this + ".rollback(Savepoint savepoint)");
        this.spyLogger.println("savepoint = " + savepoint);
        this.spyLogger.enter();
        try {
            this.realConnection.rollback(savepoint);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.spyLogger.println("\n" + this + ".releaseSavepoint(Savepoint savepoint)");
        this.spyLogger.println("savepoint = " + savepoint);
        this.spyLogger.enter();
        try {
            this.realConnection.releaseSavepoint(savepoint);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final Statement createStatement(int n, int n2, int n3) throws SQLException {
        Statement statement;
        this.spyLogger.println("\n" + this + ".createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
        this.spyLogger.println("\n" + this + "resultSetType = " + n);
        this.spyLogger.println("\n" + this + "resultSetConcurrency = " + n2);
        this.spyLogger.println("\n" + this + "resultSetHoldability = " + n3);
        this.spyLogger.enter();
        try {
            statement = this.realConnection.createStatement(n, n2, n3);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyStatement spyStatement = new SpyStatement(statement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyStatement + ")");
        return spyStatement;
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement;
        this.spyLogger.println("\n" + this + ".prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
        this.spyLogger.println("\n" + this + "sql = " + string);
        this.spyLogger.println("\n" + this + "resultSetType = " + n);
        this.spyLogger.println("\n" + this + "resultSetConcurrency = " + n2);
        this.spyLogger.println("\n" + this + "resultSetHoldability = " + n3);
        this.spyLogger.enter();
        try {
            preparedStatement = this.realConnection.prepareStatement(string, n, n2, n3);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyPreparedStatement spyPreparedStatement = new SpyPreparedStatement(preparedStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyPreparedStatement + ")");
        return spyPreparedStatement;
    }

    public final CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement;
        this.spyLogger.println("\n" + this + ".prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
        this.spyLogger.println("\n" + this + "sql = " + string);
        this.spyLogger.println("\n" + this + "resultSetType = " + n);
        this.spyLogger.println("\n" + this + "resultSetConcurrency = " + n2);
        this.spyLogger.println("\n" + this + "resultSetHoldability = " + n3);
        this.spyLogger.enter();
        try {
            callableStatement = this.realConnection.prepareCall(string, n, n2, n3);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyCallableStatement spyCallableStatement = new SpyCallableStatement(callableStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyCallableStatement + ")");
        return spyCallableStatement;
    }

    public final PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement;
        this.spyLogger.println("\n" + this + ".prepareStatement(String sql, int autoGeneratedKeys)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("autoGeneratedKeys = " + n);
        this.spyLogger.enter();
        try {
            preparedStatement = this.realConnection.prepareStatement(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyPreparedStatement spyPreparedStatement = new SpyPreparedStatement(preparedStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyPreparedStatement + ")");
        return spyPreparedStatement;
    }

    public final PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement;
        this.spyLogger.println("\n" + this + ".prepareStatement(String sql, int[] columnIndexes)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("columnIndexes = " + this.spyLogger.intArrayToString(nArray));
        this.spyLogger.enter();
        try {
            preparedStatement = this.realConnection.prepareStatement(string, nArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyPreparedStatement spyPreparedStatement = new SpyPreparedStatement(preparedStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyPreparedStatement + ")");
        return spyPreparedStatement;
    }

    public final PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement;
        this.spyLogger.println("\n" + this + ".prepareStatement(String sql, String[] columnNames)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("columnNames = " + this.spyLogger.stringArrayToString(stringArray));
        this.spyLogger.enter();
        try {
            preparedStatement = this.realConnection.prepareStatement(string, stringArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyPreparedStatement spyPreparedStatement = new SpyPreparedStatement(preparedStatement, this.spyLogger, this);
        this.spyLogger.println("OK (" + spyPreparedStatement + ")");
        return spyPreparedStatement;
    }

    public boolean unlock(String string) throws SQLException {
        if (this.realConnection instanceof ExtEmbeddedConnection) {
            ExtEmbeddedConnection extEmbeddedConnection = (ExtEmbeddedConnection)this.realConnection;
            return extEmbeddedConnection.unlock(string);
        }
        if (this.realConnection instanceof com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection) {
            com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection extEmbeddedConnection = (com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection)this.realConnection;
            return extEmbeddedConnection.unlock(string);
        }
        throw new SQLException("This method cannot be called on this driver");
    }

    public void setApplicationId(String string) throws SQLException {
        if (this.realConnection instanceof com.ddtek.jdbc.extensions.SlExtensionInterface) {
            com.ddtek.jdbc.extensions.SlExtensionInterface slExtensionInterface = (com.ddtek.jdbc.extensions.SlExtensionInterface)((Object)this.realConnection);
            slExtensionInterface.setApplicationId(string);
        } else if (this.realConnection instanceof SlExtensionInterface) {
            SlExtensionInterface slExtensionInterface = (SlExtensionInterface)((Object)this.realConnection);
            slExtensionInterface.setApplicationId(string);
        } else {
            throw new SQLException("This method cannot be called on this driver");
        }
    }

    public void setOemId(String string) throws SQLException {
        if (!(this.realConnection instanceof SlExtensionInterface)) {
            throw new SQLException("This method cannot be called on this driver");
        }
        SlExtensionInterface slExtensionInterface = (SlExtensionInterface)((Object)this.realConnection);
        slExtensionInterface.setOemId(string);
    }

    public final String toString() {
        return "Connection[" + this.id + "]";
    }

    public void setClientApplicationName(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setClientApplicationName(String name)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setClientApplicationName(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public String getClientApplicationName() throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getClientApplicationName()");
        this.spyLogger.enter();
        try {
            string = ((ExtConnection)this.realConnection).getClientApplicationName();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public void setClientHostName(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setClientHostName(String name)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setClientHostName(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public String getClientHostName() throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getClientHostName()");
        this.spyLogger.enter();
        try {
            string = ((ExtConnection)this.realConnection).getClientHostName();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public void setClientUser(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setClientUser(String user)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setClientUser(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public String getClientUser() throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getClientUser()");
        this.spyLogger.enter();
        try {
            string = ((ExtConnection)this.realConnection).getClientUser();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public void setClientAccountingInfo(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setClientAccountingInfo(String name)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setClientAccountingInfo(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public String getClientAccountingInfo() throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getClientAccountingInfo()");
        this.spyLogger.enter();
        try {
            string = ((ExtConnection)this.realConnection).getClientAccountingInfo();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public synchronized String getCurrentUser() throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getCurrentUser()");
        this.spyLogger.enter();
        try {
            string = ((ExtConnection)this.realConnection).getCurrentUser();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public synchronized void setCurrentUser(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setCurrentUser(String username)");
        this.spyLogger.println("username = " + string);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setCurrentUser(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public synchronized void setCurrentUser(String string, Properties properties) throws SQLException {
        this.spyLogger.println("\n" + this + ".setCurrentUser(String username,Properties options)");
        this.spyLogger.println("username = " + string);
        this.spyLogger.println("options = " + properties);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setCurrentUser(string, properties);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public synchronized void setCurrentUser(Subject subject) throws SQLException {
        this.spyLogger.println("\n" + this + ".setCurrentUser(Subject subject)");
        this.spyLogger.println("subject = " + subject);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setCurrentUser(subject);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public synchronized void setCurrentUser(Subject subject, Properties properties) throws SQLException {
        this.spyLogger.println("\n" + this + ".setCurrentUser(Subject subject,Properties options)");
        this.spyLogger.println("subject = " + subject);
        this.spyLogger.println("options = " + properties);
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).setCurrentUser(subject, properties);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public synchronized void resetUser() throws SQLException {
        this.spyLogger.println("\n" + this + ".resetUser()");
        this.spyLogger.enter();
        try {
            ((ExtConnection)this.realConnection).resetUser();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public synchronized boolean supportsReauthentication() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".supportsReauthentication()");
        this.spyLogger.enter();
        try {
            bl = ((ExtConnection)this.realConnection).supportsReauthentication();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public ExtStatementPoolMonitor getStatementPoolMonitor() throws SQLException {
        return ((ExtConnection)this.realConnection).getStatementPoolMonitor();
    }

    public String getClientInfo(String string) throws SQLException {
        String string2;
        this.spyLogger.println("\n" + this + ".getClientInfo(String name)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.enter();
        try {
            string2 = this.realConnection instanceof BaseConnectionWrapper ? ((BaseConnectionWrapper)this.realConnection).getClientInfo(string) : ((BaseConnection)this.realConnection).getClientInfo(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string2 + ")");
        return string2;
    }

    public Properties getClientInfo() throws SQLException {
        Properties properties;
        this.spyLogger.println("\n" + this + ".getClientInfo()");
        this.spyLogger.enter();
        try {
            properties = this.realConnection instanceof BaseConnectionWrapper ? ((BaseConnectionWrapper)this.realConnection).getClientInfo() : ((BaseConnection)this.realConnection).getClientInfo();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + properties + ")");
        return properties;
    }

    public void setClientInfo(String string, String string2) throws SQLException {
        this.spyLogger.println("\n" + this + ".setClientInfo(String name, String value)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.println("value = " + string2);
        this.spyLogger.enter();
        try {
            if (this.realConnection instanceof BaseConnectionWrapper) {
                ((BaseConnectionWrapper)this.realConnection).setClientInfo(string, string2);
            } else {
                ((BaseConnection)this.realConnection).setClientInfo(string, string2);
            }
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public void setClientInfo(Properties properties) throws SQLException {
        this.spyLogger.println("\n" + this + ".setClientInfo(Properties properties)");
        this.spyLogger.println("properties = " + properties);
        this.spyLogger.enter();
        try {
            if (this.realConnection instanceof BaseConnectionWrapper) {
                ((BaseConnectionWrapper)this.realConnection).setClientInfo(properties);
            } else {
                ((BaseConnection)this.realConnection).setClientInfo(properties);
            }
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean isValid(int n) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isValid(int timeout)");
        this.spyLogger.println("timeout = " + n);
        this.spyLogger.enter();
        try {
            bl = this.realConnection instanceof BaseConnectionWrapper ? ((BaseConnectionWrapper)this.realConnection).isValid(n) : ((BaseConnection)this.realConnection).isValid(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }
}

